/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.ternary;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ternary.TernaryColumnTransformer;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeEnum;

public abstract class CompareTernaryColumnTransformer
extends TernaryColumnTransformer {
    protected CompareTernaryColumnTransformer(Type returnType, ColumnTransformer firstColumnTransformer, ColumnTransformer secondColumnTransformer, ColumnTransformer thirdColumnTransformer) {
        super(returnType, firstColumnTransformer, secondColumnTransformer, thirdColumnTransformer);
    }

    @Override
    public void evaluate() {
        this.firstColumnTransformer.tryEvaluate();
        this.secondColumnTransformer.tryEvaluate();
        this.thirdColumnTransformer.tryEvaluate();
        int positionCount = this.firstColumnTransformer.getColumnCachePositionCount();
        Column firstColumn = this.firstColumnTransformer.getColumn();
        Column secondColumn = this.secondColumnTransformer.getColumn();
        Column thirdColumn = this.thirdColumnTransformer.getColumn();
        ColumnBuilder columnBuilder = this.returnType.createColumnBuilder(positionCount);
        this.doTransform(firstColumn, secondColumn, thirdColumn, columnBuilder, positionCount);
        this.initializeColumnCache(columnBuilder.build());
    }

    @Override
    protected final void checkType() {
        if (this.firstColumnTransformer.isReturnTypeNumeric() && this.secondColumnTransformer.isReturnTypeNumeric() && this.thirdColumnTransformer.isReturnTypeNumeric() || this.firstColumnTransformer.typeEquals(TypeEnum.BINARY) && this.secondColumnTransformer.typeEquals(TypeEnum.BINARY) && this.thirdColumnTransformer.typeEquals(TypeEnum.BINARY)) {
            return;
        }
        throw new UnsupportedOperationException("The Type of three subExpression should be all Numeric or Text");
    }

    protected abstract void doTransform(Column var1, Column var2, Column var3, ColumnBuilder var4, int var5);
}

