/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class SessionWindow
implements IWindow {
    private final long timeInterval;
    private final boolean ascending;
    private long timeValue;
    private long startTime;
    private long endTime;
    private long lastTsBlockTime;
    private boolean initializedTimeValue;

    public SessionWindow(long timeInterval, boolean ascending) {
        this.timeInterval = timeInterval;
        this.ascending = ascending;
    }

    @Override
    public Column getControlColumn(TsBlock tsBlock) {
        return tsBlock.getTimeColumn();
    }

    @Override
    public boolean satisfy(Column column, int index) {
        if (!this.initializedTimeValue) {
            return true;
        }
        if (index == 0) {
            return Math.abs(column.getLong(index) - this.lastTsBlockTime) <= this.timeInterval;
        }
        return Math.abs(column.getLong(index) - column.getLong(index - 1)) <= this.timeInterval;
    }

    @Override
    public void mergeOnePoint(Column[] controlTimeAndValueColumn, int index) {
        long currentTime = controlTimeAndValueColumn[0].getLong(index);
        if (!this.initializedTimeValue) {
            this.startTime = currentTime;
            this.endTime = currentTime;
            this.lastTsBlockTime = controlTimeAndValueColumn[0].getLong(0);
            this.timeValue = currentTime;
            this.initializedTimeValue = true;
            return;
        }
        if (this.startTime > currentTime) {
            this.startTime = currentTime;
        }
        if (this.endTime < currentTime) {
            this.endTime = currentTime;
        }
        this.timeValue = this.ascending ? Math.max(this.timeValue, currentTime) : Math.min(this.timeValue, currentTime);
        this.setLastTsBlockTime(this.timeValue);
    }

    @Override
    public boolean contains(Column column) {
        boolean contains;
        TimeColumn timeColumn = (TimeColumn)column;
        long minTime = Math.min(timeColumn.getStartTime(), timeColumn.getEndTime());
        long maxTime = Math.max(timeColumn.getStartTime(), timeColumn.getEndTime());
        boolean bl = contains = Math.abs(column.getLong(0) - this.lastTsBlockTime) < this.timeInterval && maxTime - minTime <= this.timeInterval;
        if (contains) {
            if (!this.initializedTimeValue) {
                this.startTime = Long.MAX_VALUE;
                this.endTime = Long.MIN_VALUE;
                this.lastTsBlockTime = column.getLong(0);
                this.timeValue = this.ascending ? maxTime : minTime;
                this.initializedTimeValue = true;
            }
            this.timeValue = this.ascending ? Math.max(this.timeValue, maxTime) : Math.min(this.timeValue, minTime);
            this.startTime = Math.min(this.startTime, minTime);
            this.endTime = Math.max(this.endTime, maxTime);
        }
        return contains;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public long getTimeValue() {
        return this.timeValue;
    }

    public void setTimeValue(long timeValue) {
        this.timeValue = timeValue;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setInitializedTimeValue(boolean initializedTimeValue) {
        this.initializedTimeValue = initializedTimeValue;
    }

    public void setLastTsBlockTime(long lastTsBlockTime) {
        this.lastTsBlockTime = lastTsBlockTime;
    }
}

