/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask.processor;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.pipe.execution.scheduler.PipeSubtaskScheduler;
import org.apache.iotdb.commons.pipe.task.EventSupplier;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.metric.PipeProcessorMetrics;
import org.apache.iotdb.db.pipe.task.connection.PipeEventCollector;
import org.apache.iotdb.db.pipe.task.subtask.PipeDataNodeSubtask;
import org.apache.iotdb.db.pipe.task.subtask.processor.PipeProcessorSubtaskWorkerManager;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeProcessorSubtask
extends PipeDataNodeSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeProcessorSubtask.class);
    private static final AtomicReference<PipeProcessorSubtaskWorkerManager> subtaskWorkerManager = new AtomicReference();
    private final EventSupplier inputEventSupplier;
    private final PipeProcessor pipeProcessor;
    private final PipeEventCollector outputEventCollector;
    private final String pipeName;
    private final int dataRegionId;

    public PipeProcessorSubtask(String taskID, long creationTime, String pipeName, int dataRegionId, EventSupplier inputEventSupplier, PipeProcessor pipeProcessor, PipeEventCollector outputEventCollector) {
        super(taskID, creationTime);
        this.pipeName = pipeName;
        this.dataRegionId = dataRegionId;
        this.inputEventSupplier = inputEventSupplier;
        this.pipeProcessor = pipeProcessor;
        this.outputEventCollector = outputEventCollector;
        PipeProcessorMetrics.getInstance().register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void bindExecutors(ListeningExecutorService subtaskWorkerThreadPoolExecutor, ExecutorService ignored, PipeSubtaskScheduler subtaskScheduler) {
        this.subtaskWorkerThreadPoolExecutor = subtaskWorkerThreadPoolExecutor;
        this.subtaskScheduler = subtaskScheduler;
        if (subtaskWorkerManager.get() == null) {
            Class<PipeProcessorSubtaskWorkerManager> clazz = PipeProcessorSubtaskWorkerManager.class;
            // MONITORENTER : org.apache.iotdb.db.pipe.task.subtask.processor.PipeProcessorSubtaskWorkerManager.class
            if (subtaskWorkerManager.get() == null) {
                subtaskWorkerManager.set(new PipeProcessorSubtaskWorkerManager(subtaskWorkerThreadPoolExecutor));
            }
            // MONITOREXIT : clazz
        }
        subtaskWorkerManager.get().schedule(this);
    }

    protected boolean executeOnce() throws Exception {
        if (this.isClosed.get()) {
            return false;
        }
        Event event = this.lastEvent != null ? this.lastEvent : this.inputEventSupplier.supply();
        this.setLastEvent(event);
        if (event == null || !this.outputEventCollector.isBufferQueueEmpty()) {
            return this.outputEventCollector.tryCollectBufferedEvents();
        }
        try {
            if (!this.isClosed.get()) {
                if (event instanceof TabletInsertionEvent) {
                    this.pipeProcessor.process((TabletInsertionEvent)event, (EventCollector)this.outputEventCollector);
                    PipeProcessorMetrics.getInstance().markTabletEvent(this.taskID);
                } else if (event instanceof TsFileInsertionEvent) {
                    this.pipeProcessor.process((TsFileInsertionEvent)event, (EventCollector)this.outputEventCollector);
                    PipeProcessorMetrics.getInstance().markTsFileEvent(this.taskID);
                } else if (event instanceof PipeHeartbeatEvent) {
                    this.pipeProcessor.process(event, (EventCollector)this.outputEventCollector);
                    ((PipeHeartbeatEvent)event).onProcessed();
                    PipeProcessorMetrics.getInstance().markPipeHeartbeatEvent(this.taskID);
                } else {
                    this.pipeProcessor.process(event, (EventCollector)this.outputEventCollector);
                }
            }
            this.releaseLastEvent(true);
        }
        catch (Exception e) {
            if (!this.isClosed.get()) {
                throw new PipeException(String.format("Exception in pipe process, subtask: %s, last event: %s, root cause: %s", this.taskID, this.lastEvent, ErrorHandlingUtils.getRootCause(e).getMessage()), (Throwable)e);
            }
            LOGGER.info("Exception in pipe event processing, ignored because pipe is dropped.", (Throwable)e);
            this.releaseLastEvent(false);
        }
        return true;
    }

    public void submitSelf() {
    }

    public boolean isStoppedByException() {
        return this.lastEvent instanceof EnrichedEvent && this.retryCount.get() > 5;
    }

    public void close() {
        PipeProcessorMetrics.getInstance().deregister(this.taskID);
        try {
            this.isClosed.set(true);
            this.pipeProcessor.close();
        }
        catch (Exception e) {
            LOGGER.info("Exception occurred when closing pipe processor subtask {}, root cause: {}", new Object[]{this.taskID, ErrorHandlingUtils.getRootCause(e).getMessage(), e});
        }
        finally {
            this.outputEventCollector.close();
            super.close();
        }
    }

    boolean isClosed() {
        return this.isClosed.get();
    }

    public boolean equals(Object that) {
        return that instanceof PipeProcessorSubtask && this.taskID.equals(((PipeProcessorSubtask)((Object)that)).taskID);
    }

    public int hashCode() {
        return this.taskID.hashCode();
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public int getDataRegionId() {
        return this.dataRegionId;
    }

    public int getTabletInsertionEventCount() {
        return this.outputEventCollector.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.outputEventCollector.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.outputEventCollector.getPipeHeartbeatEventCount();
    }
}

