/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.isession.pool;

import java.util.List;
import org.apache.iotdb.isession.ISession;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.pool.ISessionPool;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public class SessionDataSetWrapper
implements AutoCloseable {
    SessionDataSet sessionDataSet;
    ISession session;
    ISessionPool pool;

    public SessionDataSetWrapper(SessionDataSet sessionDataSet, ISession session, ISessionPool pool) {
        this.sessionDataSet = sessionDataSet;
        this.session = session;
        this.pool = pool;
    }

    public ISession getSession() {
        return this.session;
    }

    public int getBatchSize() {
        return this.sessionDataSet.getFetchSize();
    }

    public void setBatchSize(int batchSize) {
        this.sessionDataSet.setFetchSize(batchSize);
    }

    public boolean hasNext() throws IoTDBConnectionException, StatementExecutionException {
        boolean next = this.sessionDataSet.hasNext();
        if (!next) {
            this.pool.closeResultSet(this);
        }
        return next;
    }

    public RowRecord next() throws IoTDBConnectionException, StatementExecutionException {
        return this.sessionDataSet.next();
    }

    public SessionDataSet.DataIterator iterator() {
        return this.sessionDataSet.iterator();
    }

    public List<String> getColumnNames() {
        return this.sessionDataSet.getColumnNames();
    }

    public List<String> getColumnTypes() {
        return this.sessionDataSet.getColumnTypes();
    }

    @Override
    public void close() {
        this.pool.closeResultSet(this);
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public SessionDataSet getSessionDataSet() {
        return this.sessionDataSet;
    }

    public void setSessionDataSet(SessionDataSet sessionDataSet) {
        this.sessionDataSet = sessionDataSet;
    }
}

