/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import reactor.netty.Metrics;
import reactor.netty.channel.MeterKey;
import reactor.netty.http.MicrometerHttpMetricsRecorder;
import reactor.netty.http.server.HttpServerMeters;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.internal.util.MapUtils;
import reactor.util.annotation.Nullable;

final class MicrometerHttpServerMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpServerMetricsRecorder {
    static final MicrometerHttpServerMetricsRecorder INSTANCE = new MicrometerHttpServerMetricsRecorder();
    private static final String PROTOCOL_VALUE_HTTP = "http";
    private final ConcurrentMap<String, LongAdder> activeConnectionsCache = new ConcurrentHashMap<String, LongAdder>();
    private final ConcurrentMap<String, LongAdder> activeStreamsCache = new ConcurrentHashMap<String, LongAdder>();
    private final ConcurrentMap<String, DistributionSummary> dataReceivedCache = new ConcurrentHashMap<String, DistributionSummary>();
    private final ConcurrentMap<String, DistributionSummary> dataSentCache = new ConcurrentHashMap<String, DistributionSummary>();
    private final ConcurrentMap<String, Counter> errorsCache = new ConcurrentHashMap<String, Counter>();

    private MicrometerHttpServerMetricsRecorder() {
        super("reactor.netty.http.server", PROTOCOL_VALUE_HTTP);
    }

    @Override
    public void recordDataReceivedTime(String uri, String method, Duration time) {
        MeterKey meterKey = new MeterKey(uri, null, method, null);
        Timer dataReceivedTime = (Timer)MapUtils.computeIfAbsent((Map)this.dataReceivedTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpServerMetricsRecorder.filter((Meter)Timer.builder((String)(this.name() + ".data.received.time")).tags(new String[]{HttpServerMeters.DataReceivedTimeTags.URI.asString(), uri, HttpServerMeters.DataReceivedTimeTags.METHOD.asString(), method}).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(String uri, String method, String status, Duration time) {
        MeterKey meterKey = new MeterKey(uri, null, method, status);
        Timer dataSentTime = (Timer)MapUtils.computeIfAbsent((Map)this.dataSentTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpServerMetricsRecorder.filter((Meter)Timer.builder((String)(this.name() + ".data.sent.time")).tags(new String[]{HttpServerMeters.DataSentTimeTags.URI.asString(), uri, HttpServerMeters.DataSentTimeTags.METHOD.asString(), method, HttpServerMeters.DataSentTimeTags.STATUS.asString(), status}).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordResponseTime(String uri, String method, String status, Duration time) {
        Timer responseTime = this.getResponseTimeTimer(this.name() + ".response.time", uri, method, status);
        if (responseTime != null) {
            responseTime.record(time);
        }
    }

    @Nullable
    final Timer getResponseTimeTimer(String name, String uri, String method, String status) {
        MeterKey meterKey = new MeterKey(uri, null, method, status);
        return (Timer)MapUtils.computeIfAbsent((Map)this.responseTimeCache, (Object)meterKey, key -> (Timer)MicrometerHttpServerMetricsRecorder.filter((Meter)Timer.builder((String)name).tags(new String[]{"uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, String uri, long bytes) {
        DistributionSummary dataReceived = (DistributionSummary)MapUtils.computeIfAbsent(this.dataReceivedCache, (Object)uri, key -> (DistributionSummary)MicrometerHttpServerMetricsRecorder.filter((Meter)DistributionSummary.builder((String)(this.name() + ".data.received")).baseUnit(HttpServerMeters.HTTP_SERVER_DATA_RECEIVED.getBaseUnit()).tags(new String[]{HttpServerMeters.HttpServerMetersTags.URI.asString(), uri}).register(Metrics.REGISTRY)));
        if (dataReceived != null) {
            dataReceived.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, String uri, long bytes) {
        DistributionSummary dataSent = (DistributionSummary)MapUtils.computeIfAbsent(this.dataSentCache, (Object)uri, key -> (DistributionSummary)MicrometerHttpServerMetricsRecorder.filter((Meter)DistributionSummary.builder((String)(this.name() + ".data.sent")).baseUnit(HttpServerMeters.HTTP_SERVER_DATA_SENT.getBaseUnit()).tags(new String[]{HttpServerMeters.HttpServerMetersTags.URI.asString(), uri}).register(Metrics.REGISTRY)));
        if (dataSent != null) {
            dataSent.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, String uri) {
        Counter errors = (Counter)MapUtils.computeIfAbsent(this.errorsCache, (Object)uri, key -> (Counter)MicrometerHttpServerMetricsRecorder.filter((Meter)Counter.builder((String)(this.name() + ".errors")).tags(new String[]{HttpServerMeters.HttpServerMetersTags.URI.asString(), uri}).register(Metrics.REGISTRY)));
        if (errors != null) {
            errors.increment();
        }
    }

    @Override
    public void recordServerConnectionActive(SocketAddress localAddress) {
        LongAdder adder = this.getServerConnectionAdder(localAddress);
        if (adder != null) {
            adder.increment();
        }
    }

    @Override
    public void recordServerConnectionInactive(SocketAddress localAddress) {
        LongAdder adder = this.getServerConnectionAdder(localAddress);
        if (adder != null) {
            adder.decrement();
        }
    }

    @Override
    public void recordStreamOpened(SocketAddress localAddress) {
        LongAdder adder = this.getActiveStreamsAdder(localAddress);
        if (adder != null) {
            adder.increment();
        }
    }

    @Override
    public void recordStreamClosed(SocketAddress localAddress) {
        LongAdder adder = this.getActiveStreamsAdder(localAddress);
        if (adder != null) {
            adder.decrement();
        }
    }

    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
    }

    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
    }

    public void incrementErrorsCount(SocketAddress remoteAddress) {
    }

    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
    }

    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        throw new UnsupportedOperationException();
    }

    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    LongAdder getActiveStreamsAdder(SocketAddress localAddress) {
        String address = Metrics.formatSocketAddress((SocketAddress)localAddress);
        return (LongAdder)MapUtils.computeIfAbsent(this.activeStreamsCache, (Object)address, key -> {
            LongAdder activeStreamsAdder = new LongAdder();
            Gauge gauge = (Gauge)MicrometerHttpServerMetricsRecorder.filter((Meter)Gauge.builder((String)HttpServerMeters.STREAMS_ACTIVE.getName(), (Object)activeStreamsAdder, LongAdder::longValue).tags(new String[]{HttpServerMeters.StreamsActiveTags.URI.asString(), PROTOCOL_VALUE_HTTP, HttpServerMeters.StreamsActiveTags.LOCAL_ADDRESS.asString(), address}).register(Metrics.REGISTRY));
            return gauge != null ? activeStreamsAdder : null;
        });
    }

    @Nullable
    LongAdder getServerConnectionAdder(SocketAddress localAddress) {
        String address = Metrics.formatSocketAddress((SocketAddress)localAddress);
        return (LongAdder)MapUtils.computeIfAbsent(this.activeConnectionsCache, (Object)address, key -> {
            LongAdder activeConnectionsAdder = new LongAdder();
            Gauge gauge = (Gauge)MicrometerHttpServerMetricsRecorder.filter((Meter)Gauge.builder((String)HttpServerMeters.CONNECTIONS_ACTIVE.getName(), (Object)activeConnectionsAdder, LongAdder::longValue).tags(new String[]{HttpServerMeters.ConnectionsActiveTags.URI.asString(), PROTOCOL_VALUE_HTTP, HttpServerMeters.ConnectionsActiveTags.LOCAL_ADDRESS.asString(), address}).register(Metrics.REGISTRY));
            return gauge != null ? activeConnectionsAdder : null;
        });
    }
}

