/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class TimePartitionUtils {
    private static long timePartitionInterval = CommonDescriptor.getInstance().getConfig().getTimePartitionInterval();

    public static TTimePartitionSlot getTimePartitionSlot(long time) {
        TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot();
        if (time > 0L || time % timePartitionInterval == 0L) {
            timePartitionSlot.setStartTime(time / timePartitionInterval * timePartitionInterval);
        } else {
            timePartitionSlot.setStartTime((time / timePartitionInterval - 1L) * timePartitionInterval);
        }
        return timePartitionSlot;
    }

    public static long getTimePartitionInterval() {
        return timePartitionInterval;
    }

    public static long getTimePartitionUpperBound(long time) {
        long upperBoundOfTimePartition = time > 0L || time % timePartitionInterval == 0L ? (time / timePartitionInterval + 1L) * timePartitionInterval : time / timePartitionInterval * timePartitionInterval;
        return upperBoundOfTimePartition;
    }

    public static long getTimePartitionId(long time) {
        return time > 0L || time % timePartitionInterval == 0L ? time / timePartitionInterval : time / timePartitionInterval - 1L;
    }

    public static boolean satisfyPartitionId(long startTime, long endTime, long partitionId) {
        return TimePartitionUtils.getTimePartitionId(startTime) <= partitionId && TimePartitionUtils.getTimePartitionId(endTime) >= partitionId;
    }

    public static boolean satisfyPartitionStartTime(Filter timeFilter, long partitionStartTime) {
        return timeFilter == null || timeFilter.satisfyStartEndTime(partitionStartTime, partitionStartTime + timePartitionInterval - 1L);
    }

    public static boolean satisfyTimePartition(Filter timeFilter, long partitionId) {
        long partitionStartTime = partitionId * timePartitionInterval;
        return TimePartitionUtils.satisfyPartitionStartTime(timeFilter, partitionStartTime);
    }

    public static void setTimePartitionInterval(long timePartitionInterval) {
        TimePartitionUtils.timePartitionInterval = timePartitionInterval;
    }
}

