/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.core.uitls;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.iotdb.metrics.core.uitls.ObjectNameFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBMetricObjNameFactory
implements ObjectNameFactory {
    private static final char[] QUOTABLE_CHARS = new char[]{',', '=', ':', '\"'};
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBMetricObjNameFactory.class);

    private IoTDBMetricObjNameFactory() {
    }

    @Override
    public ObjectName createName(String type, String domain, String name) {
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("name", name);
            properties.put("type", type);
            ObjectName objectName = new ObjectName(domain, properties);
            if (objectName.isDomainPattern()) {
                domain = ObjectName.quote(domain);
            }
            if (objectName.isPropertyValuePattern("name") || this.shouldQuote(objectName.getKeyProperty("name"))) {
                properties.put("name", ObjectName.quote(name));
            }
            if (objectName.isPropertyValuePattern("type") || this.shouldQuote(objectName.getKeyProperty("type"))) {
                properties.put("type", ObjectName.quote(type));
            }
            objectName = new ObjectName(domain, properties);
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            try {
                return new ObjectName(domain, "name", ObjectName.quote(name));
            }
            catch (MalformedObjectNameException e1) {
                LOGGER.warn("IoTDB Metric: Unable to register {} {}", new Object[]{type, name, e1});
                throw new RuntimeException(e1);
            }
        }
    }

    private boolean shouldQuote(String value) {
        for (char quotableChar : QUOTABLE_CHARS) {
            if (value.indexOf(quotableChar) == -1) continue;
            return true;
        }
        return false;
    }

    public static IoTDBMetricObjNameFactory getInstance() {
        return IoTDBMetricObjNameFactoryHolder.INSTANCE;
    }

    private static class IoTDBMetricObjNameFactoryHolder {
        private static final IoTDBMetricObjNameFactory INSTANCE = new IoTDBMetricObjNameFactory();

        private IoTDBMetricObjNameFactoryHolder() {
        }
    }
}

