/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.factory;

import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.And;
import org.apache.iotdb.tsfile.read.filter.operator.Not;
import org.apache.iotdb.tsfile.read.filter.operator.Or;
import org.apache.iotdb.tsfile.utils.Preconditions;

public class FilterFactory {
    private FilterFactory() {
    }

    public static Filter and(Filter left, Filter right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new And(left, right);
    }

    public static Filter or(Filter left, Filter right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new Or(left, right);
    }

    public static Not not(Filter filter) {
        Preconditions.checkArgument(filter != null, "filter cannot be null");
        return new Not(filter);
    }
}

