/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.validate;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class TsFileOverlapValidationAndRepairTool {
    private static final Set<File> toMoveFiles = new HashSet<File>();
    private static final List<File> partitionDirsWhichHaveOverlapFiles = new ArrayList<File>();
    private static int overlapTsFileNum = 0;
    private static int totalTsFileNum = 0;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Please input sequence data dir path.");
            return;
        }
        List<String> sequenceDataDirs = TsFileOverlapValidationAndRepairTool.getDataDirs(args);
        TsFileOverlapValidationAndRepairTool.validateSequenceDataDirs(sequenceDataDirs);
        if (!TsFileOverlapValidationAndRepairTool.confirmMoveOverlapFilesToUnsequenceSpace()) {
            return;
        }
        TsFileOverlapValidationAndRepairTool.moveOverlapFilesToUnsequenceSpace(toMoveFiles);
    }

    private static List<String> getDataDirs(String[] args) {
        return Arrays.asList(args);
    }

    private static boolean confirmMoveOverlapFilesToUnsequenceSpace() {
        System.out.println("TimePartitions which have overlap files:");
        for (File partitionDirsWhichHaveOverlapFile : partitionDirsWhichHaveOverlapFiles) {
            System.out.println(partitionDirsWhichHaveOverlapFile.getAbsolutePath());
        }
        System.out.println();
        System.out.printf("Overlap tsfile num is %d, total tsfile num is %d\n", overlapTsFileNum, totalTsFileNum);
        System.out.println("Corresponding file num is " + toMoveFiles.size());
        if (overlapTsFileNum == 0) {
            return false;
        }
        System.out.println("Repair overlap tsfiles (y/n)");
        Scanner scanner = new Scanner(System.in);
        String input = scanner.nextLine();
        return "y".equals(input);
    }

    private static void moveOverlapFilesToUnsequenceSpace(Set<File> toMoveFiles) {
        for (File f : toMoveFiles) {
            boolean success;
            if (!f.exists()) {
                System.out.println(f.getAbsolutePath() + "is not exist in repairing");
                continue;
            }
            String filePath = f.getAbsolutePath();
            String replaceStr = File.separator + "sequence" + File.separator;
            String replaceToStr = File.separator + "unsequence" + File.separator;
            int sequenceDirIndex = filePath.indexOf(replaceStr);
            if (sequenceDirIndex == -1) continue;
            String moveToPath = filePath.substring(0, sequenceDirIndex) + replaceToStr + filePath.substring(sequenceDirIndex + replaceStr.length());
            File targetFile = new File(moveToPath);
            File targetParentFile = targetFile.getParentFile();
            if (targetParentFile.exists()) {
                targetParentFile.mkdirs();
            }
            if (!(success = f.renameTo(targetFile))) {
                System.out.println("Failed to repair " + f.getAbsolutePath());
            }
            System.out.println("Repair file " + targetFile.getName());
        }
    }

    private static void validateSequenceDataDirs(List<String> sequenceDataDirPaths) throws IOException {
        HashMap<String, List> partitionMap = new HashMap<String, List>();
        for (String string : sequenceDataDirPaths) {
            File sequenceDataDir = new File(string);
            if (!sequenceDataDir.exists() || sequenceDataDir.isFile()) {
                System.out.println(sequenceDataDir.getAbsolutePath() + " is not a correct path");
                continue;
            }
            for (File sg : Objects.requireNonNull(sequenceDataDir.listFiles())) {
                if (!sg.isDirectory()) continue;
                for (File dataRegionDir : Objects.requireNonNull(sg.listFiles())) {
                    if (!dataRegionDir.isDirectory()) continue;
                    for (File timePartitionDir : Objects.requireNonNull(dataRegionDir.listFiles())) {
                        if (!timePartitionDir.isDirectory()) continue;
                        String partitionKey = TsFileOverlapValidationAndRepairTool.calculateTimePartitionKey(sg.getName(), dataRegionDir.getName(), timePartitionDir.getName());
                        List partitionDirs = partitionMap.computeIfAbsent(partitionKey, v -> new ArrayList());
                        partitionDirs.add(timePartitionDir);
                    }
                }
            }
        }
        for (Map.Entry entry : partitionMap.entrySet()) {
            int overlapTsFileNumInCurrentTimePartition;
            String partitionName = (String)entry.getKey();
            List<TsFileResource> resources = TsFileOverlapValidationAndRepairTool.loadSortedTsFileResources((List)entry.getValue());
            if (resources.isEmpty() || (overlapTsFileNumInCurrentTimePartition = TsFileOverlapValidationAndRepairTool.checkTimePartitionHasOverlap(resources)) == 0) continue;
            System.out.println("TimePartition " + partitionName + " has overlap file, dir is " + entry.getValue());
            partitionDirsWhichHaveOverlapFiles.addAll((Collection)entry.getValue());
            overlapTsFileNum += overlapTsFileNumInCurrentTimePartition;
        }
    }

    private static String calculateTimePartitionKey(String storageGroup, String dataRegion, String timePartition) {
        return storageGroup + "-" + dataRegion + "-" + timePartition;
    }

    public static int checkTimePartitionHasOverlap(List<TsFileResource> resources) {
        int overlapTsFileNum = 0;
        HashMap<String, Long> deviceEndTimeMap = new HashMap<String, Long>();
        HashMap<String, TsFileResource> deviceLastExistTsFileMap = new HashMap<String, TsFileResource>();
        for (TsFileResource resource : resources) {
            Set<String> devices = resource.getDevices();
            boolean fileHasOverlap = false;
            for (String device : devices) {
                long deviceEndTimeInPreviousFile;
                long deviceStartTimeInCurrentFile = resource.getStartTime(device);
                if (deviceStartTimeInCurrentFile > resource.getEndTime(device) || !deviceEndTimeMap.containsKey(device) || deviceStartTimeInCurrentFile > (deviceEndTimeInPreviousFile = ((Long)deviceEndTimeMap.get(device)).longValue())) continue;
                System.out.printf("previous file: %s, current file: %s, device %s in previous file end time is %d, device in current file start time is %d\n", ((TsFileResource)deviceLastExistTsFileMap.get(device)).getTsFilePath(), resource.getTsFilePath(), device, deviceEndTimeInPreviousFile, deviceStartTimeInCurrentFile);
                fileHasOverlap = true;
                TsFileOverlapValidationAndRepairTool.recordOverlapTsFile(resource);
                ++overlapTsFileNum;
                break;
            }
            if (fileHasOverlap) continue;
            for (String device : devices) {
                deviceEndTimeMap.put(device, resource.getEndTime(device));
                deviceLastExistTsFileMap.put(device, resource);
            }
        }
        return overlapTsFileNum;
    }

    private static void recordOverlapTsFile(TsFileResource overlapFile) {
        String filePath = overlapFile.getTsFilePath();
        toMoveFiles.add(overlapFile.getTsFile());
        toMoveFiles.add(new File(filePath + ".resource"));
        ModificationFile modsFile = overlapFile.getModFile();
        if (modsFile.exists()) {
            toMoveFiles.add(new File(modsFile.getFilePath()));
        }
    }

    private static List<TsFileResource> loadSortedTsFileResources(List<File> timePartitionDirs) throws IOException {
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (File timePartitionDir : timePartitionDirs) {
            for (File tsfile : Objects.requireNonNull(timePartitionDir.listFiles())) {
                String filePath = tsfile.getAbsolutePath();
                if (filePath.endsWith(".inner-compaction.log") || filePath.endsWith(".cross-compaction.log")) {
                    System.out.println("Time partition " + timePartitionDir.getName() + " is skipped because a compaction is not finished");
                    return Collections.emptyList();
                }
                if (!filePath.endsWith(".tsfile") || !tsfile.isFile()) continue;
                String resourcePath = tsfile.getAbsolutePath() + ".resource";
                if (!new File(resourcePath).exists()) {
                    System.out.println(tsfile.getAbsolutePath() + " is skipped because resource file is not exist.");
                    continue;
                }
                TsFileResource resource = new TsFileResource(tsfile);
                resource.deserialize();
                resource.close();
                resources.add(resource);
            }
        }
        resources.sort((f1, f2) -> {
            int timeDiff = Long.compareUnsigned(Long.parseLong(f1.getTsFile().getName().split("-")[0]), Long.parseLong(f2.getTsFile().getName().split("-")[0]));
            return timeDiff == 0 ? Long.compareUnsigned(Long.parseLong(f1.getTsFile().getName().split("-")[1]), Long.parseLong(f2.getTsFile().getName().split("-")[1])) : timeDiff;
        });
        totalTsFileNum += resources.size();
        return resources;
    }
}

