/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;

public class MemPageReader
implements IPageReader {
    private final TsBlock tsBlock;
    private final IChunkMetadata chunkMetadata;
    private Filter recordFilter;
    private PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;

    public MemPageReader(TsBlock tsBlock, IChunkMetadata chunkMetadata, Filter recordFilter) {
        this.tsBlock = tsBlock;
        this.chunkMetadata = chunkMetadata;
        this.recordFilter = recordFilter;
    }

    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        TSDataType dataType = this.chunkMetadata.getDataType();
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)dataType, (boolean)ascending, (boolean)false);
        boolean[] satisfyInfo = this.buildSatisfyInfoArray();
        block8: for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
            if (!satisfyInfo[i]) continue;
            switch (dataType) {
                case BOOLEAN: {
                    batchData.putBoolean(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getBoolean(i));
                    continue block8;
                }
                case INT32: {
                    batchData.putInt(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getInt(i));
                    continue block8;
                }
                case INT64: {
                    batchData.putLong(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getLong(i));
                    continue block8;
                }
                case DOUBLE: {
                    batchData.putDouble(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getDouble(i));
                    continue block8;
                }
                case FLOAT: {
                    batchData.putFloat(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getFloat(i));
                    continue block8;
                }
                case TEXT: {
                    batchData.putBinary(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getBinary(i));
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.valueOf(dataType));
                }
            }
        }
        return batchData.flip();
    }

    public TsBlock getAllSatisfiedData() {
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.chunkMetadata.getDataType()));
        boolean[] satisfyInfo = this.buildSatisfyInfoArray();
        int readEndIndex = this.buildTimeColumn(builder, satisfyInfo);
        this.buildValueColumn(builder, satisfyInfo, readEndIndex);
        return builder.build();
    }

    private boolean[] buildSatisfyInfoArray() {
        if (this.recordFilter == null || this.recordFilter.allSatisfy((IMetadata)this)) {
            boolean[] satisfyInfo = new boolean[this.tsBlock.getPositionCount()];
            Arrays.fill(satisfyInfo, true);
            return satisfyInfo;
        }
        return this.recordFilter.satisfyTsBlock(this.tsBlock);
    }

    private int buildTimeColumn(TsBlockBuilder builder, boolean[] satisfyInfo) {
        int readEndIndex = this.tsBlock.getPositionCount();
        for (int rowIndex = 0; rowIndex < readEndIndex; ++rowIndex) {
            if (this.needSkipCurrentRow(satisfyInfo, rowIndex)) continue;
            if (this.paginationController.hasCurLimit()) {
                builder.getTimeColumnBuilder().writeLong(this.tsBlock.getTimeByIndex(rowIndex));
                builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            readEndIndex = rowIndex;
        }
        return readEndIndex;
    }

    private boolean needSkipCurrentRow(boolean[] satisfyInfo, int rowIndex) {
        if (!satisfyInfo[rowIndex]) {
            return true;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            satisfyInfo[rowIndex] = false;
            return true;
        }
        return false;
    }

    private void buildValueColumn(TsBlockBuilder builder, boolean[] satisfyInfo, int readEndIndex) {
        for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            Column valueColumn = this.tsBlock.getColumn(column);
            ColumnBuilder valueBuilder = builder.getColumnBuilder(column);
            for (int row = 0; row < readEndIndex; ++row) {
                if (!satisfyInfo[row]) continue;
                if (!valueColumn.isNull(row)) {
                    valueBuilder.write(valueColumn, row);
                    continue;
                }
                valueBuilder.appendNull();
            }
        }
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.chunkMetadata.getStatistics();
    }

    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.chunkMetadata.getTimeStatistics();
    }

    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        return this.chunkMetadata.getMeasurementStatistics(measurementIndex);
    }

    public boolean hasNullValue(int measurementIndex) {
        return this.chunkMetadata.hasNullValue(measurementIndex);
    }

    public void addRecordFilter(Filter filter) {
        this.recordFilter = FilterFactory.and((Filter)this.recordFilter, (Filter)filter);
    }

    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    public boolean isModified() {
        return false;
    }

    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
    }
}

