/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.io.LocalTextModificationAccessor;
import org.apache.iotdb.db.storageengine.dataregion.modification.io.ModificationReader;
import org.apache.iotdb.db.storageengine.dataregion.modification.io.ModificationWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModificationFile
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ModificationFile.class);
    public static final String FILE_SUFFIX = ".mods";
    public static final String COMPACT_SUFFIX = ".settle";
    public static final String COMPACTION_FILE_SUFFIX = ".compaction.mods";
    private boolean needVerify = true;
    private final ModificationWriter writer;
    private final ModificationReader reader;
    private String filePath;
    private final SecureRandom random = new SecureRandom();
    private static final long COMPACT_THRESHOLD = 0x100000L;
    private boolean hasCompacted = false;

    public ModificationFile(String filePath) {
        LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(filePath);
        this.writer = accessor;
        this.reader = accessor;
        this.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ModificationFile modificationFile = this;
        synchronized (modificationFile) {
            this.writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Modification mod) throws IOException {
        ModificationFile modificationFile = this;
        synchronized (modificationFile) {
            if (this.needVerify && new File(this.filePath).exists()) {
                this.writer.mayTruncateLastLine();
                this.needVerify = false;
            }
            this.writer.write(mod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeWithoutSync(Modification mod) throws IOException {
        ModificationFile modificationFile = this;
        synchronized (modificationFile) {
            if (this.needVerify && new File(this.filePath).exists()) {
                this.writer.mayTruncateLastLine();
                this.needVerify = false;
            }
            this.writer.writeWithOutSync(mod);
        }
    }

    @GuardedBy(value="TsFileResource-WriteLock")
    public void truncate(long size) {
        this.writer.truncate(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Modification> getModifications() {
        ModificationFile modificationFile = this;
        synchronized (modificationFile) {
            return this.reader.read();
        }
    }

    public Iterable<Modification> getModificationsIter() {
        return this.reader::getModificationIterator;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void remove() throws IOException {
        this.close();
        boolean deleted = FSFactoryProducer.getFSFactory().getFile(this.filePath).delete();
        if (!deleted) {
            logger.warn("Delete ModificationFile {} failed.", (Object)this.filePath);
        }
    }

    public boolean exists() {
        return new File(this.filePath).exists();
    }

    public ModificationFile createHardlink() {
        if (!this.exists()) {
            return null;
        }
        while (true) {
            String hardlinkSuffix = "." + System.currentTimeMillis() + "_" + this.random.nextLong();
            File hardlink = new File(this.filePath + hardlinkSuffix);
            try {
                Files.createLink(Paths.get(hardlink.getAbsolutePath(), new String[0]), Paths.get(this.filePath, new String[0]));
                return new ModificationFile(hardlink.getAbsolutePath());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            catch (IOException e) {
                logger.error("Cannot create hardlink for {}", (Object)this.filePath, (Object)e);
                return null;
            }
            break;
        }
    }

    public static ModificationFile getNormalMods(TsFileResource tsFileResource) {
        return new ModificationFile(tsFileResource.getTsFilePath() + FILE_SUFFIX);
    }

    public static ModificationFile getCompactionMods(TsFileResource tsFileResource) {
        return new ModificationFile(tsFileResource.getTsFilePath() + COMPACTION_FILE_SUFFIX);
    }

    public long getSize() {
        File file = new File(this.filePath);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    public void compact() {
        long originFileSize = this.getSize();
        if (originFileSize > 0x100000L && !this.hasCompacted) {
            Map<String, List<Modification>> pathModificationMap = this.getModifications().stream().collect(Collectors.groupingBy(Modification::getPathString));
            String newModsFileName = this.filePath + COMPACT_SUFFIX;
            ArrayList<Modification> allSettledModifications = new ArrayList<Modification>();
            try (ModificationFile compactedModificationFile = new ModificationFile(newModsFileName);){
                Set<Map.Entry<String, List<Modification>>> modificationsEntrySet = pathModificationMap.entrySet();
                for (Map.Entry<String, List<Modification>> modificationEntry : modificationsEntrySet) {
                    List<Modification> settledModifications = ModificationFile.sortAndMerge(modificationEntry.getValue());
                    for (Modification settledModification : settledModifications) {
                        compactedModificationFile.write(settledModification);
                    }
                    allSettledModifications.addAll(settledModifications);
                }
            }
            catch (IOException e) {
                logger.error("compact mods file exception of {}", (Object)this.filePath, (Object)e);
            }
            try {
                this.remove();
                Files.move(new File(newModsFileName).toPath(), new File(this.filePath).toPath(), new CopyOption[0]);
                logger.info("{} settle successful", (Object)this.filePath);
                if (this.getSize() > 0x100000L) {
                    logger.warn("After the mod file is settled, the file size is still greater than 1M,the size of the file before settle is {},after settled the file size is {}", (Object)originFileSize, (Object)this.getSize());
                }
            }
            catch (IOException e) {
                logger.error("remove origin file or rename new mods file error.", (Throwable)e);
            }
            this.hasCompacted = true;
        }
    }

    public static List<Modification> sortAndMerge(List<Modification> modifications) {
        modifications.sort((o1, o2) -> {
            if (!o1.getType().equals((Object)o2.getType())) {
                return o1.getType().compareTo(o2.getType());
            }
            if (!o1.getPath().equals((Object)o2.getPath())) {
                return o1.getPath().compareTo((Path)o2.getPath());
            }
            if (o1.getFileOffset() != o2.getFileOffset()) {
                return (int)(o1.getFileOffset() - o2.getFileOffset());
            }
            if (o1.getType() == Modification.Type.DELETION) {
                Deletion del1 = (Deletion)o1;
                Deletion del2 = (Deletion)o2;
                return del1.getTimeRange().compareTo(del2.getTimeRange());
            }
            throw new IllegalArgumentException();
        });
        ArrayList<Modification> result = new ArrayList<Modification>();
        if (!modifications.isEmpty()) {
            Deletion current = ((Deletion)modifications.get(0)).clone();
            for (int i = 1; i < modifications.size(); ++i) {
                Deletion del = (Deletion)modifications.get(i);
                if (current.intersects(del)) {
                    current.merge(del);
                    continue;
                }
                result.add(current);
                current = del.clone();
            }
            result.add(current);
        }
        return result;
    }
}

