/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;

public class RepairUnsortedFileCompactionEstimator
extends AbstractInnerSpaceEstimator {
    @Override
    protected long calculatingMetadataMemoryCost(CompactionTaskInfo taskInfo) {
        long cost = 0L;
        cost += Math.min(taskInfo.getTotalChunkMetadataSize(), (long)taskInfo.getMaxChunkMetadataNumInDevice() * taskInfo.getMaxChunkMetadataSize());
        long sizeForFileWriter = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion());
        return cost += sizeForFileWriter;
    }

    @Override
    protected long calculatingDataMemoryCost(CompactionTaskInfo taskInfo) {
        if (taskInfo.getTotalChunkNum() == 0L) {
            return taskInfo.getModificationFileSize();
        }
        long maxConcurrentSeriesNum = Math.max(this.config.getSubCompactionTaskNum(), taskInfo.getMaxConcurrentSeriesNum());
        long averageUncompressedChunkSize = taskInfo.getTotalFileSize() * this.compressionRatio / taskInfo.getTotalChunkNum();
        long maxConcurrentSeriesSize = averageUncompressedChunkSize * maxConcurrentSeriesNum * (long)taskInfo.getMaxChunkMetadataNumInSeries() / this.compressionRatio;
        long maxTargetChunkWriterSize = this.config.getTargetChunkSize() * maxConcurrentSeriesNum;
        long targetChunkWriterSize = Math.min(maxConcurrentSeriesSize, maxTargetChunkWriterSize);
        long inMemorySortedDataSize = averageUncompressedChunkSize * Math.min((long)taskInfo.getMaxChunkMetadataNumInDevice(), (long)taskInfo.getMaxChunkMetadataNumInSeries() * maxConcurrentSeriesNum);
        return targetChunkWriterSize + inMemorySortedDataSize + taskInfo.getModificationFileSize();
    }
}

