/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule;

import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;

public class CompactionTaskQueue
extends FixedPriorityBlockingQueue<AbstractCompactionTask> {
    public CompactionTaskQueue(int maxSize, Comparator<AbstractCompactionTask> comparator) {
        super(maxSize, comparator);
    }

    @Override
    public AbstractCompactionTask take() throws InterruptedException {
        AbstractCompactionTask task;
        ReentrantLock lock = this.lock;
        while (true) {
            task = null;
            lock.lockInterruptibly();
            try {
                while (this.queue.isEmpty()) {
                    this.notEmpty.await();
                }
                task = (AbstractCompactionTask)this.queue.pollFirst();
            }
            finally {
                lock.unlock();
            }
            boolean prepareTaskSuccess = this.prepareTask(task);
            if (prepareTaskSuccess) break;
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return task;
    }

    private boolean prepareTask(AbstractCompactionTask task) throws InterruptedException {
        if (task == null) {
            return false;
        }
        if (!this.checkTaskValid(task)) {
            this.dropCompactionTask(task);
            return false;
        }
        if (!task.tryOccupyResourcesForRunning()) {
            this.put(task);
            return false;
        }
        if (!this.transitTaskFileStatus(task)) {
            this.dropCompactionTask(task);
            return false;
        }
        return true;
    }

    private void dropCompactionTask(AbstractCompactionTask task) {
        task.resetCompactionCandidateStatusForAllSourceFiles();
        task.handleTaskCleanup();
        task.releaseOccupiedResources();
    }

    private boolean checkTaskValid(AbstractCompactionTask task) {
        return task.isCompactionAllowed() && task.getEstimatedMemoryCost() <= SystemInfo.getInstance().getMemorySizeForCompaction() && task.getProcessedFileNum() <= SystemInfo.getInstance().getTotalFileLimitForCompaction();
    }

    private boolean transitTaskFileStatus(AbstractCompactionTask task) {
        try {
            task.transitSourceFilesToMerging();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

