/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Phaser;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InsertionCrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ICompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ICrossSpaceSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.InsertionCrossCompactionTaskResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final ReadWriteLock compactionTaskSelectionLock = new ReentrantReadWriteLock();

    private CompactionScheduler() {
    }

    public static void sharedLockCompactionSelection() {
        compactionTaskSelectionLock.readLock().lock();
    }

    public static void sharedUnlockCompactionSelection() {
        compactionTaskSelectionLock.readLock().unlock();
    }

    public static void exclusiveLockCompactionSelection() {
        compactionTaskSelectionLock.writeLock().lock();
    }

    public static void exclusiveUnlockCompactionSelection() {
        compactionTaskSelectionLock.writeLock().unlock();
    }

    public static int scheduleCompaction(TsFileManager tsFileManager, long timePartition, CompactionScheduleSummary summary) throws InterruptedException {
        if (!tsFileManager.isAllowCompaction()) {
            return 0;
        }
        int trySubmitCount = 0;
        trySubmitCount += CompactionScheduler.tryToSubmitCrossSpaceCompactionTask(tsFileManager, timePartition, summary);
        trySubmitCount += CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager, timePartition, true, summary);
        return trySubmitCount += CompactionScheduler.tryToSubmitInnerSpaceCompactionTask(tsFileManager, timePartition, false, summary);
    }

    public static void scheduleCompaction(TsFileManager tsFileManager, long timePartition) throws InterruptedException {
        CompactionScheduler.scheduleCompaction(tsFileManager, timePartition, new CompactionScheduleSummary());
    }

    public static int scheduleInsertionCompaction(TsFileManager tsFileManager, long timePartition, Phaser insertionTaskPhaser) throws InterruptedException {
        if (!tsFileManager.isAllowCompaction()) {
            return 0;
        }
        int trySubmitCount = 0;
        return trySubmitCount += CompactionScheduler.tryToSubmitInsertionCompactionTask(tsFileManager, timePartition, insertionTaskPhaser);
    }

    public static int tryToSubmitInnerSpaceCompactionTask(TsFileManager tsFileManager, long timePartition, boolean sequence, CompactionScheduleSummary summary) throws InterruptedException {
        if (!config.isEnableSeqSpaceCompaction() && sequence || !config.isEnableUnseqSpaceCompaction() && !sequence) {
            return 0;
        }
        String storageGroupName = tsFileManager.getStorageGroupName();
        String dataRegionId = tsFileManager.getDataRegionId();
        ICompactionSelector innerSpaceCompactionSelector = sequence ? config.getInnerSequenceCompactionSelector().createInstance(storageGroupName, dataRegionId, timePartition, tsFileManager) : config.getInnerUnsequenceCompactionSelector().createInstance(storageGroupName, dataRegionId, timePartition, tsFileManager);
        long startTime = System.currentTimeMillis();
        List<InnerSpaceCompactionTask> innerSpaceTaskList = innerSpaceCompactionSelector.selectInnerSpaceTask(sequence ? tsFileManager.getOrCreateSequenceListByTimePartition(timePartition) : tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition));
        CompactionMetrics.getInstance().updateCompactionTaskSelectionTimeCost(sequence ? CompactionTaskType.INNER_SEQ : CompactionTaskType.INNER_UNSEQ, System.currentTimeMillis() - startTime);
        int trySubmitCount = CompactionScheduler.addTaskToWaitingQueue(innerSpaceTaskList);
        summary.incrementSubmitTaskNum(sequence ? CompactionTaskType.INNER_SEQ : CompactionTaskType.INNER_UNSEQ, trySubmitCount);
        return trySubmitCount;
    }

    private static int addTaskToWaitingQueue(List<? extends AbstractCompactionTask> tasks) throws InterruptedException {
        int trySubmitCount = 0;
        for (AbstractCompactionTask abstractCompactionTask : tasks) {
            if (!CompactionScheduler.canAddTaskToWaitingQueue(abstractCompactionTask) || !CompactionTaskManager.getInstance().addTaskToWaitingQueue(abstractCompactionTask)) continue;
            ++trySubmitCount;
        }
        return trySubmitCount;
    }

    private static boolean canAddTaskToWaitingQueue(AbstractCompactionTask task) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long fileNumLimitForCompaction = SystemInfo.getInstance().getTotalFileLimitForCompaction();
        if ((long)task.getProcessedFileNum() > fileNumLimitForCompaction) {
            return false;
        }
        if (!task.isDiskSpaceCheckPassed()) {
            LOGGER.info("Compaction task start check failed because disk free ratio is less than disk_space_warning_threshold");
            return false;
        }
        return true;
    }

    private static int tryToSubmitInsertionCompactionTask(TsFileManager tsFileManager, long timePartition, Phaser insertionTaskPhaser) throws InterruptedException {
        String dataRegionId;
        if (!config.isEnableCrossSpaceCompaction()) {
            return 0;
        }
        String logicalStorageGroupName = tsFileManager.getStorageGroupName();
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector(logicalStorageGroupName, dataRegionId = tsFileManager.getDataRegionId(), timePartition, tsFileManager);
        List<CrossCompactionTaskResource> selectedTasks = selector.selectInsertionCrossSpaceTask(tsFileManager.getOrCreateSequenceListByTimePartition(timePartition), tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition));
        if (selectedTasks.isEmpty()) {
            return 0;
        }
        InsertionCrossSpaceCompactionTask task = new InsertionCrossSpaceCompactionTask(insertionTaskPhaser, timePartition, tsFileManager, (InsertionCrossCompactionTaskResource)selectedTasks.get(0), tsFileManager.getNextCompactionTaskId());
        insertionTaskPhaser.register();
        if (!CompactionTaskManager.getInstance().addTaskToWaitingQueue(task)) {
            insertionTaskPhaser.arrive();
            return 0;
        }
        return 1;
    }

    private static int tryToSubmitCrossSpaceCompactionTask(TsFileManager tsFileManager, long timePartition, CompactionScheduleSummary summary) throws InterruptedException {
        if (!config.isEnableCrossSpaceCompaction()) {
            return 0;
        }
        String logicalStorageGroupName = tsFileManager.getStorageGroupName();
        String dataRegionId = tsFileManager.getDataRegionId();
        ICrossSpaceSelector crossSpaceCompactionSelector = config.getCrossCompactionSelector().createInstance(logicalStorageGroupName, dataRegionId, timePartition, tsFileManager);
        List<CrossCompactionTaskResource> taskList = crossSpaceCompactionSelector.selectCrossSpaceTask(tsFileManager.getOrCreateSequenceListByTimePartition(timePartition), tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition));
        List memoryCost = taskList.stream().map(CrossCompactionTaskResource::getTotalMemoryCost).collect(Collectors.toList());
        int trySubmitCount = 0;
        int size = taskList.size();
        for (int i = 0; i < size; ++i) {
            trySubmitCount = CompactionScheduler.addTaskToWaitingQueue(Collections.singletonList(new CrossSpaceCompactionTask(timePartition, tsFileManager, taskList.get(i).getSeqFiles(), taskList.get(i).getUnseqFiles(), IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer().createInstance(), (Long)memoryCost.get(i), tsFileManager.getNextCompactionTaskId())));
        }
        summary.incrementSubmitTaskNum(CompactionTaskType.CROSS, trySubmitCount);
        return trySubmitCount;
    }
}

