/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.RepairUnsortedFileCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;

public class RepairUnsortedFileCompactionPerformer
extends ReadPointCompactionPerformer {
    private final boolean rewriteFile;

    public RepairUnsortedFileCompactionPerformer(boolean rewriteFile) {
        this.rewriteFile = rewriteFile;
    }

    @Override
    protected AbstractCompactionWriter getCompactionWriter(List<TsFileResource> seqFileResources, List<TsFileResource> unseqFileResources, List<TsFileResource> targetFileResources) throws IOException {
        return new RepairUnsortedFileCompactionWriter(targetFileResources.get(0));
    }

    @Override
    public void perform() throws Exception {
        if (this.rewriteFile) {
            super.perform();
        } else {
            this.prepareTargetFile();
        }
    }

    private void prepareTargetFile() throws IOException {
        TsFileResource seqSourceFile = (TsFileResource)this.seqFiles.get(0);
        TsFileResource targetFile = (TsFileResource)this.targetFiles.get(0);
        Files.createLink(targetFile.getTsFile().toPath(), seqSourceFile.getTsFile().toPath());
        ITimeIndex timeIndex = seqSourceFile.getTimeIndex();
        if (timeIndex instanceof DeviceTimeIndex) {
            targetFile.setTimeIndex(timeIndex);
        } else {
            targetFile.setTimeIndex(seqSourceFile.buildDeviceTimeIndex());
        }
        if (seqSourceFile.modFileExists()) {
            Files.createLink(new File(seqSourceFile.getCompactionModFile().getFilePath()).toPath(), new File(seqSourceFile.getModFile().getFilePath()).toPath());
        }
    }

    @Override
    public void setSourceFiles(List<TsFileResource> sourceFiles) {
        if (sourceFiles.get(0).isSeq()) {
            this.seqFiles = sourceFiles;
        } else {
            this.unseqFiles = sourceFiles;
        }
    }
}

