/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.quota.ExceedQuotaException;
import org.apache.iotdb.db.pipe.extractor.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.QueryResourceMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCache;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.service.SettleService;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionInfo;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.HashLastFlushTimeMap;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.storageengine.dataregion.ILastFlushTimeMap;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover.CompactionRecoverManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.flush.CloseFileListener;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushListener;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushStatus;
import org.apache.iotdb.db.storageengine.dataregion.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessorInfo;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.VersionController;
import org.apache.iotdb.db.storageengine.dataregion.utils.validate.TsFileValidator;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.WALRecoverManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.file.SealedTsFileRecoverPerformer;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALRecoverListener;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.iotdb.db.storageengine.rescon.memory.TimePartitionInfo;
import org.apache.iotdb.db.storageengine.rescon.memory.TimePartitionManager;
import org.apache.iotdb.db.storageengine.rescon.memory.TsFileResourceManager;
import org.apache.iotdb.db.storageengine.rescon.quotas.DataNodeSpaceQuotaManager;
import org.apache.iotdb.db.tools.settle.TsFileAndModSettleTool;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.FSUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRegion
implements IDataRegionForQuery {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final int MERGE_MOD_START_VERSION_NUM = 1;
    private static final Logger logger = LoggerFactory.getLogger(DataRegion.class);
    private final boolean enableMemControl = config.isEnableMemControl();
    private final ReadWriteLock insertLock = new ReentrantReadWriteLock();
    private final Condition deletedCondition = this.insertLock.writeLock().newCondition();
    private volatile boolean deleted = false;
    private final Object closeStorageGroupCondition = new Object();
    private final ReadWriteLock closeQueryLock = new ReentrantReadWriteLock();
    private final TreeMap<Long, TsFileProcessor> workSequenceTsFileProcessors = new TreeMap();
    private final TreeMap<Long, TsFileProcessor> workUnsequenceTsFileProcessors = new TreeMap();
    private final Set<TsFileProcessor> closingSequenceTsFileProcessor = ConcurrentHashMap.newKeySet();
    private final Set<TsFileProcessor> closingUnSequenceTsFileProcessor = ConcurrentHashMap.newKeySet();
    private final String dataRegionId;
    private final String databaseName;
    private File storageGroupSysDir;
    private final TsFileManager tsFileManager;
    private final TsFileResourceManager tsFileResourceManager = TsFileResourceManager.getInstance();
    private final HashMap<Long, VersionController> timePartitionIdVersionControllerMap = new HashMap();
    private long dataTTL = Long.MAX_VALUE;
    private final FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private TsFileFlushPolicy fileFlushPolicy;
    private Map<Long, Long> partitionMaxFileVersions = new ConcurrentHashMap<Long, Long>();
    private final DataRegionInfo dataRegionInfo = new DataRegionInfo(this);
    private boolean isReady = false;
    private List<CloseFileListener> customCloseFileListeners = Collections.emptyList();
    private List<FlushListener> customFlushListeners = Collections.emptyList();
    private ILastFlushTimeMap lastFlushTimeMap;
    private String insertWriteLockHolder = "";
    private final AtomicBoolean isCompactionSelecting = new AtomicBoolean(false);
    private static final QueryResourceMetricSet QUERY_RESOURCE_METRIC_SET = QueryResourceMetricSet.getInstance();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public DataRegion(String systemDir, String dataRegionId, TsFileFlushPolicy fileFlushPolicy, String databaseName) throws DataRegionException {
        this.dataRegionId = dataRegionId;
        this.databaseName = databaseName;
        this.fileFlushPolicy = fileFlushPolicy;
        this.storageGroupSysDir = SystemFileFactory.INSTANCE.getFile(systemDir, dataRegionId);
        this.tsFileManager = new TsFileManager(databaseName, dataRegionId, this.storageGroupSysDir.getPath());
        if (this.storageGroupSysDir.mkdirs()) {
            logger.info("Database system Directory {} doesn't exist, create it", (Object)this.storageGroupSysDir.getPath());
        } else if (!this.storageGroupSysDir.exists()) {
            logger.error("create database system Directory {} failed", (Object)this.storageGroupSysDir.getPath());
        }
        this.lastFlushTimeMap = new HashLastFlushTimeMap();
        if (config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && !StorageEngine.getInstance().isAllSgReady()) {
            logger.debug("Skip recovering data region {}[{}] when consensus protocol is ratis and storage storageengine is not ready.", (Object)databaseName, (Object)dataRegionId);
            for (String fileFolder : TierManager.getInstance().getAllFilesFolders()) {
                File dataRegionFolder = this.fsFactory.getFile(fileFolder, databaseName + File.separator + dataRegionId);
                try {
                    this.fsFactory.deleteDirectory(dataRegionFolder.getPath());
                }
                catch (IOException e) {
                    logger.error("Exception occurs when deleting data region folder for {}-{}", new Object[]{databaseName, dataRegionId, e});
                }
                if (FSUtils.getFSType((File)dataRegionFolder) != FSType.LOCAL) continue;
                dataRegionFolder.mkdirs();
            }
        } else {
            this.recover();
        }
        MetricService.getInstance().addMetricSet((IMetricSet)new DataRegionMetrics(this));
    }

    public DataRegion(String databaseName, String id) {
        this.databaseName = databaseName;
        this.dataRegionId = id;
        this.tsFileManager = new TsFileManager(databaseName, id, "");
        this.partitionMaxFileVersions = new HashMap<Long, Long>();
        this.partitionMaxFileVersions.put(0L, 0L);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    private Map<Long, List<TsFileResource>> splitResourcesByPartition(List<TsFileResource> resources) {
        TreeMap<Long, List<TsFileResource>> ret = new TreeMap<Long, List<TsFileResource>>();
        for (TsFileResource resource : resources) {
            ret.computeIfAbsent(resource.getTimePartition(), l -> new ArrayList()).add(resource);
        }
        return ret;
    }

    private void recover() throws DataRegionException {
        try {
            this.recoverCompaction();
        }
        catch (Exception e) {
            WALRecoverManager.getInstance().getAllDataRegionScannedLatch().countDownWithException(e.getMessage());
            throw new DataRegionException(e);
        }
        try {
            WALRecoverListener recoverListener;
            Iterator<Map.Entry<Long, List<TsFileResource>>> tsFileResource;
            List<TsFileResource> tmpSeqTsFiles = this.getAllFiles(TierManager.getInstance().getAllLocalSequenceFileFolders());
            List<TsFileResource> tmpUnseqTsFiles = this.getAllFiles(TierManager.getInstance().getAllLocalUnSequenceFileFolders());
            DataRegionRecoveryContext dataRegionRecoveryContext = new DataRegionRecoveryContext((long)tmpSeqTsFiles.size() + (long)tmpUnseqTsFiles.size());
            Map<Long, List<TsFileResource>> partitionTmpSeqTsFiles = this.splitResourcesByPartition(tmpSeqTsFiles);
            Map<Long, List<TsFileResource>> partitionTmpUnseqTsFiles = this.splitResourcesByPartition(tmpUnseqTsFiles);
            ArrayList<WALRecoverListener> recoverListeners = new ArrayList<WALRecoverListener>();
            for (List<TsFileResource> value : partitionTmpSeqTsFiles.values()) {
                for (TsFileResource resource : value) {
                    if (!resource.resourceFileExists()) continue;
                    FileMetrics.getInstance().addTsFile(resource.getDatabaseName(), resource.getDataRegionId(), resource.getTsFile().length(), true, resource.getTsFile().getName());
                    if (!resource.getModFile().exists()) continue;
                    FileMetrics.getInstance().increaseModFileNum(1);
                    FileMetrics.getInstance().increaseModFileSize(resource.getModFile().getSize());
                }
                while (!value.isEmpty() && !((TsFileResource)((Object)(tsFileResource = value.get(value.size() - 1)))).resourceFileExists()) {
                    value.remove(value.size() - 1);
                    recoverListener = this.recoverUnsealedTsFile((TsFileResource)((Object)tsFileResource), dataRegionRecoveryContext, true);
                    if (recoverListener == null) continue;
                    recoverListeners.add(recoverListener);
                }
            }
            for (List<TsFileResource> value : partitionTmpUnseqTsFiles.values()) {
                tsFileResource = value.iterator();
                while (tsFileResource.hasNext()) {
                    TsFileResource resource;
                    resource = tsFileResource.next();
                    if (resource.resourceFileExists()) {
                        FileMetrics.getInstance().addTsFile(resource.getDatabaseName(), resource.getDataRegionId(), resource.getTsFile().length(), false, resource.getTsFile().getName());
                    }
                    if (!resource.getModFile().exists()) continue;
                    FileMetrics.getInstance().increaseModFileNum(1);
                    FileMetrics.getInstance().increaseModFileSize(resource.getModFile().getSize());
                }
                while (!value.isEmpty() && !((TsFileResource)((Object)(tsFileResource = value.get(value.size() - 1)))).resourceFileExists()) {
                    value.remove(value.size() - 1);
                    recoverListener = this.recoverUnsealedTsFile((TsFileResource)((Object)tsFileResource), dataRegionRecoveryContext, false);
                    if (recoverListener == null) continue;
                    recoverListeners.add(recoverListener);
                }
            }
            WALRecoverManager.getInstance().getAllDataRegionScannedLatch().countDown();
            if (!partitionTmpSeqTsFiles.isEmpty() || !partitionTmpUnseqTsFiles.isEmpty()) {
                long latestPartitionId = Long.MIN_VALUE;
                if (!partitionTmpSeqTsFiles.isEmpty()) {
                    latestPartitionId = (Long)((TreeMap)partitionTmpSeqTsFiles).lastKey();
                }
                if (!partitionTmpUnseqTsFiles.isEmpty()) {
                    latestPartitionId = Math.max(latestPartitionId, (Long)((TreeMap)partitionTmpUnseqTsFiles).lastKey());
                }
                for (Map.Entry<Long, List<TsFileResource>> partitionFiles : partitionTmpSeqTsFiles.entrySet()) {
                    this.recoverFilesInPartition((Long)partitionFiles.getKey(), dataRegionRecoveryContext, partitionFiles.getValue(), true);
                }
                for (Map.Entry<Long, List<TsFileResource>> partitionFiles : partitionTmpUnseqTsFiles.entrySet()) {
                    this.recoverFilesInPartition(partitionFiles.getKey(), dataRegionRecoveryContext, partitionFiles.getValue(), false);
                }
                if (config.isEnableSeparateData()) {
                    TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), latestPartitionId, false, Long.MAX_VALUE, this.lastFlushTimeMap.getMemSize(latestPartitionId)));
                }
            }
            for (WALRecoverListener recoverListener2 : recoverListeners) {
                if (recoverListener2.waitForResult() == AbstractResultListener.Status.FAILURE) {
                    logger.error("Fail to recover unsealed TsFile {}, skip it.", (Object)recoverListener2.getFilePath(), (Object)recoverListener2.getCause());
                }
                dataRegionRecoveryContext.incrementRecoveredFilesNum();
            }
            dataRegionRecoveryContext.recoverPerformers.sort((p1, p2) -> this.compareFileName(p1.getTsFileResource().getTsFile(), p2.getTsFileResource().getTsFile()));
            for (UnsealedTsFileRecoverPerformer recoverPerformer : dataRegionRecoveryContext.recoverPerformers) {
                this.recoverUnsealedTsFileCallBack(recoverPerformer);
            }
            for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
                long partitionNum = resource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, resource.getVersion());
            }
            for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
                long partitionNum = resource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, resource.getVersion());
            }
        }
        catch (IOException e) {
            WALRecoverManager.getInstance().getAllDataRegionScannedLatch().countDownWithException(e.getMessage());
            throw new DataRegionException(e);
        }
        this.initCompactionSchedule();
        if (StorageEngine.getInstance().isAllSgReady()) {
            logger.info("The data region {}[{}] is created successfully", (Object)this.databaseName, (Object)this.dataRegionId);
        } else {
            logger.info("The data region {}[{}] is recovered successfully", (Object)this.databaseName, (Object)this.dataRegionId);
        }
    }

    private void updateLastFlushTime(TsFileResource resource, boolean isSeq) {
        long timePartitionId = resource.getTimePartition();
        HashMap<String, Long> endTimeMap = new HashMap<String, Long>();
        for (String deviceId : resource.getDevices()) {
            long endTime = resource.getEndTime(deviceId);
            endTimeMap.put(deviceId, endTime);
        }
        if (config.isEnableSeparateData()) {
            this.lastFlushTimeMap.updateMultiDeviceFlushedTime(timePartitionId, endTimeMap);
        }
        if (CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            this.lastFlushTimeMap.updateMultiDeviceGlobalFlushedTime(endTimeMap);
        }
    }

    public void initCompactionSchedule() {
        if (!(config.isEnableSeqSpaceCompaction() || config.isEnableUnseqSpaceCompaction() || config.isEnableCrossSpaceCompaction())) {
            return;
        }
        CompactionScheduleTaskManager.getInstance().registerDataRegion(this);
    }

    private void recoverCompaction() {
        CompactionRecoverManager compactionRecoverManager = new CompactionRecoverManager(this.tsFileManager, this.databaseName, this.dataRegionId);
        compactionRecoverManager.recoverInnerSpaceCompaction(true);
        compactionRecoverManager.recoverInnerSpaceCompaction(false);
        compactionRecoverManager.recoverCrossSpaceCompaction();
    }

    private void updatePartitionFileVersion(long partitionNum, long fileVersion) {
        this.partitionMaxFileVersions.compute(partitionNum, (key, oldVersion) -> oldVersion == null || fileVersion > oldVersion ? fileVersion : oldVersion);
    }

    private List<TsFileResource> getAllFiles(List<String> folders) throws IOException, DataRegionException {
        HashMap<String, File> tsFilePartitionPath2File = new HashMap<String, File>();
        for (String baseDir : folders) {
            File fileFolder = this.fsFactory.getFile(baseDir + File.separator + this.databaseName, this.dataRegionId);
            if (!fileFolder.exists()) continue;
            this.continueFailedRenames(fileFolder, ".temp");
            File[] subFiles = fileFolder.listFiles();
            if (subFiles == null) continue;
            for (File partitionFolder : subFiles) {
                File[] tsFilesInThisFolder;
                if (!partitionFolder.isDirectory()) {
                    logger.warn("{} is not a directory.", (Object)partitionFolder.getAbsolutePath());
                    continue;
                }
                this.continueFailedRenames(partitionFolder, ".temp");
                String partitionName = partitionFolder.getName();
                for (File f : tsFilesInThisFolder = this.fsFactory.listFilesBySuffix(partitionFolder.getAbsolutePath(), ".tsfile")) {
                    String tsFilePartitionPath = partitionName + File.separator + f.getName();
                    tsFilePartitionPath2File.put(tsFilePartitionPath, f);
                }
            }
        }
        ArrayList sortedFiles = new ArrayList(tsFilePartitionPath2File.values());
        sortedFiles.sort(this::compareFileName);
        long currentTime = System.currentTimeMillis();
        ArrayList<TsFileResource> ret = new ArrayList<TsFileResource>();
        for (File f : sortedFiles) {
            this.checkTsFileTime(f, currentTime);
            ret.add(new TsFileResource(f));
        }
        return ret;
    }

    private void continueFailedRenames(File fileFolder, String suffix) throws IOException {
        File[] files = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), suffix);
        if (files != null) {
            for (File tempResource : files) {
                File originResource = this.fsFactory.getFile(tempResource.getPath().replace(suffix, ""));
                if (originResource.exists()) {
                    Files.delete(tempResource.toPath());
                    continue;
                }
                Files.move(tempResource.toPath(), originResource.toPath(), new CopyOption[0]);
            }
        }
    }

    private void checkTsFileTime(File tsFile, long currentTime) throws DataRegionException {
        String[] items = tsFile.getName().replace(".tsfile", "").split("-");
        long fileTime = Long.parseLong(items[0]);
        if (fileTime > currentTime) {
            throw new DataRegionException(String.format("data region %s[%s] is down, because the time of tsfile %s is larger than system current time, file time is %d while system current time is %d, please check it.", this.databaseName, this.dataRegionId, tsFile.getAbsolutePath(), fileTime, currentTime));
        }
    }

    private WALRecoverListener recoverUnsealedTsFile(TsFileResource unsealedTsFile, DataRegionRecoveryContext context, boolean isSeq) {
        UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(unsealedTsFile, isSeq, context.recoverPerformers::add);
        return WALRecoverManager.getInstance().addRecoverPerformer(recoverPerformer);
    }

    private void recoverUnsealedTsFileCallBack(UnsealedTsFileRecoverPerformer recoverPerformer) {
        try {
            TsFileResource tsFileResource = recoverPerformer.getTsFileResource();
            boolean isSeq = recoverPerformer.isSequence();
            if (!recoverPerformer.canWrite()) {
                try {
                    tsFileResource.close();
                }
                catch (IOException e) {
                    logger.error("Fail to close TsFile {} when recovering", (Object)tsFileResource.getTsFile(), (Object)e);
                }
                if (!TsFileValidator.getInstance().validateTsFile(tsFileResource)) {
                    tsFileResource.remove();
                    return;
                }
                this.updateLastFlushTime(tsFileResource, isSeq);
                this.tsFileResourceManager.registerSealedTsFileResource(tsFileResource);
                FileMetrics.getInstance().addTsFile(tsFileResource.getDatabaseName(), tsFileResource.getDataRegionId(), tsFileResource.getTsFile().length(), recoverPerformer.isSequence(), tsFileResource.getTsFile().getName());
            } else {
                RestorableTsFileIOWriter writer = recoverPerformer.getWriter();
                long timePartitionId = tsFileResource.getTimePartition();
                TimePartitionManager.getInstance().updateAfterOpeningTsFileProcessor(new DataRegionId(Integer.parseInt(this.dataRegionId)), timePartitionId);
                TsFileProcessor tsFileProcessor = new TsFileProcessor(this.dataRegionId, this.dataRegionInfo, tsFileResource, this::closeUnsealedTsFileProcessorCallBack, this::flushCallback, isSeq, writer);
                if (this.workSequenceTsFileProcessors.get(tsFileProcessor.getTimeRangeId()) == null && this.workUnsequenceTsFileProcessors.get(tsFileProcessor.getTimeRangeId()) == null) {
                    WritingMetrics.getInstance().recordActiveTimePartitionCount(1);
                }
                if (isSeq) {
                    this.workSequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                } else {
                    this.workUnsequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                }
                tsFileResource.setProcessor(tsFileProcessor);
                tsFileResource.removeResourceFile();
                tsFileProcessor.setTimeRangeId(timePartitionId);
                writer.makeMetadataVisible();
                if (this.enableMemControl) {
                    TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.dataRegionInfo);
                    tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
                    this.dataRegionInfo.initTsFileProcessorInfo(tsFileProcessor);
                    long chunkMetadataSize = 0L;
                    for (Map metaMap : writer.getMetadatasForQuery().values()) {
                        for (List metadatas : metaMap.values()) {
                            for (ChunkMetadata chunkMetadata : metadatas) {
                                chunkMetadataSize += chunkMetadata.getRetainedSizeInBytes();
                            }
                        }
                    }
                    tsFileProcessorInfo.addTSPMemCost(chunkMetadataSize);
                }
            }
            this.tsFileManager.add(tsFileResource, recoverPerformer.isSequence());
        }
        catch (Throwable e) {
            logger.error("Fail to recover unsealed TsFile {}, skip it.", (Object)recoverPerformer.getTsFileAbsolutePath(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverSealedTsFiles(TsFileResource sealedTsFile, DataRegionRecoveryContext context, boolean isSeq) {
        try (SealedTsFileRecoverPerformer recoverPerformer = new SealedTsFileRecoverPerformer(sealedTsFile);){
            recoverPerformer.recover();
            sealedTsFile.close();
            this.tsFileManager.add(sealedTsFile, isSeq);
            this.tsFileResourceManager.registerSealedTsFileResource(sealedTsFile);
        }
        catch (Throwable e) {
            logger.error("Fail to recover sealed TsFile {}, skip it.", (Object)sealedTsFile.getTsFilePath(), (Object)e);
        }
        finally {
            context.incrementRecoveredFilesNum();
        }
    }

    private void recoverFilesInPartition(long partitionId, DataRegionRecoveryContext context, List<TsFileResource> resourceList, boolean isSeq) {
        for (TsFileResource tsFileResource : resourceList) {
            this.recoverSealedTsFiles(tsFileResource, context, isSeq);
        }
        if (config.isEnableSeparateData()) {
            if (!this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(partitionId)) {
                TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), partitionId, false, Long.MAX_VALUE, this.lastFlushTimeMap.getMemSize(partitionId)));
            }
            for (TsFileResource tsFileResource : resourceList) {
                this.updateLastFlushTime(tsFileResource, isSeq);
            }
            TimePartitionManager.getInstance().updateAfterFlushing(new DataRegionId(Integer.parseInt(this.dataRegionId)), partitionId, System.currentTimeMillis(), this.lastFlushTimeMap.getMemSize(partitionId), false);
        }
    }

    private int compareFileName(File o1, File o2) {
        long ver2;
        String[] items1 = o1.getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            return Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
        }
        return cmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowNode insertRowNode) throws WriteProcessException {
        if (!this.isAlive(insertRowNode.getTime())) {
            throw new OutOfTTLException(insertRowNode.getTime(), CommonDateTimeUtils.currentTime() - this.dataTTL);
        }
        if (this.enableMemControl) {
            StorageEngine.blockInsertionIfReject(null);
        }
        long startTime = System.nanoTime();
        this.writeLock("InsertRow");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            if (this.deleted) {
                return;
            }
            long timePartitionId = TimePartitionUtils.getTimePartitionId((long)insertRowNode.getTime());
            if (config.isEnableSeparateData() && !this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(timePartitionId)) {
                TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), timePartitionId, true, Long.MAX_VALUE, 0L));
            }
            boolean isSequence = config.isEnableSeparateData() && insertRowNode.getTime() > this.lastFlushTimeMap.getFlushedTime(timePartitionId, insertRowNode.getDevicePath().getFullPath());
            HashMap<TsFileProcessor, Boolean> tsFileProcessorMapForFlushing = new HashMap<TsFileProcessor, Boolean>();
            this.insertToTsFileProcessor(insertRowNode, isSequence, timePartitionId, tsFileProcessorMapForFlushing);
            for (Map.Entry entry : tsFileProcessorMapForFlushing.entrySet()) {
                if (!((TsFileProcessor)entry.getKey()).shouldFlush()) continue;
                this.fileFlushPolicy.apply(this, (TsFileProcessor)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTablet(InsertTabletNode insertTabletNode) throws BatchProcessException, WriteProcessException {
        if (this.enableMemControl) {
            StorageEngine.blockInsertionIfReject(null);
        }
        long startTime = System.nanoTime();
        this.writeLock("insertTablet");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            long currTime;
            int loc;
            if (this.deleted) {
                return;
            }
            Object[] results = new TSStatus[insertTabletNode.getRowCount()];
            Arrays.fill(results, RpcUtils.SUCCESS_STATUS);
            boolean noFailure = true;
            for (loc = 0; loc < insertTabletNode.getRowCount() && !this.isAlive(currTime = insertTabletNode.getTimes()[loc]); ++loc) {
                results[loc] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OUT_OF_TTL, (String)String.format("Insertion time [%s] is less than ttl time bound [%s]", DateTimeUtils.convertLongToDate(currTime), DateTimeUtils.convertLongToDate(CommonDateTimeUtils.currentTime() - this.dataTTL)));
                noFailure = false;
            }
            if (loc == insertTabletNode.getRowCount()) {
                throw new OutOfTTLException(insertTabletNode.getTimes()[insertTabletNode.getTimes().length - 1], CommonDateTimeUtils.currentTime() - this.dataTTL);
            }
            int before = loc;
            long beforeTimePartition = TimePartitionUtils.getTimePartitionId((long)insertTabletNode.getTimes()[before]);
            if (config.isEnableSeparateData() && !this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(beforeTimePartition)) {
                TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), beforeTimePartition, true, Long.MAX_VALUE, 0L));
            }
            long lastFlushTime = config.isEnableSeparateData() ? this.lastFlushTimeMap.getFlushedTime(beforeTimePartition, insertTabletNode.getDevicePath().getFullPath()) : Long.MAX_VALUE;
            boolean isSequence = false;
            while (loc < insertTabletNode.getRowCount()) {
                long time = insertTabletNode.getTimes()[loc];
                if (!isSequence && time > lastFlushTime) {
                    noFailure = this.insertTabletToTsFileProcessor(insertTabletNode, before, loc, false, (TSStatus[])results, beforeTimePartition) && noFailure;
                    before = loc;
                    isSequence = true;
                }
                ++loc;
            }
            if (before < loc) {
                noFailure = this.insertTabletToTsFileProcessor(insertTabletNode, before, loc, isSequence, (TSStatus[])results, beforeTimePartition) && noFailure;
            }
            startTime = System.nanoTime();
            this.tryToUpdateInsertTabletLastCache(insertTabletNode);
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleUpdateLastCacheCost(System.nanoTime() - startTime);
            if (!noFailure) {
                throw new BatchProcessException((TSStatus[])results);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean isAlive(long time) {
        return this.dataTTL == Long.MAX_VALUE || CommonDateTimeUtils.currentTime() - time <= this.dataTTL;
    }

    private boolean insertTabletToTsFileProcessor(InsertTabletNode insertTabletNode, int start, int end, boolean sequence, TSStatus[] results, long timePartitionId) {
        if (start >= end || insertTabletNode.allMeasurementFailed()) {
            return true;
        }
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("can not create TsFileProcessor, timePartitionId: " + timePartitionId));
            }
            return false;
        }
        try {
            tsFileProcessor.insertTablet(insertTabletNode, start, end, results);
        }
        catch (WriteProcessRejectException e) {
            logger.warn("insert to TsFileProcessor rejected, {}", (Object)e.getMessage());
            return false;
        }
        catch (WriteProcessException e) {
            logger.error("insert to TsFileProcessor error ", (Throwable)((Object)e));
            return false;
        }
        if (tsFileProcessor.shouldFlush()) {
            this.fileFlushPolicy.apply(this, tsFileProcessor, sequence);
        }
        return true;
    }

    private void tryToUpdateInsertTabletLastCache(InsertTabletNode node) {
        if (!CommonDescriptor.getInstance().getConfig().isLastCacheEnable() || config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus") && node.isSyncFromLeaderWhenUsingIoTConsensus()) {
            return;
        }
        long latestFlushedTime = this.lastFlushTimeMap.getGlobalFlushedTime(node.getDevicePath().getFullPath());
        String[] measurements = node.getMeasurements();
        MeasurementSchema[] measurementSchemas = node.getMeasurementSchemas();
        String[] rawMeasurements = new String[measurements.length];
        for (int i = 0; i < measurements.length; ++i) {
            rawMeasurements[i] = measurementSchemas[i] != null ? measurementSchemas[i].getMeasurementId() : measurements[i];
        }
        DataNodeSchemaCache.getInstance().updateLastCache(this.getDatabaseName(), node.getDevicePath(), rawMeasurements, node.getMeasurementSchemas(), node.isAligned(), node::composeLastTimeValuePair, index -> node.getColumns()[index] != null, true, latestFlushedTime);
    }

    private void insertToTsFileProcessor(InsertRowNode insertRowNode, boolean sequence, long timePartitionId, Map<TsFileProcessor, Boolean> tsFileProcessorMapForFlushing) throws WriteProcessException {
        if (insertRowNode.allMeasurementFailed()) {
            return;
        }
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            return;
        }
        long[] costsForMetrics = new long[4];
        tsFileProcessor.insert(insertRowNode, costsForMetrics);
        PERFORMANCE_OVERVIEW_METRICS.recordCreateMemtableBlockCost(costsForMetrics[0]);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleMemoryBlockCost(costsForMetrics[1]);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleWalCost(costsForMetrics[2]);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleMemTableCost(costsForMetrics[3]);
        tsFileProcessorMapForFlushing.put(tsFileProcessor, sequence);
        if (CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            if (config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus") && insertRowNode.isSyncFromLeaderWhenUsingIoTConsensus()) {
                return;
            }
            long startTime = System.nanoTime();
            this.tryToUpdateInsertRowLastCache(insertRowNode);
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleUpdateLastCacheCost(System.nanoTime() - startTime);
        }
    }

    private void tryToUpdateInsertRowLastCache(InsertRowNode node) {
        long latestFlushedTime = this.lastFlushTimeMap.getGlobalFlushedTime(node.getDevicePath().getFullPath());
        String[] measurements = node.getMeasurements();
        MeasurementSchema[] measurementSchemas = node.getMeasurementSchemas();
        String[] rawMeasurements = new String[measurements.length];
        for (int i = 0; i < measurements.length; ++i) {
            rawMeasurements[i] = measurementSchemas[i] != null ? measurementSchemas[i].getMeasurementId() : measurements[i];
        }
        DataNodeSchemaCache.getInstance().updateLastCache(this.getDatabaseName(), node.getDevicePath(), rawMeasurements, node.getMeasurementSchemas(), node.isAligned(), node::composeTimeValuePair, index -> node.getValues()[index] != null, true, latestFlushedTime);
    }

    private void insertToTsFileProcessors(InsertRowsNode insertRowsNode, boolean[] areSequence, long[] timePartitionIds) {
        ArrayList<InsertRowNode> executedInsertRowNodeList = new ArrayList<InsertRowNode>();
        long[] costsForMetrics = new long[4];
        HashMap<TsFileProcessor, Boolean> tsFileProcessorMapForFlushing = new HashMap<TsFileProcessor, Boolean>();
        for (int i = 0; i < areSequence.length; ++i) {
            TsFileProcessor tsFileProcessor;
            InsertRowNode insertRowNode = insertRowsNode.getInsertRowNodeList().get(i);
            if (insertRowNode.allMeasurementFailed() || (tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionIds[i], areSequence[i])) == null) continue;
            tsFileProcessorMapForFlushing.put(tsFileProcessor, areSequence[i]);
            try {
                tsFileProcessor.insert(insertRowNode, costsForMetrics);
            }
            catch (WriteProcessException e) {
                insertRowsNode.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
            executedInsertRowNodeList.add(insertRowNode);
        }
        for (Map.Entry entry : tsFileProcessorMapForFlushing.entrySet()) {
            if (!((TsFileProcessor)entry.getKey()).shouldFlush()) continue;
            this.fileFlushPolicy.apply(this, (TsFileProcessor)entry.getKey(), (Boolean)entry.getValue());
        }
        PERFORMANCE_OVERVIEW_METRICS.recordCreateMemtableBlockCost(costsForMetrics[0]);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleMemoryBlockCost(costsForMetrics[1]);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleWalCost(costsForMetrics[2]);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleMemTableCost(costsForMetrics[3]);
        if (CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            if (config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus") && insertRowsNode.isSyncFromLeaderWhenUsingIoTConsensus()) {
                return;
            }
            long startTime = System.nanoTime();
            this.tryToUpdateInsertRowsLastCache(executedInsertRowNodeList);
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleUpdateLastCacheCost(System.nanoTime() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToUpdateInsertRowsLastCache(List<InsertRowNode> nodeList) {
        DataNodeSchemaCache.getInstance().takeReadLock();
        try {
            for (InsertRowNode node : nodeList) {
                long latestFlushedTime = this.lastFlushTimeMap.getGlobalFlushedTime(node.getDevicePath().getFullPath());
                String[] measurements = node.getMeasurements();
                MeasurementSchema[] measurementSchemas = node.getMeasurementSchemas();
                String[] rawMeasurements = new String[measurements.length];
                for (int i = 0; i < measurements.length; ++i) {
                    rawMeasurements[i] = measurementSchemas[i] != null ? measurementSchemas[i].getMeasurementId() : measurements[i];
                }
                DataNodeSchemaCache.getInstance().updateLastCacheWithoutLock(this.getDatabaseName(), node.getDevicePath(), rawMeasurements, node.getMeasurementSchemas(), node.isAligned(), node::composeTimeValuePair, index -> node.getValues()[index] != null, true, latestFlushedTime);
            }
        }
        finally {
            DataNodeSchemaCache.getInstance().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submitAFlushTask(long timeRangeId, boolean sequence, IMemTable memTable) {
        this.writeLock("submitAFlushTask");
        try {
            boolean shouldSubmit;
            if (memTable.getFlushStatus() != FlushStatus.WORKING) {
                boolean bl = false;
                return bl;
            }
            TsFileProcessor tsFileProcessor = sequence ? this.workSequenceTsFileProcessors.get(timeRangeId) : this.workUnsequenceTsFileProcessors.get(timeRangeId);
            boolean bl = shouldSubmit = tsFileProcessor != null && tsFileProcessor.getWorkMemTable() == memTable;
            if (shouldSubmit) {
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
            boolean bl2 = shouldSubmit;
            return bl2;
        }
        finally {
            this.writeUnlock();
        }
    }

    public void submitAFlushTaskWhenShouldFlush(TsFileProcessor tsFileProcessor) {
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor) || tsFileProcessor.alreadyMarkedClosing()) {
            return;
        }
        this.writeLock("submitAFlushTaskWhenShouldFlush");
        try {
            if (tsFileProcessor.shouldFlush()) {
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private TsFileProcessor getOrCreateTsFileProcessor(long timeRangeId, boolean sequence) {
        TsFileProcessor tsFileProcessor = null;
        int retryCnt = 0;
        do {
            try {
                if (IoTDBDescriptor.getInstance().getConfig().isQuotaEnable() && !DataNodeSpaceQuotaManager.getInstance().checkRegionDisk(this.databaseName)) {
                    throw new ExceedQuotaException("Unable to continue writing data, because the space allocated to the database " + this.databaseName + " has already used the upper limit", TSStatusCode.SPACE_QUOTA_EXCEEDED.getStatusCode());
                }
                if (sequence) {
                    tsFileProcessor = this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workSequenceTsFileProcessors, true);
                    continue;
                }
                tsFileProcessor = this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workUnsequenceTsFileProcessors, false);
            }
            catch (DiskSpaceInsufficientException e) {
                logger.error("disk space is insufficient when creating TsFile processor, change system mode to read-only", (Throwable)((Object)e));
                CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
                break;
            }
            catch (IOException e) {
                if (retryCnt < 3) {
                    logger.warn("meet IOException when creating TsFileProcessor, retry it again", (Throwable)e);
                    ++retryCnt;
                    continue;
                }
                logger.error("meet IOException when creating TsFileProcessor, change system mode to error", (Throwable)e);
                CommonDescriptor.getInstance().getConfig().handleUnrecoverableError();
                break;
            }
            catch (ExceedQuotaException e) {
                logger.error(e.getMessage());
                break;
            }
        } while (tsFileProcessor == null);
        return tsFileProcessor;
    }

    private TsFileProcessor getOrCreateTsFileProcessorIntern(long timeRangeId, TreeMap<Long, TsFileProcessor> tsFileProcessorTreeMap, boolean sequence) throws IOException, DiskSpaceInsufficientException {
        TsFileProcessor res = tsFileProcessorTreeMap.get(timeRangeId);
        if (null == res) {
            TimePartitionManager.getInstance().updateAfterOpeningTsFileProcessor(new DataRegionId(Integer.valueOf(this.dataRegionId).intValue()), timeRangeId);
            res = this.newTsFileProcessor(sequence, timeRangeId);
            if (this.workSequenceTsFileProcessors.get(timeRangeId) == null && this.workUnsequenceTsFileProcessors.get(timeRangeId) == null) {
                WritingMetrics.getInstance().recordActiveTimePartitionCount(1);
            }
            tsFileProcessorTreeMap.put(timeRangeId, res);
            this.tsFileManager.add(res.getTsFileResource(), sequence);
        }
        return res;
    }

    private TsFileProcessor newTsFileProcessor(boolean sequence, long timePartitionId) throws IOException, DiskSpaceInsufficientException {
        long version = this.partitionMaxFileVersions.compute(timePartitionId, (key, oldVersion) -> oldVersion == null ? 1L : oldVersion + 1L);
        String filePath = TsFileNameGenerator.generateNewTsFilePathWithMkdir(sequence, this.databaseName, this.dataRegionId, timePartitionId, System.currentTimeMillis(), version, 0, 0);
        return this.getTsFileProcessor(sequence, filePath, timePartitionId);
    }

    private TsFileProcessor getTsFileProcessor(boolean sequence, String filePath, long timePartitionId) throws IOException {
        TsFileProcessor tsFileProcessor = new TsFileProcessor(this.databaseName + "-" + this.dataRegionId, this.fsFactory.getFileWithParent(filePath), this.dataRegionInfo, this::closeUnsealedTsFileProcessorCallBack, this::flushCallback, sequence);
        if (this.enableMemControl) {
            TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.dataRegionInfo);
            tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
            this.dataRegionInfo.initTsFileProcessorInfo(tsFileProcessor);
        }
        tsFileProcessor.addCloseFileListeners(this.customCloseFileListeners);
        tsFileProcessor.addFlushListeners(this.customFlushListeners);
        tsFileProcessor.setTimeRangeId(timePartitionId);
        return tsFileProcessor;
    }

    private String getNewTsFileName(long timePartitionId) {
        long version = this.partitionMaxFileVersions.compute(timePartitionId, (key, oldVersion) -> oldVersion == null ? 1L : oldVersion + 1L);
        return this.getNewTsFileName(System.currentTimeMillis(), version, 0, 0);
    }

    private String getNewTsFileName(long time, long version, int mergeCnt, int unseqCompactionCnt) {
        return TsFileNameGenerator.generateNewTsFileName(time, version, mergeCnt, unseqCompactionCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseOneTsFileProcessor(boolean sequence, TsFileProcessor tsFileProcessor) {
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            try {
                this.asyncCloseOneTsFileProcessor(sequence, tsFileProcessor);
                long startTime = System.currentTimeMillis();
                while (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor)) {
                    this.closeStorageGroupCondition.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L) continue;
                    logger.warn("{} has spent {}s to wait for closing one tsfile.", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)((System.currentTimeMillis() - startTime) / 1000L));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("syncCloseOneTsFileProcessor error occurs while waiting for closing the storage group {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)e);
            }
        }
    }

    public Future<?> asyncCloseOneTsFileProcessor(boolean sequence, TsFileProcessor tsFileProcessor) {
        Future<?> future;
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor) || tsFileProcessor.alreadyMarkedClosing()) {
            return CompletableFuture.completedFuture(null);
        }
        logger.info("Async close tsfile: {}", (Object)tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath());
        if (sequence) {
            this.closingSequenceTsFileProcessor.add(tsFileProcessor);
            future = tsFileProcessor.asyncClose();
            this.workSequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
            if (!this.workUnsequenceTsFileProcessors.containsKey(tsFileProcessor.getTimeRangeId())) {
                this.timePartitionIdVersionControllerMap.remove(tsFileProcessor.getTimeRangeId());
            }
        } else {
            this.closingUnSequenceTsFileProcessor.add(tsFileProcessor);
            future = tsFileProcessor.asyncClose();
            this.workUnsequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
            if (!this.workSequenceTsFileProcessors.containsKey(tsFileProcessor.getTimeRangeId())) {
                this.timePartitionIdVersionControllerMap.remove(tsFileProcessor.getTimeRangeId());
            }
        }
        if (this.workSequenceTsFileProcessors.get(tsFileProcessor.getTimeRangeId()) == null && this.workUnsequenceTsFileProcessors.get(tsFileProcessor.getTimeRangeId()) == null) {
            WritingMetrics.getInstance().recordActiveTimePartitionCount(-1);
        }
        return future;
    }

    public void deleteFolder(String systemDir) {
        logger.info("{} will close all files for deleting data folder {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)systemDir);
        this.writeLock("deleteFolder");
        try {
            File dataRegionSystemFolder = SystemFileFactory.INSTANCE.getFile(systemDir + File.separator + this.databaseName, this.dataRegionId);
            org.apache.iotdb.commons.utils.FileUtils.deleteDirectoryAndEmptyParent((File)dataRegionSystemFolder);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void closeAllResources() {
        for (TsFileResource tsFileResource : this.tsFileManager.getTsFileList(false)) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
        for (TsFileResource tsFileResource : this.tsFileManager.getTsFileList(true)) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
    }

    public void syncDeleteDataFiles() {
        logger.info("{} will close all files for deleting data files", (Object)(this.databaseName + "-" + this.dataRegionId));
        this.writeLock("syncDeleteDataFiles");
        try {
            this.syncCloseAllWorkingTsFileProcessors();
            this.closeAllResources();
            List<TsFileResource> tsFileResourceList = this.tsFileManager.getTsFileList(true);
            tsFileResourceList.addAll(this.tsFileManager.getTsFileList(false));
            tsFileResourceList.forEach(x -> {
                FileMetrics.getInstance().deleteTsFile(x.isSeq(), Collections.singletonList(x));
                if (x.getModFile().exists()) {
                    FileMetrics.getInstance().decreaseModFileNum(1);
                    FileMetrics.getInstance().decreaseModFileSize(x.getModFile().getSize());
                }
            });
            this.deleteAllSGFolders(TierManager.getInstance().getAllFilesFolders());
            this.workSequenceTsFileProcessors.clear();
            this.workUnsequenceTsFileProcessors.clear();
            this.tsFileManager.clear();
            this.lastFlushTimeMap.clearFlushedTime();
            this.lastFlushTimeMap.clearGlobalFlushedTime();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void deleteAllSGFolders(List<String> folder) {
        for (String tsfilePath : folder) {
            File dataRegionDataFolder = this.fsFactory.getFile(tsfilePath, this.databaseName + File.separator + this.dataRegionId);
            if (FSUtils.getFSType((File)dataRegionDataFolder) != FSType.LOCAL) {
                try {
                    this.fsFactory.deleteDirectory(dataRegionDataFolder.getPath());
                }
                catch (IOException e) {
                    logger.error("Fail to delete data region folder {}", (Object)dataRegionDataFolder);
                }
                continue;
            }
            if (!dataRegionDataFolder.exists()) continue;
            org.apache.iotdb.commons.utils.FileUtils.deleteDirectoryAndEmptyParent((File)dataRegionDataFolder);
        }
    }

    public synchronized void checkFilesTTL() {
        if (this.dataTTL == Long.MAX_VALUE) {
            logger.debug("{}: TTL not set, ignore the check", (Object)(this.databaseName + "-" + this.dataRegionId));
            return;
        }
        long ttlLowerBound = CommonDateTimeUtils.currentTime() - this.dataTTL;
        logger.debug("{}: TTL removing files before {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)new Date(ttlLowerBound));
        ArrayList<TsFileResource> seqFiles = new ArrayList<TsFileResource>(this.tsFileManager.getTsFileList(true));
        ArrayList<TsFileResource> unseqFiles = new ArrayList<TsFileResource>(this.tsFileManager.getTsFileList(false));
        for (TsFileResource tsFileResource : seqFiles) {
            this.checkFileTTL(tsFileResource, ttlLowerBound, true);
        }
        for (TsFileResource tsFileResource : unseqFiles) {
            this.checkFileTTL(tsFileResource, ttlLowerBound, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileTTL(TsFileResource resource, long ttlLowerBound, boolean isSeq) {
        if (!resource.isClosed() || !resource.isDeleted() && resource.stillLives(ttlLowerBound)) {
            return;
        }
        if (!resource.setStatus(TsFileResourceStatus.DELETED)) {
            return;
        }
        this.tsFileManager.remove(resource, isSeq);
        resource.writeLock();
        try {
            resource.remove();
            FileMetrics.getInstance().deleteTsFile(isSeq, Collections.singletonList(resource));
            logger.info("Removed a file {} before {} by ttl ({} {})", new Object[]{resource.getTsFilePath(), new Date(ttlLowerBound), this.dataTTL, CommonDescriptor.getInstance().getConfig().getTimestampPrecision()});
        }
        finally {
            resource.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedFlushSeqMemTable() {
        int count = 0;
        this.writeLock("timedFlushSeqMemTable");
        try {
            ArrayList<TsFileProcessor> tsFileProcessors = new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values());
            long timeLowerBound = System.currentTimeMillis() - config.getSeqMemtableFlushInterval();
            for (TsFileProcessor tsFileProcessor : tsFileProcessors) {
                if (tsFileProcessor.getWorkMemTableUpdateTime() >= timeLowerBound) continue;
                logger.info("Exceed sequence memtable flush interval, so flush working memtable of time partition {} in database {}[{}]", new Object[]{tsFileProcessor.getTimeRangeId(), this.databaseName, this.dataRegionId});
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
                ++count;
            }
        }
        finally {
            this.writeUnlock();
        }
        WritingMetrics.getInstance().recordTimedFlushMemTableCount(this.dataRegionId, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedFlushUnseqMemTable() {
        int count = 0;
        this.writeLock("timedFlushUnseqMemTable");
        try {
            ArrayList<TsFileProcessor> tsFileProcessors = new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values());
            long timeLowerBound = System.currentTimeMillis() - config.getUnseqMemtableFlushInterval();
            for (TsFileProcessor tsFileProcessor : tsFileProcessors) {
                if (tsFileProcessor.getWorkMemTableUpdateTime() >= timeLowerBound) continue;
                logger.info("Exceed unsequence memtable flush interval, so flush working memtable of time partition {} in database {}[{}]", new Object[]{tsFileProcessor.getTimeRangeId(), this.databaseName, this.dataRegionId});
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
                ++count;
            }
        }
        finally {
            this.writeUnlock();
        }
        WritingMetrics.getInstance().recordTimedFlushMemTableCount(this.dataRegionId, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseAllWorkingTsFileProcessors() {
        try {
            List<Future<?>> tsFileProcessorsClosingFutures = this.asyncCloseAllWorkingTsFileProcessors();
            long startTime = System.currentTimeMillis();
            while (!this.closingSequenceTsFileProcessor.isEmpty() || !this.closingUnSequenceTsFileProcessor.isEmpty()) {
                Iterator<Future<?>> iterator = this.closeStorageGroupCondition;
                synchronized (iterator) {
                    if (!this.closingSequenceTsFileProcessor.isEmpty() || !this.closingUnSequenceTsFileProcessor.isEmpty()) {
                        this.closeStorageGroupCondition.wait(60000L);
                    }
                }
                if (System.currentTimeMillis() - startTime <= 60000L) continue;
                logger.warn("{} has spent {}s to wait for closing all TsFiles.", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)((System.currentTimeMillis() - startTime) / 1000L));
            }
            for (Future<?> f : tsFileProcessorsClosingFutures) {
                if (f == null) continue;
                f.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("CloseFileNodeCondition error occurs while waiting for closing the storage group {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Future<?>> asyncCloseAllWorkingTsFileProcessors() {
        this.writeLock("asyncCloseAllWorkingTsFileProcessors");
        ArrayList futures = new ArrayList();
        try {
            logger.info("async force close all files in database: {}", (Object)(this.databaseName + "-" + this.dataRegionId));
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                futures.add(this.asyncCloseOneTsFileProcessor(true, tsFileProcessor));
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                futures.add(this.asyncCloseOneTsFileProcessor(false, tsFileProcessor));
            }
        }
        finally {
            this.writeUnlock();
        }
        return futures;
    }

    public void forceCloseAllWorkingTsFileProcessors() throws TsFileProcessorException {
        this.writeLock("forceCloseAllWorkingTsFileProcessors");
        try {
            logger.info("force close all processors in database: {}", (Object)(this.databaseName + "-" + this.dataRegionId));
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                tsFileProcessor.putMemTableBackAndClose();
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                tsFileProcessor.putMemTableBackAndClose();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public QueryDataSource query(List<PartialPath> pathList, String singleDeviceId, QueryContext context, Filter globalTimeFilter, List<Long> timePartitions) throws QueryProcessException {
        try {
            List<TsFileResource> seqResources = this.getFileResourceListForQuery(this.tsFileManager.getTsFileList(true, timePartitions, globalTimeFilter), pathList, singleDeviceId, context, globalTimeFilter, true);
            List<TsFileResource> unseqResources = this.getFileResourceListForQuery(this.tsFileManager.getTsFileList(false, timePartitions, globalTimeFilter), pathList, singleDeviceId, context, globalTimeFilter, false);
            QUERY_RESOURCE_METRIC_SET.recordQueryResourceNum("sequence_tsfile", seqResources.size());
            QUERY_RESOURCE_METRIC_SET.recordQueryResourceNum("unsequence_tsfile", unseqResources.size());
            QueryDataSource dataSource = new QueryDataSource(seqResources, unseqResources);
            dataSource.setDataTTL(this.dataTTL);
            return dataSource;
        }
        catch (MetadataException e) {
            throw new QueryProcessException((IoTDBException)((Object)e));
        }
    }

    @Override
    public void readLock() {
        this.insertLock.readLock().lock();
        this.tsFileManager.readLock();
    }

    @Override
    public void readUnlock() {
        this.tsFileManager.readUnlock();
        this.insertLock.readLock().unlock();
    }

    public void writeLock(String holder) {
        this.insertLock.writeLock().lock();
        this.insertWriteLockHolder = holder;
    }

    public void writeUnlock() {
        this.insertWriteLockHolder = "";
        this.insertLock.writeLock().unlock();
    }

    private List<TsFileResource> getFileResourceListForQuery(Collection<TsFileResource> tsFileResources, List<PartialPath> pathList, String singleDeviceId, QueryContext context, Filter globalTimeFilter, boolean isSeq) throws MetadataException {
        if (context.isDebug()) {
            DEBUG_LOGGER.info("Path: {}, get tsfile list: {} isSeq: {} timefilter: {}", new Object[]{pathList, tsFileResources, isSeq, globalTimeFilter == null ? "null" : globalTimeFilter});
        }
        ArrayList<TsFileResource> tsfileResourcesForQuery = new ArrayList<TsFileResource>();
        long timeLowerBound = this.dataTTL != Long.MAX_VALUE ? CommonDateTimeUtils.currentTime() - this.dataTTL : Long.MIN_VALUE;
        context.setQueryTimeLowerBound(timeLowerBound);
        for (TsFileResource tsFileResource : tsFileResources) {
            if (!tsFileResource.isSatisfied(singleDeviceId, globalTimeFilter, isSeq, this.dataTTL, context.isDebug())) continue;
            this.closeQueryLock.readLock().lock();
            try {
                if (tsFileResource.isClosed()) {
                    tsfileResourcesForQuery.add(tsFileResource);
                    continue;
                }
                tsFileResource.getProcessor().query(pathList, context, tsfileResourcesForQuery);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        return tsfileResourcesForQuery;
    }

    private void separateTsFile(List<TsFileResource> sealedResource, List<TsFileResource> unsealedResource, long startTime, long endTime) {
        this.tsFileManager.getTsFileList(true, startTime, endTime).forEach(tsFileResource -> {
            if (tsFileResource.isClosed()) {
                sealedResource.add((TsFileResource)tsFileResource);
            } else {
                unsealedResource.add((TsFileResource)tsFileResource);
            }
        });
        this.tsFileManager.getTsFileList(false, startTime, endTime).forEach(tsFileResource -> {
            if (tsFileResource.isClosed()) {
                sealedResource.add((TsFileResource)tsFileResource);
            } else {
                unsealedResource.add((TsFileResource)tsFileResource);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByDevice(PartialPath pattern, long startTime, long endTime, long searchIndex) throws IOException {
        if (SettleService.getINSTANCE().getFilesToBeSettledCount().get() != 0) {
            throw new IOException("Delete failed. Please do not delete until the old files settled.");
        }
        this.writeLock("delete");
        boolean hasReleasedLock = false;
        try {
            HashSet<PartialPath> devicePaths = new HashSet<PartialPath>(pattern.getDevicePathPattern());
            DataNodeSchemaCache.getInstance().takeWriteLock();
            try {
                DataNodeSchemaCache.getInstance().invalidate(Collections.singletonList(pattern));
            }
            finally {
                DataNodeSchemaCache.getInstance().releaseWriteLock();
            }
            List<WALFlushListener> walListeners = this.logDeletionInWAL(startTime, endTime, searchIndex, pattern);
            for (WALFlushListener walFlushListener : walListeners) {
                if (walFlushListener.waitForResult() != AbstractResultListener.Status.FAILURE) continue;
                logger.error("Fail to log delete to wal.", (Throwable)walFlushListener.getCause());
                throw walFlushListener.getCause();
            }
            Deletion deletion = new Deletion(pattern, 1L, startTime, endTime);
            ArrayList<TsFileResource> sealedTsFileResource = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unsealedTsFileResource = new ArrayList<TsFileResource>();
            this.separateTsFile(sealedTsFileResource, unsealedTsFileResource, startTime, endTime);
            HashSet<String> deviceMatchInfo = new HashSet<String>();
            this.deleteDataInFiles(unsealedTsFileResource, deletion, devicePaths, deviceMatchInfo);
            this.writeUnlock();
            hasReleasedLock = true;
            this.deleteDataInFiles(sealedTsFileResource, deletion, devicePaths, deviceMatchInfo);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (!hasReleasedLock) {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataDirectly(PartialPath pathToDelete, long startTime, long endTime, long searchIndex) throws IOException {
        logger.info("{} will delete data files directly for deleting data between {} and {}", new Object[]{this.databaseName + "-" + this.dataRegionId, startTime, endTime});
        this.writeLock("deleteDataDirect");
        boolean releasedLock = false;
        try {
            DataNodeSchemaCache.getInstance().takeWriteLock();
            try {
                DataNodeSchemaCache.getInstance().invalidate(this.databaseName);
            }
            finally {
                DataNodeSchemaCache.getInstance().releaseWriteLock();
            }
            List<WALFlushListener> walListeners = this.logDeletionInWAL(startTime, endTime, searchIndex, pathToDelete);
            for (WALFlushListener walFlushListener : walListeners) {
                if (walFlushListener.waitForResult() != AbstractResultListener.Status.FAILURE) continue;
                logger.error("Fail to log delete to wal.", (Throwable)walFlushListener.getCause());
                throw walFlushListener.getCause();
            }
            ArrayList<TsFileResource> sealedTsFileResource = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unsealedTsFileResource = new ArrayList<TsFileResource>();
            this.separateTsFile(sealedTsFileResource, unsealedTsFileResource, startTime, endTime);
            this.deleteDataDirectlyInFile(unsealedTsFileResource, pathToDelete, startTime, endTime);
            this.writeUnlock();
            releasedLock = true;
            this.deleteDataDirectlyInFile(sealedTsFileResource, pathToDelete, startTime, endTime);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (!releasedLock) {
                this.writeUnlock();
            }
        }
    }

    private List<WALFlushListener> logDeletionInWAL(long startTime, long endTime, long searchIndex, PartialPath path) {
        WALFlushListener walFlushListener;
        ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
        if (config.getWalMode() == WALMode.DISABLE) {
            return walFlushListeners;
        }
        DeleteDataNode deleteDataNode = new DeleteDataNode(new PlanNodeId(""), Collections.singletonList(path), startTime, endTime);
        deleteDataNode.setSearchIndex(searchIndex);
        for (Map.Entry<Long, TsFileProcessor> entry : this.workSequenceTsFileProcessors.entrySet()) {
            if (!TimePartitionUtils.satisfyPartitionId((long)startTime, (long)endTime, (long)entry.getKey())) continue;
            walFlushListener = entry.getValue().logDeleteDataNodeInWAL(deleteDataNode);
            walFlushListeners.add(walFlushListener);
        }
        for (Map.Entry<Long, TsFileProcessor> entry : this.workUnsequenceTsFileProcessors.entrySet()) {
            if (!TimePartitionUtils.satisfyPartitionId((long)startTime, (long)endTime, (long)entry.getKey())) continue;
            walFlushListener = entry.getValue().logDeleteDataNodeInWAL(deleteDataNode);
            walFlushListeners.add(walFlushListener);
        }
        return walFlushListeners;
    }

    private boolean canSkipDelete(TsFileResource tsFileResource, Set<PartialPath> devicePaths, long deleteStart, long deleteEnd, Set<String> deviceMatchInfo) {
        long fileStartTime = tsFileResource.getTimeIndex().getMinStartTime();
        long fileEndTime = tsFileResource.getTimeIndex().getMaxEndTime();
        for (PartialPath device : devicePaths) {
            long deviceEndTime;
            long deviceStartTime;
            if (device.hasWildcard()) {
                if (!tsFileResource.isClosed() && fileEndTime == Long.MIN_VALUE ? deleteEnd < fileStartTime : deleteEnd < fileStartTime || deleteStart > fileEndTime) {
                    return true;
                }
                if (this.databaseName.contentEquals(device.getDevice())) {
                    return false;
                }
                Pair<Long, Long> startAndEndTime = tsFileResource.getPossibleStartTimeAndEndTime(device, deviceMatchInfo);
                if (startAndEndTime == null) continue;
                deviceStartTime = (Long)startAndEndTime.getLeft();
                deviceEndTime = (Long)startAndEndTime.getRight();
            } else {
                String deviceId = device.getFullPath();
                if (tsFileResource.definitelyNotContains(deviceId)) continue;
                deviceStartTime = tsFileResource.getStartTime(deviceId);
                deviceEndTime = tsFileResource.getEndTime(deviceId);
            }
            if (!(!tsFileResource.isClosed() && deviceEndTime == Long.MIN_VALUE ? deleteEnd >= deviceStartTime : deleteEnd >= deviceStartTime && deleteStart <= deviceEndTime)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDataInFiles(Collection<TsFileResource> tsFileResourceList, Deletion deletion, Set<PartialPath> devicePaths, Set<String> deviceMatchInfo) throws IOException {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            if (this.canSkipDelete(tsFileResource, devicePaths, deletion.getStartTime(), deletion.getEndTime(), deviceMatchInfo)) continue;
            ModificationFile modFile = tsFileResource.getModFile();
            if (tsFileResource.isClosed()) {
                long originSize = -1L;
                ModificationFile modificationFile = modFile;
                synchronized (modificationFile) {
                    try {
                        originSize = modFile.getSize();
                        if (tsFileResource.isCompacting()) {
                            deletion.setFileOffset(Long.MAX_VALUE);
                            tsFileResource.getCompactionModFile().write(deletion);
                            modFile.write(deletion);
                            tsFileResource.getCompactionModFile().close();
                            modFile.close();
                        } else {
                            deletion.setFileOffset(tsFileResource.getTsFileSize());
                            boolean modFileExists = modFile.exists();
                            modFile.write(deletion);
                            modFile.close();
                            modFile.compact();
                            if (!modFileExists) {
                                FileMetrics.getInstance().increaseModFileNum(1);
                            }
                            FileMetrics.getInstance().increaseModFileSize(modFile.getSize() - originSize);
                        }
                    }
                    catch (Throwable t) {
                        if (originSize != -1L) {
                            modFile.truncate(originSize);
                        }
                        throw t;
                    }
                    logger.info("[Deletion] Deletion with path:{}, time:{}-{} written into mods file:{}.", new Object[]{deletion.getPath(), deletion.getStartTime(), deletion.getEndTime(), modFile.getFilePath()});
                    continue;
                }
            }
            tsFileResource.getProcessor().deleteDataInMemory(deletion, devicePaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDataDirectlyInFile(List<TsFileResource> tsfileResourceList, PartialPath pathToDelete, long startTime, long endTime) throws IOException {
        ArrayList<TsFileResource> deletedByMods = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> deletedByFiles = new ArrayList<TsFileResource>();
        this.separateTsFileToDelete(new HashSet<PartialPath>(pathToDelete.getDevicePathPattern()), tsfileResourceList, deletedByMods, deletedByFiles, startTime, endTime);
        Deletion deletion = new Deletion(pathToDelete, 1L, startTime, endTime);
        for (TsFileResource tsFileResource : deletedByMods) {
            ModificationFile modFile = tsFileResource.getModFile();
            if (tsFileResource.isClosed()) {
                long originSize = -1L;
                ModificationFile modificationFile = modFile;
                synchronized (modificationFile) {
                    try {
                        originSize = modFile.getSize();
                        if (tsFileResource.isCompacting()) {
                            deletion.setFileOffset(Long.MAX_VALUE);
                            tsFileResource.getCompactionModFile().write(deletion);
                            modFile.write(deletion);
                            tsFileResource.getCompactionModFile().close();
                            modFile.close();
                        } else {
                            deletion.setFileOffset(tsFileResource.getTsFileSize());
                            boolean modFileExists = modFile.exists();
                            modFile.write(deletion);
                            modFile.close();
                            modFile.compact();
                            if (!modFileExists) {
                                FileMetrics.getInstance().increaseModFileNum(1);
                            }
                            FileMetrics.getInstance().increaseModFileSize(modFile.getSize() - originSize);
                        }
                    }
                    catch (Throwable t) {
                        if (originSize != -1L) {
                            modFile.truncate(originSize);
                        }
                        throw t;
                    }
                    logger.info("[Deletion] Deletion with path:{}, time:{}-{} written into mods file:{}.", new Object[]{deletion.getPath(), deletion.getStartTime(), deletion.getEndTime(), modFile.getFilePath()});
                    continue;
                }
            }
            tsFileResource.getProcessor().deleteDataInMemory(deletion, new HashSet<PartialPath>(pathToDelete.getDevicePathPattern()));
        }
        for (TsFileResource tsFileResource : deletedByFiles) {
            this.tsFileManager.remove(tsFileResource, tsFileResource.isSeq());
            tsFileResource.writeLock();
            try {
                FileMetrics.getInstance().deleteTsFile(tsFileResource.isSeq(), Collections.singletonList(tsFileResource));
                if (tsFileResource.getModFile().exists()) {
                    FileMetrics.getInstance().decreaseModFileNum(1);
                    FileMetrics.getInstance().decreaseModFileSize(tsFileResource.getModFile().getSize());
                }
                tsFileResource.remove();
                logger.info("Remove tsfile {} directly when delete data", (Object)tsFileResource.getTsFilePath());
            }
            finally {
                tsFileResource.writeUnlock();
            }
        }
    }

    private void separateTsFileToDelete(Set<PartialPath> pathToDelete, List<TsFileResource> tsFileResourceList, List<TsFileResource> deletedByMods, List<TsFileResource> deletedByFiles, long startTime, long endTime) {
        HashSet<String> deviceMatchInfo = new HashSet<String>();
        for (TsFileResource file : tsFileResourceList) {
            long fileStartTime = file.getTimeIndex().getMinStartTime();
            long fileEndTime = file.getTimeIndex().getMaxEndTime();
            if (this.canSkipDelete(file, pathToDelete, startTime, endTime, deviceMatchInfo)) continue;
            if (startTime <= fileStartTime && endTime >= fileEndTime && file.isClosed() && file.setStatus(TsFileResourceStatus.DELETED)) {
                deletedByFiles.add(file);
                continue;
            }
            deletedByMods.add(file);
        }
    }

    private void flushCallback(TsFileProcessor processor, Map<String, Long> updateMap, long systemFlushTime) {
        if (config.isEnableSeparateData() && CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            this.lastFlushTimeMap.updateLatestFlushTime(processor.getTimeRangeId(), updateMap);
        } else {
            this.lastFlushTimeMap.updateMultiDeviceFlushedTime(processor.getTimeRangeId(), updateMap);
        }
        if (config.isEnableSeparateData()) {
            TimePartitionManager.getInstance().updateAfterFlushing(new DataRegionId(Integer.valueOf(this.dataRegionId).intValue()), processor.getTimeRangeId(), systemFlushTime, this.lastFlushTimeMap.getMemSize(processor.getTimeRangeId()), this.workSequenceTsFileProcessors.get(processor.getTimeRangeId()) != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnsealedTsFileProcessorCallBack(TsFileProcessor tsFileProcessor) throws TsFileProcessorException {
        Object tsFilePath;
        boolean isEmptyFile = tsFileProcessor.isEmpty() || tsFileProcessor.getTsFileResource().isEmpty();
        boolean isValidateTsFileFailed = false;
        if (!isEmptyFile) {
            isValidateTsFileFailed = !TsFileValidator.getInstance().validateTsFile(tsFileProcessor.getTsFileResource());
        }
        this.closeQueryLock.writeLock().lock();
        try {
            tsFileProcessor.close();
            if (isEmptyFile) {
                tsFileProcessor.getTsFileResource().remove();
                this.tsFileManager.remove(tsFileProcessor.getTsFileResource(), tsFileProcessor.isSequence());
            } else if (isValidateTsFileFailed) {
                tsFilePath = tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath();
                this.renameAndHandleError((String)tsFilePath, (String)tsFilePath + ".broken");
                this.renameAndHandleError((String)tsFilePath + ".resource", (String)tsFilePath + ".resource" + ".broken");
                this.tsFileManager.remove(tsFileProcessor.getTsFileResource(), tsFileProcessor.isSequence());
            } else {
                this.tsFileResourceManager.registerSealedTsFileResource(tsFileProcessor.getTsFileResource());
            }
        }
        finally {
            this.closeQueryLock.writeLock().unlock();
        }
        tsFilePath = this.closeStorageGroupCondition;
        synchronized (tsFilePath) {
            if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor)) {
                this.closingSequenceTsFileProcessor.remove(tsFileProcessor);
            } else {
                this.closingUnSequenceTsFileProcessor.remove(tsFileProcessor);
            }
            this.closeStorageGroupCondition.notifyAll();
        }
        if (!isValidateTsFileFailed) {
            TsFileResource tsFileResource = tsFileProcessor.getTsFileResource();
            FileMetrics.getInstance().addTsFile(tsFileResource.getDatabaseName(), tsFileResource.getDataRegionId(), tsFileResource.getTsFileSize(), tsFileProcessor.isSequence(), tsFileResource.getTsFile().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCompaction() throws InterruptedException {
        if (!this.isCompactionSelecting.compareAndSet(false, true)) {
            return 0;
        }
        try {
            int trySubmitCount = 0;
            ArrayList<Long> timePartitions = new ArrayList<Long>(this.tsFileManager.getTimePartitions());
            timePartitions.sort(Comparator.reverseOrder());
            CompactionScheduleSummary summary = new CompactionScheduleSummary();
            if (IoTDBDescriptor.getInstance().getConfig().isEnableCrossSpaceCompaction()) {
                summary.incrementSubmitTaskNum(CompactionTaskType.INSERTION, trySubmitCount += this.executeInsertionCompaction(timePartitions));
            }
            if (summary.getSubmitInsertionCrossSpaceCompactionTaskNum() == 0) {
                Iterator iterator = timePartitions.iterator();
                while (iterator.hasNext()) {
                    long timePartition = (Long)iterator.next();
                    CompactionScheduler.sharedLockCompactionSelection();
                    try {
                        trySubmitCount += CompactionScheduler.scheduleCompaction(this.tsFileManager, timePartition, summary);
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        logger.error("Meet error in compaction schedule.", e);
                    }
                    finally {
                        CompactionScheduler.sharedUnlockCompactionSelection();
                    }
                }
            }
            if (summary.hasSubmitTask()) {
                CompactionMetrics.getInstance().updateCompactionTaskSelectionNum(summary);
            }
            int n = trySubmitCount;
            return n;
        }
        finally {
            this.isCompactionSelecting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeInsertionCompaction(List<Long> timePartitions) throws InterruptedException {
        int trySubmitCount = 0;
        CompactionScheduler.sharedLockCompactionSelection();
        try {
            while (true) {
                int currentSubmitCount = 0;
                Phaser insertionTaskPhaser = new Phaser(1);
                for (long timePartition : timePartitions) {
                    currentSubmitCount += CompactionScheduler.scheduleInsertionCompaction(this.tsFileManager, timePartition, insertionTaskPhaser);
                }
                trySubmitCount += currentSubmitCount;
                insertionTaskPhaser.awaitAdvanceInterruptibly(insertionTaskPhaser.arrive());
                if (currentSubmitCount != 0) {
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Meet error in compaction schedule.", e);
        }
        finally {
            CompactionScheduler.sharedUnlockCompactionSelection();
        }
        return trySubmitCount;
    }

    private void settleTsFileCallBack(TsFileResource oldTsFileResource, List<TsFileResource> newTsFileResources) throws WriteProcessException {
        oldTsFileResource.readUnlock();
        oldTsFileResource.writeLock();
        try {
            TsFileAndModSettleTool.moveNewTsFile(oldTsFileResource, newTsFileResources);
            if (TsFileAndModSettleTool.getInstance().recoverSettleFileMap.size() != 0) {
                TsFileAndModSettleTool.getInstance().recoverSettleFileMap.remove(oldTsFileResource.getTsFile().getAbsolutePath());
            }
            DataRegion.operateClearCache();
            if (!oldTsFileResource.getTsFile().exists()) {
                this.tsFileManager.remove(oldTsFileResource, oldTsFileResource.isSeq());
            }
            FileReaderManager.getInstance().closeFileAndRemoveReader(oldTsFileResource.getTsFilePath());
            oldTsFileResource.setSettleTsFileCallBack(null);
            SettleService.getINSTANCE().getFilesToBeSettledCount().addAndGet(-1);
        }
        catch (IOException e) {
            logger.error("Exception to move new tsfile in settling", (Throwable)e);
            throw new WriteProcessException("Meet error when settling file: " + oldTsFileResource.getTsFile().getAbsolutePath(), e);
        }
        finally {
            oldTsFileResource.writeUnlock();
        }
    }

    public static void operateClearCache() {
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
    }

    public int compact() {
        this.writeLock("merge");
        CompactionScheduler.exclusiveLockCompactionSelection();
        try {
            int n = this.executeCompaction();
            return n;
        }
        catch (InterruptedException ignored) {
            int n = 0;
            return n;
        }
        finally {
            CompactionScheduler.exclusiveUnlockCompactionSelection();
            this.writeUnlock();
        }
    }

    private void resetLastCacheWhenLoadingTsFile() throws IllegalPathException {
        if (!CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            return;
        }
        DataNodeSchemaCache.getInstance().takeWriteLock();
        try {
            DataNodeSchemaCache.getInstance().invalidateAll();
        }
        finally {
            DataNodeSchemaCache.getInstance().releaseWriteLock();
        }
    }

    public void loadNewTsFile(TsFileResource newTsFileResource, boolean deleteOriginFile, boolean isGeneratedByPipe) throws LoadFileException {
        File tsfileToBeInserted = newTsFileResource.getTsFile();
        long newFilePartitionId = newTsFileResource.getTimePartitionWithCheck();
        if (!TsFileValidator.getInstance().validateTsFile(newTsFileResource)) {
            throw new LoadFileException("tsfile validate failed, " + newTsFileResource.getTsFile().getName());
        }
        this.writeLock("loadNewTsFile");
        try {
            newTsFileResource.setSeq(false);
            String newFileName = this.getNewTsFileName(System.currentTimeMillis(), this.getAndSetNewVersion(newFilePartitionId, newTsFileResource), 0, 0);
            if (!newFileName.equals(tsfileToBeInserted.getName())) {
                logger.info("TsFile {} must be renamed to {} for loading into the unsequence list.", (Object)tsfileToBeInserted.getName(), (Object)newFileName);
                newTsFileResource.setFile(this.fsFactory.getFile(tsfileToBeInserted.getParentFile(), newFileName));
            }
            this.loadTsFileToUnSequence(tsfileToBeInserted, newTsFileResource, newFilePartitionId, deleteOriginFile);
            PipeInsertionDataNodeListener.getInstance().listenToTsFile(this.dataRegionId, newTsFileResource, true, isGeneratedByPipe);
            FileMetrics.getInstance().addTsFile(newTsFileResource.getDatabaseName(), newTsFileResource.getDataRegionId(), newTsFileResource.getTsFile().length(), false, newTsFileResource.getTsFile().getName());
            this.resetLastCacheWhenLoadingTsFile();
            if (config.isEnableSeparateData()) {
                DataRegionId dataRegionId = new DataRegionId(Integer.parseInt(this.dataRegionId));
                long timePartitionId = newTsFileResource.getTimePartition();
                if (!this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(timePartitionId)) {
                    TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(dataRegionId, timePartitionId, false, Long.MAX_VALUE, this.lastFlushTimeMap.getMemSize(timePartitionId)));
                }
                this.updateLastFlushTime(newTsFileResource);
                TimePartitionManager.getInstance().updateAfterFlushing(dataRegionId, timePartitionId, System.currentTimeMillis(), this.lastFlushTimeMap.getMemSize(timePartitionId), false);
            }
            this.updatePartitionFileVersion(newTsFileResource.getTimePartition(), newTsFileResource.getVersion());
            TsFileResourceManager.getInstance().registerSealedTsFileResource(newTsFileResource);
            logger.info("TsFile {} is successfully loaded in unsequence list.", (Object)newFileName);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Failed to append the tsfile {} to database processor {} because the disk space is insufficient.", (Object)tsfileToBeInserted.getAbsolutePath(), (Object)tsfileToBeInserted.getParentFile().getName());
            throw new LoadFileException((Exception)((Object)e));
        }
        catch (IllegalPathException e) {
            logger.error("Failed to reset last cache when loading file {}", (Object)newTsFileResource.getTsFilePath());
            throw new LoadFileException((Exception)((Object)e));
        }
        finally {
            this.writeUnlock();
        }
    }

    public void setPartitionFileVersionToMax(long partition, long version) {
        this.partitionMaxFileVersions.compute(partition, (prt, oldVer) -> this.computeMaxVersion((Long)oldVer, version));
    }

    private long computeMaxVersion(Long oldVersion, Long newVersion) {
        if (oldVersion == null) {
            return newVersion;
        }
        return Math.max(oldVersion, newVersion);
    }

    public void removeFullyOverlapFiles(TsFileResource resource) {
        this.writeLock("removeFullyOverlapFiles");
        try {
            Iterator<TsFileResource> iterator = this.tsFileManager.getIterator(true);
            this.removeFullyOverlapFiles(resource, iterator, true);
            iterator = this.tsFileManager.getIterator(false);
            this.removeFullyOverlapFiles(resource, iterator, false);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFullyOverlapFiles(TsFileResource newTsFile, Iterator<TsFileResource> iterator, boolean isSeq) {
        while (iterator.hasNext()) {
            TsFileResource existingTsFile = iterator.next();
            if (!newTsFile.isPlanRangeCovers(existingTsFile) || newTsFile.getTsFile().equals(existingTsFile.getTsFile()) || !existingTsFile.tryWriteLock()) continue;
            logger.info("{} is covered by {}: [{}, {}], [{}, {}], remove it", new Object[]{existingTsFile, newTsFile, existingTsFile.minPlanIndex, existingTsFile.maxPlanIndex, newTsFile.minPlanIndex, newTsFile.maxPlanIndex});
            try {
                this.removeFullyOverlapFile(existingTsFile, iterator, isSeq);
            }
            catch (Exception e) {
                logger.error("Something gets wrong while removing FullyOverlapFiles: {}", (Object)existingTsFile.getTsFile().getAbsolutePath(), (Object)e);
            }
            finally {
                existingTsFile.writeUnlock();
            }
        }
    }

    private void removeFullyOverlapFile(TsFileResource tsFileResource, Iterator<TsFileResource> iterator, boolean isSeq) {
        logger.info("Removing a covered file {}, closed: {}", (Object)tsFileResource, (Object)tsFileResource.isClosed());
        if (!tsFileResource.isClosed()) {
            try {
                long timePartition = tsFileResource.getTimePartition();
                TreeMap<Long, TsFileProcessor> fileProcessorMap = isSeq ? this.workSequenceTsFileProcessors : this.workUnsequenceTsFileProcessors;
                TsFileProcessor tsFileProcessor = (TsFileProcessor)fileProcessorMap.get(timePartition);
                if (tsFileProcessor != null && tsFileProcessor.getTsFileResource() == tsFileResource) {
                    tsFileProcessor.syncClose();
                    fileProcessorMap.remove(timePartition);
                }
            }
            catch (Exception e) {
                logger.error("Cannot close {}", (Object)tsFileResource, (Object)e);
            }
        }
        this.tsFileManager.remove(tsFileResource, isSeq);
        iterator.remove();
        tsFileResource.remove();
    }

    private long getAndSetNewVersion(long timePartitionId, TsFileResource tsFileResource) {
        long version = this.partitionMaxFileVersions.compute(timePartitionId, (key, oldVersion) -> oldVersion == null ? 1L : oldVersion + 1L);
        tsFileResource.setVersion(version);
        return version;
    }

    protected void updateLastFlushTime(TsFileResource newTsFileResource) {
        for (String device : newTsFileResource.getDevices()) {
            long endTime = newTsFileResource.getEndTime(device);
            long timePartitionId = TimePartitionUtils.getTimePartitionId((long)endTime);
            if (config.isEnableSeparateData()) {
                this.lastFlushTimeMap.updateOneDeviceFlushedTime(timePartitionId, device, endTime);
            }
            if (!CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) continue;
            this.lastFlushTimeMap.updateOneDeviceGlobalFlushedTime(device, endTime);
        }
    }

    private boolean loadTsFileToUnSequence(File tsFileToLoad, TsFileResource tsFileResource, long filePartitionId, boolean deleteOriginFile) throws LoadFileException, DiskSpaceInsufficientException {
        File targetFile = this.fsFactory.getFile(TierManager.getInstance().getNextFolderForTsFile(0, false), this.databaseName + File.separatorChar + this.dataRegionId + File.separatorChar + filePartitionId + File.separator + tsFileResource.getTsFile().getName());
        tsFileResource.setFile(targetFile);
        if (this.tsFileManager.contains(tsFileResource, false)) {
            logger.error("The file {} has already been loaded in unsequence list", (Object)tsFileResource);
            return false;
        }
        this.tsFileManager.add(tsFileResource, false);
        logger.info("Load tsfile in unsequence list, move file from {} to {}", (Object)tsFileToLoad.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            if (deleteOriginFile) {
                FileUtils.moveFile((File)tsFileToLoad, (File)targetFile);
            } else {
                Files.copy(tsFileToLoad.toPath(), targetFile.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            logger.error("File renaming failed when loading tsfile. Origin: {}, Target: {}", new Object[]{tsFileToLoad.getAbsolutePath(), targetFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading tsfile. Origin: %s, Target: %s, because %s", tsFileToLoad.getAbsolutePath(), targetFile.getAbsolutePath(), e.getMessage()));
        }
        File resourceFileToLoad = this.fsFactory.getFile(tsFileToLoad.getAbsolutePath() + ".resource");
        File targetResourceFile = this.fsFactory.getFile(targetFile.getAbsolutePath() + ".resource");
        try {
            if (deleteOriginFile) {
                FileUtils.moveFile((File)resourceFileToLoad, (File)targetResourceFile);
            } else {
                Files.copy(resourceFileToLoad.toPath(), targetResourceFile.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            logger.error("File renaming failed when loading .resource file. Origin: {}, Target: {}", new Object[]{resourceFileToLoad.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading .resource file. Origin: %s, Target: %s, because %s", resourceFileToLoad.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e.getMessage()));
        }
        File modFileToLoad = this.fsFactory.getFile(tsFileToLoad.getAbsolutePath() + ".mods");
        if (modFileToLoad.exists()) {
            File targetModFile = this.fsFactory.getFile(targetFile.getAbsolutePath() + ".mods");
            try {
                Files.deleteIfExists(targetModFile.toPath());
            }
            catch (IOException e) {
                logger.warn("Cannot delete localModFile {}", (Object)targetModFile, (Object)e);
            }
            try {
                if (deleteOriginFile) {
                    FileUtils.moveFile((File)modFileToLoad, (File)targetModFile);
                } else {
                    Files.copy(modFileToLoad.toPath(), targetModFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                logger.error("File renaming failed when loading .mod file. Origin: {}, Target: {}", new Object[]{modFileToLoad.getAbsolutePath(), targetModFile.getAbsolutePath(), e});
                throw new LoadFileException(String.format("File renaming failed when loading .mod file. Origin: %s, Target: %s, because %s", modFileToLoad.getAbsolutePath(), targetModFile.getAbsolutePath(), e.getMessage()));
            }
            finally {
                tsFileResource.setModFile(null);
            }
        }
        this.updatePartitionFileVersion(filePartitionId, tsFileResource.getVersion());
        return true;
    }

    public Collection<TsFileProcessor> getWorkSequenceTsFileProcessors() {
        return this.workSequenceTsFileProcessors.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unloadTsfile(File fileToBeUnloaded, File targetDir) throws IOException {
        TsFileResource tsFileResourceToBeMoved;
        block9: {
            this.writeLock("unloadTsfile");
            tsFileResourceToBeMoved = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.tsFileManager.getIterator(true);
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getTsFile().getName().equals(fileToBeUnloaded.getName())) continue;
                    tsFileResourceToBeMoved = sequenceResource;
                    this.tsFileManager.remove(tsFileResourceToBeMoved, true);
                    FileMetrics.getInstance().deleteTsFile(true, Collections.singletonList(tsFileResourceToBeMoved));
                    break;
                }
                if (tsFileResourceToBeMoved != null) break block9;
                Iterator<TsFileResource> unsequenceIterator = this.tsFileManager.getIterator(false);
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getTsFile().getName().equals(fileToBeUnloaded.getName())) continue;
                    tsFileResourceToBeMoved = unsequenceResource;
                    this.tsFileManager.remove(tsFileResourceToBeMoved, false);
                    FileMetrics.getInstance().deleteTsFile(false, Collections.singletonList(tsFileResourceToBeMoved));
                    break;
                }
            }
            finally {
                this.writeUnlock();
            }
        }
        if (tsFileResourceToBeMoved == null) {
            return false;
        }
        tsFileResourceToBeMoved.writeLock();
        try {
            tsFileResourceToBeMoved.moveTo(targetDir);
            logger.info("Move tsfile {} to target dir {} successfully.", (Object)tsFileResourceToBeMoved.getTsFile(), (Object)targetDir.getPath());
        }
        finally {
            tsFileResourceToBeMoved.writeUnlock();
        }
        return true;
    }

    public Collection<TsFileProcessor> getWorkUnsequenceTsFileProcessors() {
        return this.workUnsequenceTsFileProcessors.values();
    }

    public void setDataTTLWithTimePrecisionCheck(long dataTTL) {
        if (dataTTL != Long.MAX_VALUE) {
            dataTTL = CommonDateTimeUtils.convertMilliTimeWithPrecision((long)dataTTL, (String)CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
        }
        this.dataTTL = dataTTL;
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
    }

    public List<TsFileResource> getSequenceFileList() {
        return this.tsFileManager.getTsFileList(true);
    }

    public List<TsFileResource> getUnSequenceFileList() {
        return this.tsFileManager.getTsFileList(false);
    }

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public String getStorageGroupPath() {
        return this.databaseName + File.separator + this.dataRegionId;
    }

    public boolean isFileAlreadyExist(TsFileResource tsFileResource, long partitionNum) {
        return this.isFileAlreadyExistInWorking(tsFileResource, partitionNum, this.getWorkSequenceTsFileProcessors()) || this.isFileAlreadyExistInWorking(tsFileResource, partitionNum, this.getWorkUnsequenceTsFileProcessors()) || this.isFileAlreadyExistInClosed(tsFileResource, partitionNum, this.getSequenceFileList()) || this.isFileAlreadyExistInClosed(tsFileResource, partitionNum, this.getUnSequenceFileList());
    }

    private boolean isFileAlreadyExistInClosed(TsFileResource tsFileResource, long partitionNum, Collection<TsFileResource> existingFiles) {
        for (TsFileResource resource : existingFiles) {
            if (resource.getTimePartition() != partitionNum || resource.getMaxPlanIndex() <= tsFileResource.getMaxPlanIndex()) continue;
            logger.info("{} is covered by a closed file {}: [{}, {}] [{}, {}]", new Object[]{tsFileResource, resource, tsFileResource.minPlanIndex, tsFileResource.maxPlanIndex, resource.minPlanIndex, resource.maxPlanIndex});
            return true;
        }
        return false;
    }

    private boolean isFileAlreadyExistInWorking(TsFileResource tsFileResource, long partitionNum, Collection<TsFileProcessor> workingProcessors) {
        for (TsFileProcessor workingProcesssor : workingProcessors) {
            boolean isCovered;
            if (workingProcesssor.getTimeRangeId() != partitionNum) continue;
            TsFileResource workResource = workingProcesssor.getTsFileResource();
            boolean bl = isCovered = workResource.getMaxPlanIndex() > tsFileResource.getMaxPlanIndex();
            if (isCovered) {
                logger.info("{} is covered by a working file {}: [{}, {}] [{}, {}]", new Object[]{tsFileResource, workResource, tsFileResource.minPlanIndex, tsFileResource.maxPlanIndex, workResource.minPlanIndex, workResource.maxPlanIndex});
            }
            return isCovered;
        }
        return false;
    }

    public void abortCompaction() {
        this.tsFileManager.setAllowCompaction(false);
        CompactionScheduleTaskManager.getInstance().unregisterDataRegion(this);
        List<AbstractCompactionTask> runningTasks = CompactionTaskManager.getInstance().abortCompaction(this.databaseName + "-" + this.dataRegionId);
        while (CompactionTaskManager.getInstance().isAnyTaskInListStillRunning(runningTasks)) {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.error("Thread get interrupted when waiting compaction to finish", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        this.isCompactionSelecting.set(false);
    }

    public TsFileManager getTsFileResourceManager() {
        return this.tsFileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowsOfOneDeviceNode insertRowsOfOneDeviceNode) throws WriteProcessException, BatchProcessException {
        if (this.enableMemControl) {
            StorageEngine.blockInsertionIfReject(null);
        }
        long startTime = System.nanoTime();
        this.writeLock("InsertRowsOfOneDevice");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            if (this.deleted) {
                return;
            }
            HashMap<TsFileProcessor, Boolean> tsFileProcessorMapForFlushing = new HashMap<TsFileProcessor, Boolean>();
            for (int i = 0; i < insertRowsOfOneDeviceNode.getInsertRowNodeList().size(); ++i) {
                InsertRowNode insertRowNode = insertRowsOfOneDeviceNode.getInsertRowNodeList().get(i);
                if (!this.isAlive(insertRowNode.getTime())) {
                    insertRowsOfOneDeviceNode.getResults().put(i, RpcUtils.getStatus((int)TSStatusCode.OUT_OF_TTL.getStatusCode(), (String)String.format("Insertion time [%s] is less than ttl time bound [%s]", DateTimeUtils.convertLongToDate(insertRowNode.getTime()), DateTimeUtils.convertLongToDate(CommonDateTimeUtils.currentTime() - this.dataTTL))));
                    continue;
                }
                long timePartitionId = TimePartitionUtils.getTimePartitionId((long)insertRowNode.getTime());
                if (config.isEnableSeparateData() && !this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(timePartitionId)) {
                    TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.valueOf(this.dataRegionId).intValue()), timePartitionId, true, Long.MAX_VALUE, 0L));
                }
                boolean isSequence = config.isEnableSeparateData() && insertRowNode.getTime() > this.lastFlushTimeMap.getFlushedTime(timePartitionId, insertRowNode.getDevicePath().getFullPath());
                try {
                    this.insertToTsFileProcessor(insertRowNode, isSequence, timePartitionId, tsFileProcessorMapForFlushing);
                    continue;
                }
                catch (WriteProcessException e) {
                    insertRowsOfOneDeviceNode.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                }
            }
            for (Map.Entry entry : tsFileProcessorMapForFlushing.entrySet()) {
                if (!((TsFileProcessor)entry.getKey()).shouldFlush()) continue;
                this.fileFlushPolicy.apply(this, (TsFileProcessor)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        finally {
            this.writeUnlock();
        }
        if (!insertRowsOfOneDeviceNode.getResults().isEmpty()) {
            throw new BatchProcessException("Partial failed inserting rows of one device");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowsNode insertRowsNode) throws BatchProcessException, WriteProcessRejectException {
        if (this.enableMemControl) {
            StorageEngine.blockInsertionIfReject(null);
        }
        long startTime = System.nanoTime();
        this.writeLock("InsertRows");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            if (this.deleted) {
                return;
            }
            boolean[] areSequence = new boolean[insertRowsNode.getInsertRowNodeList().size()];
            long[] timePartitionIds = new long[insertRowsNode.getInsertRowNodeList().size()];
            for (int i = 0; i < insertRowsNode.getInsertRowNodeList().size(); ++i) {
                InsertRowNode insertRowNode = insertRowsNode.getInsertRowNodeList().get(i);
                if (!this.isAlive(insertRowNode.getTime())) {
                    insertRowsNode.getResults().put(i, RpcUtils.getStatus((int)TSStatusCode.OUT_OF_TTL.getStatusCode(), (String)String.format("Insertion time [%s] is less than ttl time bound [%s]", DateTimeUtils.convertLongToDate(insertRowNode.getTime()), DateTimeUtils.convertLongToDate(CommonDateTimeUtils.currentTime() - this.dataTTL))));
                    continue;
                }
                timePartitionIds[i] = TimePartitionUtils.getTimePartitionId((long)insertRowNode.getTime());
                if (config.isEnableSeparateData() && !this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(timePartitionIds[i])) {
                    TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), timePartitionIds[i], true, Long.MAX_VALUE, 0L));
                }
                areSequence[i] = config.isEnableSeparateData() && insertRowNode.getTime() > this.lastFlushTimeMap.getFlushedTime(timePartitionIds[i], insertRowNode.getDevicePath().getFullPath());
            }
            this.insertToTsFileProcessors(insertRowsNode, areSequence, timePartitionIds);
            if (!insertRowsNode.getResults().isEmpty()) {
                throw new BatchProcessException("Partial failed inserting rows");
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public void insertTablets(InsertMultiTabletsNode insertMultiTabletsNode) throws BatchProcessException {
        for (int i = 0; i < insertMultiTabletsNode.getInsertTabletNodeList().size(); ++i) {
            InsertTabletNode insertTabletNode = insertMultiTabletsNode.getInsertTabletNodeList().get(i);
            try {
                this.insertTablet(insertTabletNode);
                continue;
            }
            catch (WriteProcessException e) {
                insertMultiTabletsNode.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                continue;
            }
            catch (BatchProcessException e) {
                TSStatus firstStatus = null;
                for (TSStatus status : e.getFailingStatus()) {
                    if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        firstStatus = status;
                    }
                    if (status.getCode() != TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode()) continue;
                    insertMultiTabletsNode.getResults().put(i, status);
                    throw new BatchProcessException("Rejected inserting multi tablets");
                }
                insertMultiTabletsNode.getResults().put(i, firstStatus);
            }
        }
        if (!insertMultiTabletsNode.getResults().isEmpty()) {
            throw new BatchProcessException("Partial failed inserting multi tablets");
        }
    }

    public long countRegionDiskSize() {
        AtomicLong diskSize = new AtomicLong(0L);
        TierManager.getInstance().getAllLocalFilesFolders().forEach(folder -> {
            folder = folder + File.separator + this.databaseName + File.separator + this.dataRegionId;
            this.countFolderDiskSize((String)folder, diskSize);
        });
        return diskSize.get() / 1024L / 1024L;
    }

    private void countFolderDiskSize(String folder, AtomicLong diskSize) {
        File file = FSFactoryProducer.getFSFactory().getFile(folder);
        File[] allFile = file.listFiles();
        if (allFile == null) {
            return;
        }
        for (File f : allFile) {
            if (f.isFile()) {
                diskSize.addAndGet(f.length());
                continue;
            }
            if (!f.isDirectory()) continue;
            this.countFolderDiskSize(f.getAbsolutePath(), diskSize);
        }
    }

    public void addSettleFilesToList(List<TsFileResource> seqResourcesToBeSettled, List<TsFileResource> unseqResourcesToBeSettled, List<String> tsFilePaths) {
        if (tsFilePaths.isEmpty()) {
            for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
                if (!resource.isClosed()) continue;
                resource.setSettleTsFileCallBack(this::settleTsFileCallBack);
                seqResourcesToBeSettled.add(resource);
            }
            for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
                if (!resource.isClosed()) continue;
                resource.setSettleTsFileCallBack(this::settleTsFileCallBack);
                unseqResourcesToBeSettled.add(resource);
            }
        } else {
            block2: for (String tsFilePath : tsFilePaths) {
                File fileToBeSettled = new File(tsFilePath);
                if ("sequence".equals(fileToBeSettled.getParentFile().getParentFile().getParentFile().getParentFile().getName())) {
                    for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
                        if (!resource.getTsFile().getAbsolutePath().equals(tsFilePath)) continue;
                        resource.setSettleTsFileCallBack(this::settleTsFileCallBack);
                        seqResourcesToBeSettled.add(resource);
                        continue block2;
                    }
                    continue;
                }
                for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
                    if (!resource.getTsFile().getAbsolutePath().equals(tsFilePath)) continue;
                    unseqResourcesToBeSettled.add(resource);
                    continue block2;
                }
            }
        }
    }

    public void setCustomCloseFileListeners(List<CloseFileListener> customCloseFileListeners) {
        this.customCloseFileListeners = customCloseFileListeners;
    }

    public void setCustomFlushListeners(List<FlushListener> customFlushListeners) {
        this.customFlushListeners = customFlushListeners;
    }

    public void setAllowCompaction(boolean allowCompaction) {
        this.tsFileManager.setAllowCompaction(allowCompaction);
    }

    public List<Long> getTimePartitions() {
        return new ArrayList<Long>(this.partitionMaxFileVersions.keySet());
    }

    public Long getLatestTimePartition() {
        return this.getTimePartitions().stream().max(Long::compareTo).orElse(0L);
    }

    public String getInsertWriteLockHolder() {
        return this.insertWriteLockHolder;
    }

    public IWALNode getWALNode() {
        if (!config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus")) {
            throw new UnsupportedOperationException();
        }
        return WALManager.getInstance().applyForWALNode(this.databaseName + "-" + this.dataRegionId);
    }

    public void waitForDeleted() {
        this.writeLock("waitForDeleted");
        try {
            if (!this.deleted) {
                this.deletedCondition.await();
            }
            FileMetrics.getInstance().deleteRegion(this.databaseName, this.dataRegionId);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted When waiting for data region deleted.");
            Thread.currentThread().interrupt();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void markDeleted() {
        this.writeLock("markDeleted");
        try {
            this.deleted = true;
            this.deletedCondition.signalAll();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void degradeFlushTimeMap(long timePartitionId) {
        this.lastFlushTimeMap.degradeLastFlushTime(timePartitionId);
    }

    public long getMemCost() {
        return this.dataRegionInfo.getMemCost();
    }

    private void renameAndHandleError(String originFileName, String newFileName) {
        try {
            File originFile = new File(originFileName);
            if (originFile.exists()) {
                Files.move(originFile.toPath(), Paths.get(newFileName, new String[0]), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            logger.error("Failed to rename {} to {},", new Object[]{originFileName, newFileName, e});
        }
    }

    @Override
    public long getDataTTL() {
        return this.dataTTL;
    }

    public ILastFlushTimeMap getLastFlushTimeMap() {
        return this.lastFlushTimeMap;
    }

    public TsFileManager getTsFileManager() {
        return this.tsFileManager;
    }

    @FunctionalInterface
    public static interface SettleTsFileCallBack {
        public void call(TsFileResource var1, List<TsFileResource> var2) throws WriteProcessException;
    }

    @FunctionalInterface
    public static interface UpdateEndTimeCallBack {
        public void call(TsFileProcessor var1, Map<String, Long> var2, long var3);
    }

    @FunctionalInterface
    public static interface CloseTsFileCallBack {
        public void call(TsFileProcessor var1) throws TsFileProcessorException, IOException;
    }

    private class DataRegionRecoveryContext {
        private final long numOfFilesToRecover;
        private long recoveredFilesNum;
        private long lastLogTime;
        private final List<UnsealedTsFileRecoverPerformer> recoverPerformers = new ArrayList<UnsealedTsFileRecoverPerformer>();

        public DataRegionRecoveryContext(long numOfFilesToRecover) {
            this.numOfFilesToRecover = numOfFilesToRecover;
            this.recoveredFilesNum = 0L;
            this.lastLogTime = System.currentTimeMillis();
        }

        public void incrementRecoveredFilesNum() {
            ++this.recoveredFilesNum;
            if (this.recoveredFilesNum < this.numOfFilesToRecover) {
                if (System.currentTimeMillis() - this.lastLogTime > config.getRecoveryLogIntervalInMs()) {
                    logger.info("The TsFiles of data region {}[{}] has recovered {}/{}.", new Object[]{DataRegion.this.databaseName, DataRegion.this.dataRegionId, this.recoveredFilesNum, this.numOfFilesToRecover});
                    this.lastLogTime = System.currentTimeMillis();
                }
            } else {
                logger.info("The TsFiles of data region {}[{}] has recovered {}/{}.", new Object[]{DataRegion.this.databaseName, DataRegion.this.dataRegionId, this.numOfFilesToRecover, this.numOfFilesToRecover});
            }
        }
    }
}

