/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.template;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TemplateInternalRPCUtil {
    private TemplateInternalRPCUtil() {
    }

    public static byte[] generateAddTemplateSetInfoBytes(Template template, String templateSetPath) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)1, (OutputStream)outputStream);
            template.serialize(outputStream);
            ReadWriteIOUtils.write((int)1, (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)templateSetPath, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public static Map<Template, List<String>> parseAddTemplateSetInfoBytes(ByteBuffer buffer) {
        int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        HashMap<Template, List<String>> result = new HashMap<Template, List<String>>(templateNum);
        for (int i = 0; i < templateNum; ++i) {
            Template template = new Template();
            template.deserialize(buffer);
            int pathNum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            ArrayList<String> templateSetPathList = new ArrayList<String>(pathNum);
            for (int j = 0; j < pathNum; ++j) {
                templateSetPathList.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
            }
            result.put(template, templateSetPathList);
        }
        return result;
    }

    public static byte[] generateAddAllTemplateSetInfoBytes(Map<Template, List<Pair<String, Boolean>>> templateSetInfo) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)templateSetInfo.size(), (OutputStream)outputStream);
            for (Map.Entry<Template, List<Pair<String, Boolean>>> entry : templateSetInfo.entrySet()) {
                entry.getKey().serialize(outputStream);
                ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)outputStream);
                for (Pair<String, Boolean> templateSetPath : entry.getValue()) {
                    ReadWriteIOUtils.write((String)((String)templateSetPath.left), (OutputStream)outputStream);
                    ReadWriteIOUtils.write((Boolean)((Boolean)templateSetPath.right), (OutputStream)outputStream);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public static Map<Template, List<Pair<String, Boolean>>> parseAddAllTemplateSetInfoBytes(ByteBuffer buffer) {
        int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        HashMap<Template, List<Pair<String, Boolean>>> result = new HashMap<Template, List<Pair<String, Boolean>>>(templateNum);
        for (int i = 0; i < templateNum; ++i) {
            Template template = new Template();
            template.deserialize(buffer);
            int pathNum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            ArrayList<Pair> templateSetPathList = new ArrayList<Pair>(pathNum);
            for (int j = 0; j < pathNum; ++j) {
                templateSetPathList.add(new Pair((Object)ReadWriteIOUtils.readString((ByteBuffer)buffer), (Object)ReadWriteIOUtils.readBool((ByteBuffer)buffer)));
            }
            result.put(template, templateSetPathList);
        }
        return result;
    }

    public static byte[] generateInvalidateTemplateSetInfoBytes(int templateId, String path) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)templateId, (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)path, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public static Pair<Integer, String> parseInvalidateTemplateSetInfoBytes(ByteBuffer buffer) {
        return new Pair((Object)ReadWriteIOUtils.readInt((ByteBuffer)buffer), (Object)ReadWriteIOUtils.readString((ByteBuffer)buffer));
    }

    public static byte[] generateUpdateTemplateInfoBytes(Template template) {
        return template.serialize().array();
    }

    public static Template parseUpdateTemplateInfoBytes(ByteBuffer buffer) {
        Template template = new Template();
        template.deserialize(buffer);
        return template;
    }
}

