/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl;

import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowSchemaResult;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class ShowTimeSeriesResult
extends ShowSchemaResult
implements ITimeSeriesSchemaInfo {
    private String alias;
    private IMeasurementSchema measurementSchema;
    private Map<String, String> tags;
    private Map<String, String> attributes;
    private boolean isUnderAlignedDevice;

    public ShowTimeSeriesResult(String path, String alias, IMeasurementSchema measurementSchema, Map<String, String> tags, Map<String, String> attributes, boolean isUnderAlignedDevice) {
        super(path);
        this.alias = alias;
        this.measurementSchema = measurementSchema;
        this.tags = tags;
        this.attributes = attributes;
        this.isUnderAlignedDevice = isUnderAlignedDevice;
    }

    public ShowTimeSeriesResult() {
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public IMeasurementSchema getSchema() {
        return this.measurementSchema;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isUnderAlignedDevice() {
        return this.isUnderAlignedDevice;
    }

    @Override
    public boolean isLogicalView() {
        return this.measurementSchema.isLogicalView();
    }

    @Override
    public ITimeSeriesSchemaInfo snapshot() {
        return this;
    }

    public TSDataType getDataType() {
        return this.measurementSchema.getType();
    }

    public TSEncoding getEncoding() {
        return this.measurementSchema.getEncodingType();
    }

    public CompressionType getCompressor() {
        return this.measurementSchema.getCompressor();
    }

    public Map<String, String> getTag() {
        return this.tags;
    }

    public Map<String, String> getAttribute() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShowTimeSeriesResult result = (ShowTimeSeriesResult)o;
        return Objects.equals(this.path, result.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

