/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.flush;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.lock.LockManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.IMemoryManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PBTreeFlushExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PBTreeFlushExecutor.class);
    private final Iterator<ICachedMNode> subtreeRoots;
    private final IDatabaseMNode<ICachedMNode> databaseMNode;
    private final AtomicInteger remainToFlush;
    private final IMemoryManager memoryManager;
    private final ISchemaFile file;
    private final LockManager lockManager;

    public PBTreeFlushExecutor(IMemoryManager memoryManager, ISchemaFile file, LockManager lockManager) {
        this.remainToFlush = null;
        this.subtreeRoots = memoryManager.collectVolatileSubtrees();
        this.databaseMNode = memoryManager.collectUpdatedStorageGroupMNodes();
        this.memoryManager = memoryManager;
        this.file = file;
        this.lockManager = lockManager;
    }

    public PBTreeFlushExecutor(AtomicInteger remainToFlush, IMemoryManager memoryManager, ISchemaFile file, LockManager lockManager) {
        this.remainToFlush = remainToFlush;
        this.subtreeRoots = memoryManager.collectVolatileSubtrees();
        this.databaseMNode = memoryManager.collectUpdatedStorageGroupMNodes();
        this.memoryManager = memoryManager;
        this.file = file;
        this.lockManager = lockManager;
    }

    public void flushVolatileNodes(AtomicLong flushNodeNum, AtomicLong flushMemSize) throws MetadataException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (this.databaseMNode != null && this.checkRemainToFlush()) {
            try {
                this.processFlushDatabase(this.databaseMNode);
                flushNodeNum.incrementAndGet();
                flushMemSize.addAndGet(this.databaseMNode.estimateSize());
            }
            catch (Exception e) {
                exceptions.add(e);
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        while (this.subtreeRoots.hasNext() && this.checkRemainToFlush()) {
            try {
                this.processFlushNonDatabase(this.subtreeRoots.next(), flushNodeNum, flushMemSize);
            }
            catch (Exception e) {
                exceptions.add(e);
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new MetadataException(exceptions.stream().map(Throwable::getMessage).reduce("", (a, b) -> a + ", " + b));
        }
    }

    private boolean checkRemainToFlush() {
        if (this.remainToFlush == null) {
            return true;
        }
        return this.remainToFlush.decrementAndGet() >= 0;
    }

    private void processFlushDatabase(IDatabaseMNode<ICachedMNode> updatedStorageGroupMNode) throws IOException {
        try {
            this.file.updateDatabaseNode(updatedStorageGroupMNode);
        }
        catch (IOException e) {
            logger.warn("IOException occurred during updating StorageGroupMNode {}", (Object)updatedStorageGroupMNode.getFullPath(), (Object)e);
            throw e;
        }
    }

    private void processFlushNonDatabase(ICachedMNode subtreeRoot, AtomicLong flushNodeNum, AtomicLong flushMemSize) throws MetadataException, IOException {
        ArrayList<ICachedMNode> collectedVolatileSubtrees;
        Iterator<ICachedMNode> volatileSubtreeIterator;
        try {
            this.file.writeMNode(subtreeRoot);
            flushNodeNum.incrementAndGet();
            flushMemSize.addAndGet(subtreeRoot.estimateSize());
            volatileSubtreeIterator = this.memoryManager.updateCacheStatusAndRetrieveSubtreeAfterPersist(subtreeRoot);
            collectedVolatileSubtrees = new ArrayList<ICachedMNode>();
            while (volatileSubtreeIterator.hasNext()) {
                collectedVolatileSubtrees.add(volatileSubtreeIterator.next());
            }
        }
        catch (IOException | MetadataException e) {
            logger.warn("Error occurred during MTree flush, current node is {}", (Object)subtreeRoot.getFullPath(), (Object)e);
            this.memoryManager.updateCacheStatusAfterFlushFailure(subtreeRoot);
            throw e;
        }
        finally {
            this.lockManager.writeUnlock(subtreeRoot);
        }
        ArrayDeque<Iterator<ICachedMNode>> volatileSubtreeStack = new ArrayDeque<Iterator<ICachedMNode>>();
        volatileSubtreeStack.push(collectedVolatileSubtrees.iterator());
        while (!volatileSubtreeStack.isEmpty()) {
            Iterator subtreeIterator = (Iterator)volatileSubtreeStack.peek();
            if (!subtreeIterator.hasNext()) {
                volatileSubtreeStack.pop();
                continue;
            }
            subtreeRoot = (ICachedMNode)subtreeIterator.next();
            try {
                this.file.writeMNode(subtreeRoot);
                flushNodeNum.incrementAndGet();
                flushMemSize.addAndGet(subtreeRoot.estimateSize());
                collectedVolatileSubtrees = new ArrayList();
                volatileSubtreeIterator = this.memoryManager.updateCacheStatusAndRetrieveSubtreeAfterPersist(subtreeRoot);
                while (volatileSubtreeIterator.hasNext()) {
                    collectedVolatileSubtrees.add(volatileSubtreeIterator.next());
                }
            }
            catch (IOException | MetadataException e) {
                logger.warn("Error occurred during MTree flush, current node is {}", (Object)subtreeRoot.getFullPath(), (Object)e);
                this.processNotFlushedSubtrees(subtreeRoot, volatileSubtreeStack);
                throw e;
            }
            finally {
                this.lockManager.writeUnlock(subtreeRoot);
            }
            volatileSubtreeStack.push(collectedVolatileSubtrees.iterator());
        }
    }

    private void processNotFlushedSubtrees(ICachedMNode currentNode, Deque<Iterator<ICachedMNode>> volatileSubtreeStack) {
        this.memoryManager.updateCacheStatusAfterFlushFailure(currentNode);
        while (!volatileSubtreeStack.isEmpty()) {
            Iterator<ICachedMNode> subtreeIterator = volatileSubtreeStack.pop();
            while (subtreeIterator.hasNext()) {
                ICachedMNode node = subtreeIterator.next();
                this.memoryManager.updateCacheStatusAfterFlushFailure(node);
                this.lockManager.writeUnlock(node);
            }
        }
    }
}

