/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.join;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TwoChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LeftOuterTimeJoinNode
extends TwoChildProcessNode {
    private final Ordering mergeOrder;

    public LeftOuterTimeJoinNode(PlanNodeId id, Ordering mergeOrder) {
        super(id);
        this.mergeOrder = mergeOrder;
    }

    public LeftOuterTimeJoinNode(PlanNodeId id, Ordering mergeOrder, PlanNode leftChild, PlanNode rightChild) {
        super(id, leftChild, rightChild);
        this.mergeOrder = mergeOrder;
    }

    public Ordering getMergeOrder() {
        return this.mergeOrder;
    }

    @Override
    public PlanNode clone() {
        return new LeftOuterTimeJoinNode(this.getPlanNodeId(), this.getMergeOrder());
    }

    @Override
    public List<String> getOutputColumnNames() {
        List<String> outputColumnNames = this.leftChild.getOutputColumnNames();
        outputColumnNames.addAll(this.rightChild.getOutputColumnNames());
        return outputColumnNames;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLeftOuterTimeJoin(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LEFT_OUTER_TIME_JOIN.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.mergeOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LEFT_OUTER_TIME_JOIN.serialize(stream);
        ReadWriteIOUtils.write((int)this.mergeOrder.ordinal(), (OutputStream)stream);
    }

    public static LeftOuterTimeJoinNode deserialize(ByteBuffer byteBuffer) {
        Ordering mergeOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LeftOuterTimeJoinNode(planNodeId, mergeOrder);
    }

    public String toString() {
        return "LeftOuterTimeJoinNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LeftOuterTimeJoinNode that = (LeftOuterTimeJoinNode)o;
        return this.mergeOrder == that.mergeOrder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mergeOrder});
    }
}

