/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.other;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.queryengine.common.NodeRef;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TimeDuration;

public class GroupByTimeExpression
extends Expression {
    private final long startTime;
    private final long endTime;
    private final TimeDuration interval;
    private final TimeDuration slidingStep;

    public GroupByTimeExpression(long startTime, long endTime, TimeDuration interval, TimeDuration slidingStep) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.interval = interval;
        this.slidingStep = slidingStep;
    }

    public GroupByTimeExpression(ByteBuffer byteBuffer) {
        this.startTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        this.endTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        this.interval = TimeDuration.deserialize((ByteBuffer)byteBuffer);
        this.slidingStep = TimeDuration.deserialize((ByteBuffer)byteBuffer);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public TimeDuration getInterval() {
        return this.interval;
    }

    public TimeDuration getSlidingStep() {
        return this.slidingStep;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.GROUP_BY_TIME;
    }

    @Override
    public boolean isMappable(Map<NodeRef<Expression>, TSDataType> expressionTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isConstantOperandInternal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Expression> getExpressions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.getExpressionStringInternal();
    }

    @Override
    protected String getExpressionStringInternal() {
        return "group by time([" + this.startTime + ", " + this.endTime + "], " + this.interval + ", " + this.slidingStep + ")";
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((long)this.startTime, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.endTime, (ByteBuffer)byteBuffer);
        this.interval.serialize(byteBuffer);
        this.slidingStep.serialize(byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.startTime, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.endTime, (OutputStream)stream);
        this.interval.serialize(stream);
        this.slidingStep.serialize(stream);
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitGroupByTimeExpression(this, context);
    }
}

