/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetSeriesSlotListStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class GetSeriesSlotListTask
implements IConfigTask {
    private final GetSeriesSlotListStatement getSeriesSlotListStatement;

    public GetSeriesSlotListTask(GetSeriesSlotListStatement getSeriesSlotListStatement) {
        this.getSeriesSlotListStatement = getSeriesSlotListStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) {
        return configTaskExecutor.getSeriesSlotList(this.getSeriesSlotListStatement);
    }

    public static void buildTsBlock(TsBlockBuilder builder, TSeriesPartitionSlot tSeriesPartitionSlot) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeInt(tSeriesPartitionSlot.getSlotId());
        builder.declarePosition();
    }

    public static void buildTsBlock(TGetSeriesSlotListResp getSeriesSlotListResp, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.getSeriesSlotListColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        getSeriesSlotListResp.getSeriesSlotList().forEach(e -> GetSeriesSlotListTask.buildTsBlock(builder, e));
        DatasetHeader datasetHeader = DatasetHeaderFactory.getGetSeriesSlotListHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

