/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.load;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.exception.LoadRuntimeOutOfMemoryException;
import org.apache.iotdb.db.queryengine.load.LoadTsFileAbstractMemoryBlock;
import org.apache.iotdb.db.queryengine.load.LoadTsFileMemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileDataCacheMemoryBlock
extends LoadTsFileAbstractMemoryBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileDataCacheMemoryBlock.class);
    private static final long MINIMUM_MEMORY_SIZE_IN_BYTES = 0x100000L;
    private static final int MAX_ASK_FOR_MEMORY_COUNT = 256;
    private static final long EACH_ASK_MEMORY_SIZE_IN_BYTES = Math.max(0x100000L, LoadTsFileMemoryManager.MEMORY_TOTAL_SIZE_FROM_QUERY_IN_BYTES >> 4);
    private final AtomicLong limitedMemorySizeInBytes;
    private final AtomicLong memoryUsageInBytes;
    private final AtomicInteger askForMemoryCount;
    private final AtomicInteger referenceCount;

    LoadTsFileDataCacheMemoryBlock(long initialLimitedMemorySizeInBytes) {
        if (initialLimitedMemorySizeInBytes < 0x100000L) {
            throw new LoadRuntimeOutOfMemoryException(String.format("The initial limited memory size %d is less than the minimum memory size %d", initialLimitedMemorySizeInBytes, 0x100000L));
        }
        this.limitedMemorySizeInBytes = new AtomicLong(initialLimitedMemorySizeInBytes);
        this.memoryUsageInBytes = new AtomicLong(0L);
        this.askForMemoryCount = new AtomicInteger(1);
        this.referenceCount = new AtomicInteger(0);
    }

    @Override
    public boolean hasEnoughMemory(long memoryTobeAddedInBytes) {
        return this.memoryUsageInBytes.get() + memoryTobeAddedInBytes <= this.limitedMemorySizeInBytes.get();
    }

    @Override
    public void addMemoryUsage(long memoryInBytes) {
        this.memoryUsageInBytes.addAndGet(memoryInBytes);
        this.askForMemoryCount.getAndUpdate(count -> {
            if ((count & count - 1) == 0) {
                long actuallyAllocateMemorySizeInBytes = MEMORY_MANAGER.tryAllocateFromQuery(EACH_ASK_MEMORY_SIZE_IN_BYTES);
                this.limitedMemorySizeInBytes.addAndGet(actuallyAllocateMemorySizeInBytes);
                if (actuallyAllocateMemorySizeInBytes < EACH_ASK_MEMORY_SIZE_IN_BYTES) {
                    return (count & 0xFF) + 1;
                }
                return 1;
            }
            return (count & 0xFF) + 1;
        });
    }

    @Override
    public void reduceMemoryUsage(long memoryInBytes) {
        this.memoryUsageInBytes.addAndGet(-memoryInBytes);
    }

    @Override
    protected void releaseAllMemory() {
        if (this.memoryUsageInBytes.get() != 0L) {
            LOGGER.warn("Try to release memory from a memory block {} which has not released all memory", (Object)this);
        }
        MEMORY_MANAGER.releaseToQuery(this.limitedMemorySizeInBytes.get());
    }

    public boolean doShrink(long shrinkMemoryInBytes) {
        if (shrinkMemoryInBytes < 0L) {
            LOGGER.warn("Try to shrink a negative memory size {} from memory block {}", (Object)shrinkMemoryInBytes, (Object)this);
            return false;
        }
        if (shrinkMemoryInBytes == 0L) {
            return true;
        }
        if (this.limitedMemorySizeInBytes.get() - shrinkMemoryInBytes <= 0x100000L) {
            return false;
        }
        this.limitedMemorySizeInBytes.addAndGet(-shrinkMemoryInBytes);
        return true;
    }

    void updateReferenceCount(int delta) {
        this.referenceCount.addAndGet(delta);
    }

    int getReferenceCount() {
        return this.referenceCount.get();
    }

    long getMemoryUsageInBytes() {
        return this.memoryUsageInBytes.get();
    }

    long getLimitedMemorySizeInBytes() {
        return this.limitedMemorySizeInBytes.get();
    }

    public String toString() {
        return "LoadTsFileDataCacheMemoryBlock{limitedMemorySizeInBytes=" + this.limitedMemorySizeInBytes.get() + ", memoryUsageInBytes=" + this.memoryUsageInBytes.get() + ", askForMemoryCount=" + this.askForMemoryCount.get() + '}';
    }
}

