/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.filter;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.filter.AbstractMonthIntervalFillFilter;

public class MonthIntervalMSFillFilter
extends AbstractMonthIntervalFillFilter {
    public MonthIntervalMSFillFilter(int monthDuration, long nonMonthDuration, ZoneId zone) {
        super(monthDuration, nonMonthDuration, zone);
    }

    @Override
    public boolean needFill(long time, long previousTime) {
        long smaller = Math.min(time, previousTime);
        long greater = Math.max(time, previousTime);
        Instant instant = Instant.ofEpochMilli(smaller);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, this.zone);
        long epochMilli = localDateTime.plusMonths(this.monthDuration).toInstant(this.zoneOffset).toEpochMilli() + this.nonMonthDuration;
        return epochMilli >= greater;
    }
}

