/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.stage;

import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskProcessorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.task.EventSupplier;
import org.apache.iotdb.commons.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.task.stage.PipeTaskStage;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.execution.executor.PipeProcessorSubtaskExecutor;
import org.apache.iotdb.db.pipe.task.connection.PipeEventCollector;
import org.apache.iotdb.db.pipe.task.subtask.processor.PipeProcessorSubtask;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeTaskProcessorStage
extends PipeTaskStage {
    private final PipeProcessorSubtaskExecutor executor;
    private final PipeProcessorSubtask pipeProcessorSubtask;

    public PipeTaskProcessorStage(String pipeName, long creationTime, PipeParameters pipeProcessorParameters, TConsensusGroupId dataRegionId, EventSupplier pipeExtractorInputEventSupplier, BoundedBlockingPendingQueue<Event> pipeConnectorOutputPendingQueue, PipeProcessorSubtaskExecutor executor) {
        PipeProcessor pipeProcessor = PipeAgent.plugin().dataRegion().reflectProcessor(pipeProcessorParameters);
        try {
            pipeProcessor.validate(new PipeParameterValidator(pipeProcessorParameters));
            PipeTaskRuntimeConfiguration runtimeConfiguration = new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)new PipeTaskProcessorRuntimeEnvironment(pipeName, creationTime, dataRegionId.getId()));
            pipeProcessor.customize(pipeProcessorParameters, (PipeProcessorRuntimeConfiguration)runtimeConfiguration);
        }
        catch (Exception e) {
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
        String taskId = pipeName + "_" + dataRegionId.getId() + "_" + creationTime;
        PipeEventCollector pipeConnectorOutputEventCollector = new PipeEventCollector(pipeConnectorOutputPendingQueue, dataRegionId.getId());
        this.pipeProcessorSubtask = new PipeProcessorSubtask(taskId, creationTime, pipeName, dataRegionId.getId(), pipeExtractorInputEventSupplier, pipeProcessor, pipeConnectorOutputEventCollector);
        this.executor = executor;
    }

    public void createSubtask() throws PipeException {
        this.executor.register(this.pipeProcessorSubtask);
    }

    public void startSubtask() throws PipeException {
        this.executor.start(this.pipeProcessorSubtask.getTaskID());
    }

    public void stopSubtask() throws PipeException {
        this.executor.stop(this.pipeProcessorSubtask.getTaskID());
    }

    public void dropSubtask() throws PipeException {
        this.executor.deregister(this.pipeProcessorSubtask.getTaskID());
    }
}

