/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceManager;
import org.apache.iotdb.db.pipe.resource.wal.PipeWALResourceManager;
import org.apache.iotdb.db.pipe.resource.wal.hardlink.PipeWALHardlinkResourceManager;
import org.apache.iotdb.db.pipe.resource.wal.selfhost.PipeWALSelfHostResourceManager;

public class PipeResourceManager {
    private final PipeTsFileResourceManager pipeTsFileResourceManager = new PipeTsFileResourceManager();
    private final AtomicReference<PipeWALResourceManager> pipeWALResourceManager = new AtomicReference();
    private final PipeMemoryManager pipeMemoryManager = new PipeMemoryManager();

    public static PipeTsFileResourceManager tsfile() {
        return PipeResourceManagerHolder.INSTANCE.pipeTsFileResourceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PipeWALResourceManager wal() {
        if (PipeResourceManagerHolder.INSTANCE.pipeWALResourceManager.get() == null) {
            PipeResourceManager pipeResourceManager = PipeResourceManagerHolder.INSTANCE;
            synchronized (pipeResourceManager) {
                if (PipeResourceManagerHolder.INSTANCE.pipeWALResourceManager.get() == null) {
                    PipeResourceManagerHolder.INSTANCE.pipeWALResourceManager.set(PipeConfig.getInstance().getPipeHardLinkWALEnabled() ? new PipeWALHardlinkResourceManager() : new PipeWALSelfHostResourceManager());
                }
            }
        }
        return PipeResourceManagerHolder.INSTANCE.pipeWALResourceManager.get();
    }

    public static PipeMemoryManager memory() {
        return PipeResourceManagerHolder.INSTANCE.pipeMemoryManager;
    }

    private PipeResourceManager() {
    }

    private static class PipeResourceManagerHolder {
        private static final PipeResourceManager INSTANCE = new PipeResourceManager();

        private PipeResourceManagerHolder() {
        }
    }
}

