/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.downsampling;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskProcessorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.processor.downsampling.PartialPathLastTimeCache;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownSamplingProcessor
implements PipeProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownSamplingProcessor.class);
    private String dataBaseNameWithPathSeparator;
    private long intervalInCurrentPrecision;
    private boolean shouldSplitFile;
    private PartialPathLastTimeCache partialPathLastTimeCache;

    public void validate(PipeParameterValidator validator) throws Exception {
    }

    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) throws Exception {
        String dataBaseName = StorageEngine.getInstance().getDataRegion(new DataRegionId(((PipeTaskProcessorRuntimeEnvironment)configuration.getRuntimeEnvironment()).getRegionId())).getDatabaseName();
        long intervalSeconds = parameters.getLongOrDefault("processor.down-sampling.interval-seconds", 60L);
        long memoryLimitInBytes = parameters.getLongOrDefault("processor.down-sampling.memory-limit-in-bytes", 0x1000000L);
        this.shouldSplitFile = parameters.getBooleanOrDefault("processor.down-sampling.split-file", false);
        LOGGER.info("DownSamplingProcessor in {} is initialized with {}: {}s, {}: {}, {}: {}.", new Object[]{dataBaseName, "processor.down-sampling.interval-seconds", intervalSeconds, "processor.down-sampling.memory-limit-in-bytes", memoryLimitInBytes, "processor.down-sampling.split-file", this.shouldSplitFile});
        this.dataBaseNameWithPathSeparator = dataBaseName + ".";
        this.intervalInCurrentPrecision = TimestampPrecisionUtils.convertToCurrPrecision(intervalSeconds, TimeUnit.SECONDS);
        this.partialPathLastTimeCache = new PartialPathLastTimeCache(memoryLimitInBytes);
    }

    public void process(TabletInsertionEvent tabletInsertionEvent, EventCollector eventCollector) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            eventCollector.collect((Event)tabletInsertionEvent);
            return;
        }
        AtomicReference deviceSuffix = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        tabletInsertionEvent.processRowByRow((row, rowCollector) -> {
            if (deviceSuffix.get() == null) {
                deviceSuffix.set(row.getDeviceId().replaceFirst(this.dataBaseNameWithPathSeparator, ""));
            }
            this.processRow((Row)row, (RowCollector)rowCollector, (String)deviceSuffix.get(), exception);
        }).forEach(event -> {
            try {
                eventCollector.collect((Event)event);
            }
            catch (Exception e) {
                exception.set(e);
            }
        });
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
    }

    private void processRow(Row row, RowCollector rowCollector, String deviceSuffix, AtomicReference<Exception> exception) {
        boolean hasNonNullMeasurements = false;
        int size = row.size();
        for (int index = 0; index < size; ++index) {
            if (row.isNull(index)) continue;
            String timeSeriesSuffix = deviceSuffix + "." + row.getColumnName(index);
            Long lastSampleTime = this.partialPathLastTimeCache.getPartialPathLastTime(timeSeriesSuffix);
            if (lastSampleTime != null) {
                if (Math.abs(row.getTime() - lastSampleTime) < this.intervalInCurrentPrecision) continue;
                hasNonNullMeasurements = true;
                this.partialPathLastTimeCache.setPartialPathLastTime(timeSeriesSuffix, row.getTime());
                continue;
            }
            hasNonNullMeasurements = true;
            this.partialPathLastTimeCache.setPartialPathLastTime(timeSeriesSuffix, row.getTime());
        }
        if (hasNonNullMeasurements) {
            try {
                rowCollector.collectRow(row);
            }
            catch (Exception e) {
                exception.set(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(TsFileInsertionEvent tsFileInsertionEvent, EventCollector eventCollector) throws Exception {
        if (this.shouldSplitFile) {
            try {
                for (TabletInsertionEvent tabletInsertionEvent : tsFileInsertionEvent.toTabletInsertionEvents()) {
                    this.process(tabletInsertionEvent, eventCollector);
                }
            }
            finally {
                tsFileInsertionEvent.close();
            }
        } else {
            eventCollector.collect((Event)tsFileInsertionEvent);
        }
    }

    public void process(Event event, EventCollector eventCollector) throws Exception {
        eventCollector.collect(event);
    }

    public void close() throws Exception {
        if (this.partialPathLastTimeCache != null) {
            this.partialPathLastTimeCache.close();
        }
    }
}

