/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.extractor.historical.PipeHistoricalDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.historical.PipeHistoricalDataRegionTsFileExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionFakeExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionHybridExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionLogExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionTsFileExtractor;
import org.apache.iotdb.db.pipe.metric.PipeExtractorMetrics;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataRegionExtractor
implements PipeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataRegionExtractor.class);
    private final AtomicBoolean hasBeenStarted = new AtomicBoolean(false);
    private PipeHistoricalDataRegionExtractor historicalExtractor;
    private PipeRealtimeDataRegionExtractor realtimeExtractor;
    private String taskID;
    private String pipeName;
    private long creationTime;
    private int dataRegionId;

    public void validate(PipeParameterValidator validator) throws Exception {
        this.validatePattern(validator.getParameters().getStringOrDefault(Arrays.asList("extractor.pattern", "source.pattern"), "root"));
        validator.validateAttributeValueRange("extractor.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("extractor.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("source.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("source.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false, "Should not set both history.enable and realtime.enable to false.", new Object[]{validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true), validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)});
        if (validator.getParameters().hasAnyAttributes(new String[]{"source.start-time", "source.end-time"}) && validator.getParameters().hasAnyAttributes(new String[]{"extractor.history.enable", "extractor.realtime.enable", "source.history.enable", "source.realtime.enable"})) {
            LOGGER.warn("When {} or {} is specified, specifying {}, {}, {} and {} is invalid.", new Object[]{"source.start-time", "source.end-time", "extractor.history.start-time", "source.history.start-time", "extractor.history.end-time", "source.history.end-time"});
        }
        this.constructHistoricalExtractor();
        this.constructRealtimeExtractor(validator.getParameters());
        this.historicalExtractor.validate(validator);
        this.realtimeExtractor.validate(validator);
    }

    private void validatePattern(String pattern) {
        if (!pattern.startsWith("root")) {
            throw new IllegalArgumentException("The argument `extractor.pattern` or `source.pattern` is an illegal path.");
        }
        try {
            PathUtils.isLegalPath((String)pattern);
        }
        catch (IllegalPathException e) {
            try {
                if ("root".equals(pattern) || "root.".equals(pattern)) {
                    return;
                }
                String[] pathNodes = StringUtils.splitPreserveAllTokens((String)pattern, (String)"\\.");
                PathUtils.splitPathToDetachedNodes((String)String.join((CharSequence)".", Arrays.copyOfRange(pathNodes, 0, pathNodes.length - 1)));
                String lastNode = pathNodes[pathNodes.length - 1];
                if (!"".equals(lastNode)) {
                    Double.parseDouble(lastNode);
                }
            }
            catch (Exception ignored) {
                throw new IllegalArgumentException("The argument `extractor.pattern` or `source.pattern` is an illegal path.");
            }
        }
    }

    private void constructHistoricalExtractor() {
        this.historicalExtractor = new PipeHistoricalDataRegionTsFileExtractor();
    }

    private void constructRealtimeExtractor(PipeParameters parameters) {
        if (!parameters.getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)) {
            this.realtimeExtractor = new PipeRealtimeDataRegionFakeExtractor();
            LOGGER.info("Pipe {}@{}: '{}' is set to false, use fake realtime extractor.", new Object[]{this.pipeName, this.dataRegionId, "extractor.realtime.enable"});
            return;
        }
        this.realtimeExtractor = new PipeRealtimeDataRegionTsFileExtractor();
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        this.dataRegionId = ((PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment()).getRegionId();
        this.pipeName = configuration.getRuntimeEnvironment().getPipeName();
        this.creationTime = configuration.getRuntimeEnvironment().getCreationTime();
        this.taskID = this.pipeName + "_" + this.dataRegionId + "_" + this.creationTime;
        this.historicalExtractor.customize(parameters, configuration);
        this.realtimeExtractor.customize(parameters, configuration);
        PipeExtractorMetrics.getInstance().register(this);
    }

    public void start() throws Exception {
        if (this.hasBeenStarted.get()) {
            return;
        }
        this.hasBeenStarted.set(true);
        AtomicReference<Object> exceptionHolder = new AtomicReference<Object>(null);
        DataRegionId dataRegionIdObject = new DataRegionId(this.dataRegionId);
        while (true) {
            if (StorageEngine.getInstance().runIfPresent(dataRegionIdObject, dataRegion -> {
                dataRegion.writeLock(String.format("Pipe: starting %s", IoTDBDataRegionExtractor.class.getName()));
                try {
                    this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder);
                }
                finally {
                    dataRegion.writeUnlock();
                }
            }) || StorageEngine.getInstance().runIfAbsent(dataRegionIdObject, () -> this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder))) {
                this.rethrowExceptionIfAny(exceptionHolder);
                return;
            }
            this.rethrowExceptionIfAny(exceptionHolder);
        }
    }

    private void startHistoricalExtractorAndRealtimeExtractor(AtomicReference<Exception> exceptionHolder) {
        try {
            this.realtimeExtractor.start();
            this.historicalExtractor.start();
        }
        catch (Exception e) {
            exceptionHolder.set(e);
            LOGGER.warn("Pipe {}@{}: Start historical extractor {} and realtime extractor {} error.", new Object[]{this.pipeName, this.dataRegionId, this.historicalExtractor, this.realtimeExtractor, e});
        }
    }

    private void rethrowExceptionIfAny(AtomicReference<Exception> exceptionHolder) {
        if (exceptionHolder.get() != null) {
            throw new PipeException("failed to start extractors.", (Throwable)exceptionHolder.get());
        }
    }

    public Event supply() throws Exception {
        Event event;
        Event event2 = event = this.historicalExtractor.hasConsumedAll() ? this.realtimeExtractor.supply() : this.historicalExtractor.supply();
        if (Objects.nonNull(event)) {
            if (event instanceof TabletInsertionEvent) {
                PipeExtractorMetrics.getInstance().markTabletEvent(this.taskID);
            } else if (event instanceof TsFileInsertionEvent) {
                PipeExtractorMetrics.getInstance().markTsFileEvent(this.taskID);
            } else if (event instanceof PipeHeartbeatEvent) {
                PipeExtractorMetrics.getInstance().markPipeHeartbeatEvent(this.taskID);
            }
        }
        return event;
    }

    public void close() throws Exception {
        this.historicalExtractor.close();
        this.realtimeExtractor.close();
        if (Objects.nonNull(this.taskID)) {
            PipeExtractorMetrics.getInstance().deregister(this.taskID);
        }
    }

    public boolean isStreamMode() {
        return this.realtimeExtractor instanceof PipeRealtimeDataRegionHybridExtractor || this.realtimeExtractor instanceof PipeRealtimeDataRegionLogExtractor;
    }

    public boolean hasConsumedAllHistoricalTsFiles() {
        return this.historicalExtractor.hasConsumedAll();
    }

    public String getTaskID() {
        return this.taskID;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public int getDataRegionId() {
        return this.dataRegionId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getHistoricalTsFileInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.historicalExtractor.getPendingQueueSize() : 0;
    }

    public int getTabletInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getTabletInsertionEventCount() : 0;
    }

    public int getRealtimeTsFileInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getTsFileInsertionEventCount() : 0;
    }

    public int getPipeHeartbeatEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getPipeHeartbeatEventCount() : 0;
    }
}

