/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.sync;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBThriftSyncConnectorClient;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.iotdb.IoTDBConnector;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.builder.IoTDBThriftSyncPipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.reponse.PipeTransferFilePieceResp;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferFilePieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferFileSealReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBThriftSyncClientManager;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThriftSyncConnector
extends IoTDBConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftSyncConnector.class);
    private IoTDBThriftSyncPipeTransferBatchReqBuilder tabletBatchBuilder;
    private IoTDBThriftSyncClientManager clientManager;

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        IoTDBConfig ioTDBConfig = IoTDBDescriptor.getInstance().getConfig();
        PipeParameters parameters = validator.getParameters();
        String userSpecifiedConnectorName = parameters.getStringOrDefault((List)ImmutableList.of((Object)"connector", (Object)"sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName()).toLowerCase();
        Set givenNodeUrls = this.parseNodeUrls(parameters);
        validator.validate(empty -> {
            try {
                return !NodeUrlUtils.containsLocalAddress(givenNodeUrls.stream().filter(tEndPoint -> tEndPoint.getPort() == ioTDBConfig.getRpcPort()).map(TEndPoint::getIp).collect(Collectors.toList()));
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Unknown host when checking pipe sink IP.", (Throwable)e);
                return false;
            }
        }, String.format("One of the endpoints %s of the receivers is pointing back to the thrift receiver %s on sender itself, or unknown host when checking pipe sink IP.", givenNodeUrls, new TEndPoint(ioTDBConfig.getRpcAddress(), ioTDBConfig.getRpcPort())), new Object[0]).validate(args -> (Boolean)args[0] == false || (Boolean)args[1] != false && (Boolean)args[2] != false, String.format("When ssl transport is enabled, %s and %s must be specified", "sink.ssl.trust-store-path", "sink.ssl.trust-store-pwd"), new Object[]{BuiltinPipePlugin.IOTDB_THRIFT_SSL_CONNECTOR.getPipePluginName().equals(userSpecifiedConnectorName) || BuiltinPipePlugin.IOTDB_THRIFT_SSL_SINK.getPipePluginName().equals(userSpecifiedConnectorName) || parameters.getBooleanOrDefault("sink.ssl.enable", false), parameters.hasAttribute("sink.ssl.trust-store-path"), parameters.hasAttribute("sink.ssl.trust-store-pwd")});
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        if (this.isTabletBatchModeEnabled) {
            this.tabletBatchBuilder = new IoTDBThriftSyncPipeTransferBatchReqBuilder(parameters);
        }
        String userSpecifiedConnectorName = parameters.getStringOrDefault((List)ImmutableList.of((Object)"connector", (Object)"sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName()).toLowerCase();
        boolean useSSL = BuiltinPipePlugin.IOTDB_THRIFT_SSL_CONNECTOR.getPipePluginName().equals(userSpecifiedConnectorName) || BuiltinPipePlugin.IOTDB_THRIFT_SSL_SINK.getPipePluginName().equals(userSpecifiedConnectorName) || parameters.getBooleanOrDefault("sink.ssl.enable", false);
        String trustStorePath = parameters.getString("sink.ssl.trust-store-path");
        String trustStorePwd = parameters.getString("sink.ssl.trust-store-pwd");
        boolean useLeaderCache = parameters.getBooleanOrDefault(Arrays.asList("sink.leader-cache.enable", "connector.leader-cache.enable"), true);
        this.clientManager = new IoTDBThriftSyncClientManager(this.nodeUrls, useSSL, trustStorePath, trustStorePwd, useLeaderCache);
    }

    public void handshake() throws Exception {
        this.clientManager.checkClientStatusAndTryReconstructIfNecessary();
    }

    public void heartbeat() {
        try {
            this.handshake();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to reconnect to target server, because: {}. Try to reconnect later.", (Object)e.getMessage(), (Object)e);
        }
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("IoTDBThriftSyncConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Ignore {}.", (Object)tabletInsertionEvent);
            return;
        }
        if (((EnrichedEvent)tabletInsertionEvent).shouldParsePatternOrTime()) {
            if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                this.transfer(((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent).parseEventWithPatternOrTime());
            } else {
                this.transfer(((PipeRawTabletInsertionEvent)tabletInsertionEvent).parseEventWithPatternOrTime());
            }
            return;
        }
        if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent && ((PipeRawTabletInsertionEvent)tabletInsertionEvent).hasNoNeedParsingAndIsEmpty()) {
            return;
        }
        try {
            if (this.isTabletBatchModeEnabled) {
                if (this.tabletBatchBuilder.onEvent(tabletInsertionEvent)) {
                    this.doTransfer();
                }
            } else if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                this.doTransfer((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent);
            } else {
                this.doTransfer((PipeRawTabletInsertionEvent)tabletInsertionEvent);
            }
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format("Failed to transfer tablet insertion event %s, because %s.", tabletInsertionEvent, e.getMessage()), (Throwable)e);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("IoTDBThriftSyncConnector only support PipeTsFileInsertionEvent. Ignore {}.", (Object)tsFileInsertionEvent);
            return;
        }
        if (!((PipeTsFileInsertionEvent)tsFileInsertionEvent).waitForTsFileClose()) {
            LOGGER.warn("Pipe skipping temporary TsFile which shouldn't be transferred: {}", (Object)((PipeTsFileInsertionEvent)tsFileInsertionEvent).getTsFile());
            return;
        }
        if (((EnrichedEvent)tsFileInsertionEvent).shouldParsePatternOrTime()) {
            for (TabletInsertionEvent event : tsFileInsertionEvent.toTabletInsertionEvents()) {
                this.transfer(event);
            }
            return;
        }
        try {
            if (this.isTabletBatchModeEnabled && !this.tabletBatchBuilder.isEmpty()) {
                this.doTransfer();
            }
            this.doTransfer((PipeTsFileInsertionEvent)tsFileInsertionEvent);
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format("Failed to transfer tsfile insertion event %s, because %s.", tsFileInsertionEvent, e.getMessage()), (Throwable)e);
        }
    }

    public void transfer(Event event) throws TException, IOException {
        if (this.isTabletBatchModeEnabled && !this.tabletBatchBuilder.isEmpty()) {
            this.doTransfer();
        }
        if (!(event instanceof PipeHeartbeatEvent)) {
            LOGGER.warn("IoTDBThriftSyncConnector does not support transferring generic event: {}.", (Object)event);
        }
    }

    private void doTransfer() {
        TPipeTransferResp resp;
        Pair<IoTDBThriftSyncConnectorClient, Boolean> clientAndStatus = this.clientManager.getClient();
        try {
            resp = ((IoTDBThriftSyncConnectorClient)clientAndStatus.getLeft()).pipeTransfer((TPipeTransferReq)this.tabletBatchBuilder.toTPipeTransferReq());
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when transfer tablet batch, because %s.", e.getMessage()), (Throwable)e);
        }
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Transfer PipeTransferTabletBatchReq error, result status %s", resp.status));
        }
        this.tabletBatchBuilder.onSuccess();
    }

    private void doTransfer(PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException {
        TPipeTransferResp resp;
        InsertNode insertNode;
        Pair<IoTDBThriftSyncConnectorClient, Boolean> clientAndStatus = null;
        try {
            insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
            if (insertNode != null) {
                clientAndStatus = this.clientManager.getClient(insertNode.getDevicePath().getFullPath());
                resp = ((IoTDBThriftSyncConnectorClient)clientAndStatus.getLeft()).pipeTransfer((TPipeTransferReq)PipeTransferTabletInsertNodeReq.toTPipeTransferReq(insertNode));
            } else {
                clientAndStatus = this.clientManager.getClient();
                resp = ((IoTDBThriftSyncConnectorClient)clientAndStatus.getLeft()).pipeTransfer((TPipeTransferReq)PipeTransferTabletBinaryReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer()));
            }
        }
        catch (Exception e) {
            if (clientAndStatus != null) {
                clientAndStatus.setRight((Object)false);
            }
            throw new PipeConnectionException(String.format("Network error when transfer insert node tablet insertion event, because %s.", e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Transfer PipeInsertNodeTabletInsertionEvent %s error, result status %s", pipeInsertNodeTabletInsertionEvent, status));
        }
        if (insertNode != null && status.isSetRedirectNode()) {
            this.clientManager.updateLeaderCache(insertNode.getDevicePath().getFullPath(), status.getRedirectNode());
        }
    }

    private void doTransfer(PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws PipeException {
        TPipeTransferResp resp;
        Pair<IoTDBThriftSyncConnectorClient, Boolean> clientAndStatus = this.clientManager.getClient(pipeRawTabletInsertionEvent.getDeviceId());
        try {
            resp = ((IoTDBThriftSyncConnectorClient)clientAndStatus.getLeft()).pipeTransfer((TPipeTransferReq)PipeTransferTabletRawReq.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned()));
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when transfer raw tablet insertion event, because %s.", e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Transfer PipeRawTabletInsertionEvent %s error, result status %s", pipeRawTabletInsertionEvent, status));
        }
        if (status.isSetRedirectNode()) {
            this.clientManager.updateLeaderCache(pipeRawTabletInsertionEvent.getDeviceId(), status.getRedirectNode());
        }
    }

    private void doTransfer(PipeTsFileInsertionEvent pipeTsFileInsertionEvent) throws PipeException, IOException {
        TPipeTransferResp resp;
        Pair<IoTDBThriftSyncConnectorClient, Boolean> clientAndStatus;
        File tsFile;
        block13: {
            tsFile = pipeTsFileInsertionEvent.getTsFile();
            clientAndStatus = this.clientManager.getClient();
            int readFileBufferSize = PipeConfig.getInstance().getPipeConnectorReadFileBufferSize();
            byte[] readBuffer = new byte[readFileBufferSize];
            long position = 0L;
            try (RandomAccessFile reader = new RandomAccessFile(tsFile, "r");){
                PipeTransferFilePieceResp resp2;
                while (true) {
                    int readLength;
                    if ((readLength = reader.read(readBuffer)) == -1) {
                        break block13;
                    }
                    try {
                        resp2 = PipeTransferFilePieceResp.fromTPipeTransferResp(((IoTDBThriftSyncConnectorClient)clientAndStatus.getLeft()).pipeTransfer((TPipeTransferReq)PipeTransferFilePieceReq.toTPipeTransferReq(tsFile.getName(), position, readLength == readFileBufferSize ? readBuffer : Arrays.copyOfRange(readBuffer, 0, readLength))));
                    }
                    catch (Exception e) {
                        clientAndStatus.setRight((Object)false);
                        throw new PipeConnectionException(String.format("Network error when transfer file %s, because %s.", tsFile, e.getMessage()), (Throwable)e);
                    }
                    position += (long)readLength;
                    if (resp2.getStatus().getCode() == TSStatusCode.PIPE_TRANSFER_FILE_OFFSET_RESET.getStatusCode()) {
                        position = resp2.getEndWritingOffset();
                        reader.seek(position);
                        LOGGER.info("Redirect file position to {}.", (Object)position);
                        continue;
                    }
                    if (resp2.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
                }
                throw new PipeException(String.format("Transfer file %s error, result status %s.", tsFile, resp2.getStatus()));
            }
        }
        try {
            resp = ((IoTDBThriftSyncConnectorClient)clientAndStatus.getLeft()).pipeTransfer((TPipeTransferReq)PipeTransferFileSealReq.toTPipeTransferReq(tsFile.getName(), tsFile.length()));
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when seal file %s, because %s.", tsFile, e.getMessage()), (Throwable)e);
        }
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Seal file %s error, result status %s.", tsFile, resp.getStatus()));
        }
        LOGGER.info("Successfully transferred file {}.", (Object)tsFile);
    }

    public void close() {
        if (this.clientManager != null) {
            this.clientManager.close();
        }
        if (this.tabletBatchBuilder != null) {
            this.tabletBatchBuilder.close();
        }
    }
}

