/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.sync;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBThriftSyncConnectorClient;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferHandshakeReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.IoTDBThriftClientManager;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThriftSyncClientManager
extends IoTDBThriftClientManager
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftSyncClientManager.class);
    private static final PipeConfig PIPE_CONFIG = PipeConfig.getInstance();
    private final boolean useSSL;
    private final String trustStorePath;
    private final String trustStorePwd;
    private final Map<TEndPoint, Pair<IoTDBThriftSyncConnectorClient, Boolean>> endPoint2ClientAndStatus = new ConcurrentHashMap<TEndPoint, Pair<IoTDBThriftSyncConnectorClient, Boolean>>();

    public IoTDBThriftSyncClientManager(List<TEndPoint> endPoints, boolean useSSL, String trustStorePath, String trustStorePwd, boolean useLeaderCache) {
        super(endPoints, useLeaderCache);
        this.useSSL = useSSL;
        this.trustStorePath = trustStorePath;
        this.trustStorePwd = trustStorePwd;
        for (TEndPoint endPoint : endPoints) {
            this.endPoint2ClientAndStatus.put(endPoint, (Pair<IoTDBThriftSyncConnectorClient, Boolean>)new Pair(null, (Object)false));
        }
    }

    public void checkClientStatusAndTryReconstructIfNecessary() throws IOException {
        for (Map.Entry<TEndPoint, Pair<IoTDBThriftSyncConnectorClient, Boolean>> entry : this.endPoint2ClientAndStatus.entrySet()) {
            if (Boolean.TRUE.equals(entry.getValue().getRight())) continue;
            this.reconstructClient(entry.getKey());
        }
        for (Pair pair : this.endPoint2ClientAndStatus.values()) {
            if (!Boolean.TRUE.equals(pair.getRight())) continue;
            return;
        }
        throw new PipeConnectionException(String.format("All target servers %s are not available.", this.endPoint2ClientAndStatus.keySet()));
    }

    private void reconstructClient(TEndPoint endPoint) throws IOException {
        Pair<IoTDBThriftSyncConnectorClient, Boolean> clientAndStatus = this.endPoint2ClientAndStatus.get(endPoint);
        if (clientAndStatus.getLeft() != null) {
            try {
                ((IoTDBThriftSyncConnectorClient)clientAndStatus.getLeft()).close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close client with target server ip: {}, port: {}, because: {}. Ignore it.", new Object[]{endPoint.getIp(), endPoint.getPort(), e.getMessage()});
            }
        }
        try {
            clientAndStatus.setLeft((Object)new IoTDBThriftSyncConnectorClient(new ThriftClientProperty.Builder().setConnectionTimeoutMs((int)PIPE_CONFIG.getPipeConnectorHandshakeTimeoutMs()).setRpcThriftCompressionEnabled(PIPE_CONFIG.isPipeConnectorRPCThriftCompressionEnabled()).build(), endPoint.getIp(), endPoint.getPort(), this.useSSL, this.trustStorePath, this.trustStorePwd));
        }
        catch (TTransportException e) {
            throw new PipeConnectionException(String.format("Error occurred while connecting to receiver %s:%s, please check network connectivity or SSL configurations when enable SSL transmission", endPoint.getIp(), endPoint.getPort()), (Throwable)e);
        }
        try {
            TPipeTransferResp resp = ((IoTDBThriftSyncConnectorClient)clientAndStatus.getLeft()).pipeTransfer((TPipeTransferReq)PipeTransferHandshakeReq.toTPipeTransferReq(CommonDescriptor.getInstance().getConfig().getTimestampPrecision()));
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.warn("Handshake error with target server ip: {}, port: {}, because: {}.", new Object[]{endPoint.getIp(), endPoint.getPort(), resp.getStatus()});
            } else {
                clientAndStatus.setRight((Object)true);
                ((IoTDBThriftSyncConnectorClient)clientAndStatus.getLeft()).setTimeout((int)PipeConfig.getInstance().getPipeConnectorTransferTimeoutMs());
                LOGGER.info("Handshake success. Target server ip: {}, port: {}", (Object)endPoint.getIp(), (Object)endPoint.getPort());
            }
        }
        catch (TException e) {
            LOGGER.warn("Handshake error with target server ip: {}, port: {}, because: {}.", new Object[]{endPoint.getIp(), endPoint.getPort(), e.getMessage(), e});
        }
    }

    public Pair<IoTDBThriftSyncConnectorClient, Boolean> getClient() {
        int clientSize = this.endPointList.size();
        for (int tryCount = 0; tryCount < clientSize; ++tryCount) {
            int clientIndex;
            Pair<IoTDBThriftSyncConnectorClient, Boolean> clientAndStatus;
            if (!Boolean.TRUE.equals((clientAndStatus = this.endPoint2ClientAndStatus.get(this.endPointList.get(clientIndex = (int)(this.currentClientIndex++ % (long)clientSize)))).getRight())) continue;
            return clientAndStatus;
        }
        throw new PipeConnectionException("All clients are dead, please check the connection to the receiver.");
    }

    public Pair<IoTDBThriftSyncConnectorClient, Boolean> getClient(String deviceId) {
        TEndPoint endPoint = leaderCacheManager.getLeaderEndPoint(deviceId);
        return this.useLeaderCache && endPoint != null && this.endPoint2ClientAndStatus.containsKey(endPoint) && Boolean.TRUE.equals(this.endPoint2ClientAndStatus.get(endPoint).getRight()) ? this.endPoint2ClientAndStatus.get(endPoint) : this.getClient();
    }

    public void updateLeaderCache(String deviceId, TEndPoint endPoint) {
        if (!this.useLeaderCache) {
            return;
        }
        try {
            if (!this.endPoint2ClientAndStatus.containsKey(endPoint)) {
                this.endPointList.add(endPoint);
                this.endPoint2ClientAndStatus.put(endPoint, (Pair<IoTDBThriftSyncConnectorClient, Boolean>)new Pair(null, (Object)false));
                this.reconstructClient(endPoint);
            }
            leaderCacheManager.updateLeaderEndPoint(deviceId, endPoint);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to update leader cache for device {} with endpoint {}:{}.", new Object[]{deviceId, endPoint.getIp(), endPoint.getPort(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        for (Map.Entry<TEndPoint, Pair<IoTDBThriftSyncConnectorClient, Boolean>> entry : this.endPoint2ClientAndStatus.entrySet()) {
            TEndPoint endPoint = entry.getKey();
            Pair<IoTDBThriftSyncConnectorClient, Boolean> clientAndStatus = entry.getValue();
            if (clientAndStatus == null) continue;
            try {
                if (clientAndStatus.getLeft() != null) {
                    ((IoTDBThriftSyncConnectorClient)clientAndStatus.getLeft()).close();
                    clientAndStatus.setLeft(null);
                }
                LOGGER.info("Client {}:{} closed.", (Object)endPoint.getIp(), (Object)endPoint.getPort());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close client {}:{}, because: {}.", new Object[]{endPoint.getIp(), endPoint.getPort(), e.getMessage(), e});
            }
            finally {
                clientAndStatus.setRight((Object)false);
            }
        }
    }
}

