/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferHandshakeReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.IoTDBThriftClientManager;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThriftAsyncClientManager
extends IoTDBThriftClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftAsyncClientManager.class);
    private final Set<TEndPoint> endPointSet;
    private static final AtomicReference<IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>> ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER = new AtomicReference();
    private final IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> endPoint2Client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IoTDBThriftAsyncClientManager(List<TEndPoint> endPoints, boolean useLeaderCache) {
        super(endPoints, useLeaderCache);
        this.endPointSet = new HashSet<TEndPoint>(endPoints);
        if (ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get() == null) {
            Class<IoTDBThriftAsyncConnector> clazz = IoTDBThriftAsyncConnector.class;
            // MONITORENTER : org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector.class
            if (ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get() == null) {
                ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.set((IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>)new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.AsyncPipeDataTransferServiceClientPoolFactory()));
            }
            // MONITOREXIT : clazz
        }
        this.endPoint2Client = ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get();
    }

    public AsyncPipeDataTransferServiceClient borrowClient() throws Exception {
        AsyncPipeDataTransferServiceClient client;
        TEndPoint targetNodeUrl;
        int clientSize = this.endPointList.size();
        while (!this.handshakeIfNecessary(targetNodeUrl = (TEndPoint)this.endPointList.get((int)(this.currentClientIndex++ % (long)clientSize)), client = (AsyncPipeDataTransferServiceClient)this.endPoint2Client.borrowClient((Object)targetNodeUrl))) {
        }
        return client;
    }

    public AsyncPipeDataTransferServiceClient borrowClient(String deviceId) throws Exception {
        if (!this.useLeaderCache) {
            return this.borrowClient();
        }
        TEndPoint endPoint = leaderCacheManager.getLeaderEndPoint(deviceId);
        if (endPoint == null) {
            return this.borrowClient();
        }
        try {
            AsyncPipeDataTransferServiceClient client = (AsyncPipeDataTransferServiceClient)this.endPoint2Client.borrowClient((Object)endPoint);
            if (this.handshakeIfNecessary(endPoint, client)) {
                return client;
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to borrow client {}:{} for cached leader.", new Object[]{endPoint.getIp(), endPoint.getPort(), e});
        }
        return this.borrowClient();
    }

    private boolean handshakeIfNecessary(final TEndPoint targetNodeUrl, final AsyncPipeDataTransferServiceClient client) throws Exception {
        if (client.isHandshakeFinished()) {
            return true;
        }
        final AtomicBoolean isHandshakeFinished = new AtomicBoolean(false);
        final AtomicReference exception = new AtomicReference();
        client.pipeTransfer((TPipeTransferReq)PipeTransferHandshakeReq.toTPipeTransferReq(CommonDescriptor.getInstance().getConfig().getTimestampPrecision()), (AsyncMethodCallback)new AsyncMethodCallback<TPipeTransferResp>(){

            public void onComplete(TPipeTransferResp response) {
                if (response.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    LOGGER.warn("Handshake error with receiver {}:{}, code: {}, message: {}.", new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), response.getStatus().getCode(), response.getStatus().getMessage()});
                    exception.set(new PipeConnectionException(String.format("Handshake error with receiver %s:%s, code: %d, message: %s.", targetNodeUrl.getIp(), targetNodeUrl.getPort(), response.getStatus().getCode(), response.getStatus().getMessage())));
                } else {
                    LOGGER.info("Handshake successfully with receiver {}:{}.", (Object)targetNodeUrl.getIp(), (Object)targetNodeUrl.getPort());
                    client.markHandshakeFinished();
                }
                isHandshakeFinished.set(true);
            }

            public void onError(Exception e) {
                LOGGER.warn("Handshake error with receiver {}:{}.", new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), e});
                exception.set(e);
                isHandshakeFinished.set(true);
            }
        });
        try {
            while (!isHandshakeFinished.get()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PipeException("Interrupted while waiting for handshake response.", (Throwable)e);
        }
        if (exception.get() != null) {
            throw new PipeConnectionException("Failed to handshake.", (Throwable)exception.get());
        }
        return false;
    }

    public void updateLeaderCache(String deviceId, TEndPoint endPoint) {
        if (!this.useLeaderCache) {
            return;
        }
        if (!this.endPointSet.contains(endPoint)) {
            this.endPointList.add(endPoint);
            this.endPointSet.add(endPoint);
        }
        leaderCacheManager.updateLeaderEndPoint(deviceId, endPoint);
    }
}

