/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.agent.task;

import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.pipe.agent.task.PipeTaskAgent;
import org.apache.iotdb.commons.pipe.task.PipeTask;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.pipe.task.PipeConfigNodeTask;
import org.apache.iotdb.confignode.manager.pipe.task.PipeConfigNodeTaskBuilder;
import org.apache.iotdb.confignode.manager.pipe.task.PipeConfigNodeTaskStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskConfigNodeAgent
extends PipeTaskAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskConfigNodeAgent.class);

    protected boolean isShutdown() {
        return false;
    }

    protected Map<TConsensusGroupId, PipeTask> buildPipeTasks(PipeMeta pipeMetaFromConfigNode) {
        return new PipeConfigNodeTaskBuilder(pipeMetaFromConfigNode).build();
    }

    protected void createPipeTask(TConsensusGroupId consensusGroupId, PipeStaticMeta pipeStaticMeta, PipeTaskMeta pipeTaskMeta) {
        if (consensusGroupId.getType() == TConsensusGroupType.ConfigRegion && pipeTaskMeta.getLeaderDataNodeId() == ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId()) {
            PipeConfigNodeTask pipeTask = new PipeConfigNodeTask(new PipeConfigNodeTaskStage(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime(), pipeStaticMeta.getExtractorParameters().getAttribute(), pipeStaticMeta.getProcessorParameters().getAttribute(), pipeStaticMeta.getConnectorParameters().getAttribute()));
            pipeTask.create();
            this.pipeTaskManager.addPipeTask(pipeStaticMeta, consensusGroupId, (PipeTask)pipeTask);
        }
        this.pipeMetaKeeper.getPipeMeta(pipeStaticMeta.getPipeName()).getRuntimeMeta().getConsensusGroupId2TaskMetaMap().put(consensusGroupId, pipeTaskMeta);
    }
}

