/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.service;

import com.google.common.eventbus.EventBus;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.balancer.RouteBalancer;
import org.apache.iotdb.confignode.manager.load.cache.LoadCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupStatistics;
import org.apache.iotdb.confignode.manager.load.subscriber.IClusterStatusSubscriber;
import org.apache.iotdb.confignode.manager.load.subscriber.RouteChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.StatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.mpp.rpc.thrift.TRegionRouteReq;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsService
implements IClusterStatusSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsService.class);
    private static final long HEARTBEAT_INTERVAL = ConfigNodeDescriptor.getInstance().getConf().getHeartbeatIntervalInMs();
    private final IManager configManager;
    private final RouteBalancer routeBalancer;
    private final LoadCache loadCache;
    private final EventBus eventBus;
    private final Object statisticsScheduleMonitor = new Object();
    private Future<?> currentLoadStatisticsFuture;
    private final ScheduledExecutorService loadStatisticsExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.CONFIG_NODE_LOAD_STATISTIC.getName());

    public StatisticsService(IManager configManager, RouteBalancer routeBalancer, LoadCache loadCache, EventBus eventBus) {
        this.configManager = configManager;
        this.routeBalancer = routeBalancer;
        this.loadCache = loadCache;
        this.eventBus = eventBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoadStatisticsService() {
        Object object = this.statisticsScheduleMonitor;
        synchronized (object) {
            if (this.currentLoadStatisticsFuture == null) {
                this.currentLoadStatisticsFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.loadStatisticsExecutor, this::updateLoadStatistics, (long)0L, (long)HEARTBEAT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("LoadStatistics service is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoadStatisticsService() {
        Object object = this.statisticsScheduleMonitor;
        synchronized (object) {
            if (this.currentLoadStatisticsFuture != null) {
                this.currentLoadStatisticsFuture.cancel(false);
                this.currentLoadStatisticsFuture = null;
                LOGGER.info("LoadStatistics service is stopped successfully.");
            }
        }
    }

    private void updateLoadStatistics() {
        Map<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> differentRegionGroupStatisticsMap;
        boolean isNeedBroadcast = false;
        Map<Integer, Pair<NodeStatistics, NodeStatistics>> differentNodeStatisticsMap = this.loadCache.updateNodeStatistics();
        if (!differentNodeStatisticsMap.isEmpty()) {
            isNeedBroadcast = true;
        }
        if (!(differentRegionGroupStatisticsMap = this.loadCache.updateRegionGroupStatistics()).isEmpty()) {
            isNeedBroadcast = true;
        }
        Map<TConsensusGroupId, Pair<Integer, Integer>> differentRegionLeaderMap = this.loadCache.updateRegionGroupLeader();
        if (isNeedBroadcast || !differentRegionLeaderMap.isEmpty() || this.loadCache.existUnreadyRegionGroup()) {
            differentRegionLeaderMap.putAll(this.routeBalancer.balanceRegionLeader());
            Map<TConsensusGroupId, Pair<TRegionReplicaSet, TRegionReplicaSet>> differentRegionPriorityMap = this.routeBalancer.balanceRegionPriority();
            if (StatisticsService.containsChangeEvent(differentRegionLeaderMap) || StatisticsService.containsChangeEvent(differentRegionPriorityMap)) {
                this.eventBus.post((Object)new RouteChangeEvent(differentRegionLeaderMap, differentRegionPriorityMap));
            }
        }
        if (isNeedBroadcast) {
            this.eventBus.post((Object)new StatisticsChangeEvent(differentNodeStatisticsMap, differentRegionGroupStatisticsMap));
            this.broadcastLatestRegionRouteMap();
        }
    }

    private static <T> boolean containsChangeEvent(Map<TConsensusGroupId, Pair<T, T>> map) {
        return !map.isEmpty() && map.values().stream().anyMatch(pair -> !Objects.equals(pair.getLeft(), pair.getRight()));
    }

    public void broadcastLatestRegionRouteMap() {
        Map<TConsensusGroupId, TRegionReplicaSet> regionPriorityMap = this.getLoadManager().getRegionPriorityMap();
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.Removing, NodeStatus.ReadOnly).forEach(onlineDataNode -> dataNodeLocationMap.put(onlineDataNode.getLocation().getDataNodeId(), onlineDataNode.getLocation()));
        long broadcastTime = System.currentTimeMillis();
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.UPDATE_REGION_ROUTE_MAP, new TRegionRouteReq(broadcastTime, regionPriorityMap), dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
    }

    private void recordNodeStatistics(Map<Integer, Pair<NodeStatistics, NodeStatistics>> differentNodeStatisticsMap) {
        LOGGER.info("[NodeStatistics] NodeStatisticsMap: ");
        for (Map.Entry<Integer, Pair<NodeStatistics, NodeStatistics>> nodeCacheEntry : differentNodeStatisticsMap.entrySet()) {
            if (Objects.equals(nodeCacheEntry.getValue().getRight(), nodeCacheEntry.getValue().getLeft())) continue;
            LOGGER.info("[NodeStatistics]\t {}: {}->{}", new Object[]{"nodeId{" + nodeCacheEntry.getKey() + "}", nodeCacheEntry.getValue().getLeft(), nodeCacheEntry.getValue().getRight()});
        }
    }

    private void recordRegionGroupStatistics(Map<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> differentRegionGroupStatisticsMap) {
        LOGGER.info("[RegionGroupStatistics] RegionGroupStatisticsMap: ");
        for (Map.Entry<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> regionGroupStatisticsEntry : differentRegionGroupStatisticsMap.entrySet()) {
            if (Objects.equals(regionGroupStatisticsEntry.getValue().getRight(), regionGroupStatisticsEntry.getValue().getLeft())) continue;
            LOGGER.info("[RegionGroupStatistics]\t RegionGroup {}: {} -> {}", new Object[]{regionGroupStatisticsEntry.getKey(), ((RegionGroupStatistics)regionGroupStatisticsEntry.getValue().getLeft()).getRegionGroupStatus(), ((RegionGroupStatistics)regionGroupStatisticsEntry.getValue().getRight()).getRegionGroupStatus()});
            List<Integer> leftIds = ((RegionGroupStatistics)regionGroupStatisticsEntry.getValue().getLeft()).getRegionIds();
            List<Integer> rightIds = ((RegionGroupStatistics)regionGroupStatisticsEntry.getValue().getRight()).getRegionIds();
            for (Integer leftId : leftIds) {
                if (!rightIds.contains(leftId)) {
                    LOGGER.info("[RegionGroupStatistics]\t Region in DataNode {}: {} -> null", (Object)leftId, (Object)((RegionGroupStatistics)regionGroupStatisticsEntry.getValue().getLeft()).getRegionStatus(leftId));
                    continue;
                }
                LOGGER.info("[RegionGroupStatistics]\t Region in DataNode {}: {} -> {}", new Object[]{leftId, ((RegionGroupStatistics)regionGroupStatisticsEntry.getValue().getLeft()).getRegionStatus(leftId), ((RegionGroupStatistics)regionGroupStatisticsEntry.getValue().getRight()).getRegionStatus(leftId)});
            }
            for (Integer rightId : rightIds) {
                if (leftIds.contains(rightId)) continue;
                LOGGER.info("[RegionGroupStatistics]\t Region in DataNode {}: null -> {}", (Object)rightId, (Object)((RegionGroupStatistics)regionGroupStatisticsEntry.getValue().getRight()).getRegionStatus(rightId));
            }
        }
    }

    @Override
    public synchronized void onClusterStatisticsChanged(StatisticsChangeEvent event) {
        this.recordNodeStatistics(event.getNodeStatisticsMap());
        this.recordRegionGroupStatistics(event.getRegionGroupStatisticsMap());
    }

    private void recordRegionLeaderMap(Map<TConsensusGroupId, Pair<Integer, Integer>> leaderMap) {
        LOGGER.info("[RegionLeader] RegionLeaderMap: ");
        for (Map.Entry<TConsensusGroupId, Pair<Integer, Integer>> regionLeaderEntry : leaderMap.entrySet()) {
            if (Objects.equals(regionLeaderEntry.getValue().getRight(), regionLeaderEntry.getValue().getLeft())) continue;
            LOGGER.info("[RegionLeader]\t {}: {}->{}", new Object[]{regionLeaderEntry.getKey(), regionLeaderEntry.getValue().getLeft(), regionLeaderEntry.getValue().getRight()});
        }
    }

    private void recordRegionPriorityMap(Map<TConsensusGroupId, Pair<TRegionReplicaSet, TRegionReplicaSet>> priorityMap) {
        LOGGER.info("[RegionPriority] RegionPriorityMap: ");
        for (Map.Entry<TConsensusGroupId, Pair<TRegionReplicaSet, TRegionReplicaSet>> regionPriorityEntry : priorityMap.entrySet()) {
            if (Objects.equals(regionPriorityEntry.getValue().getRight(), regionPriorityEntry.getValue().getLeft())) continue;
            LOGGER.info("[RegionPriority]\t {}: {}->{}", new Object[]{regionPriorityEntry.getKey(), regionPriorityEntry.getValue().getLeft() == null ? "null" : ((TRegionReplicaSet)regionPriorityEntry.getValue().getLeft()).getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList()), ((TRegionReplicaSet)regionPriorityEntry.getValue().getRight()).getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList())});
        }
    }

    @Override
    public synchronized void onRegionGroupLeaderChanged(RouteChangeEvent event) {
        this.recordRegionLeaderMap(event.getLeaderMap());
        this.recordRegionPriorityMap(event.getPriorityMap());
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }
}

