/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.node;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.cache.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.mpp.rpc.thrift.TLoadSample;

public class DataNodeHeartbeatCache
extends BaseNodeCache {
    private final AtomicReference<TLoadSample> latestLoadSample = new AtomicReference<TLoadSample>(new TLoadSample());

    public DataNodeHeartbeatCache(int dataNodeId) {
        super(dataNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateCurrentStatistics() {
        long lastSendTime;
        NodeHeartbeatSample lastSample = null;
        LinkedList linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (!this.slidingWindow.isEmpty()) {
                lastSample = (NodeHeartbeatSample)this.slidingWindow.getLast();
            }
        }
        long l = lastSendTime = lastSample == null ? 0L : lastSample.getSendTimestamp();
        if (lastSample != null && lastSample.isSetLoadSample()) {
            this.latestLoadSample.set(lastSample.getLoadSample());
        }
        NodeStatus status = null;
        String statusReason = null;
        if (lastSample != null && NodeStatus.Removing.equals((Object)lastSample.getStatus())) {
            status = NodeStatus.Removing;
        } else if (System.nanoTime() - lastSendTime > 20000000000L) {
            status = NodeStatus.Unknown;
        } else if (lastSample != null) {
            status = lastSample.getStatus();
            statusReason = lastSample.getStatusReason();
        }
        long loadScore = NodeStatus.isNormalStatus((NodeStatus)status) ? 0L : Long.MAX_VALUE;
        NodeStatistics newStatistics = new NodeStatistics(loadScore, status, statusReason);
        if (!((NodeStatistics)this.currentStatistics.get()).equals(newStatistics)) {
            this.currentStatistics.set(newStatistics);
        }
    }

    public double getFreeDiskSpace() {
        return this.latestLoadSample.get().getFreeDiskSpace();
    }
}

