/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.node;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.load.cache.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;

public class ConfigNodeHeartbeatCache
extends BaseNodeCache {
    public static final int CURRENT_NODE_ID = ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId();
    public static final NodeStatistics CURRENT_NODE_STATISTICS = new NodeStatistics(0L, NodeStatus.Running, null);

    public ConfigNodeHeartbeatCache(int configNodeId) {
        super(configNodeId);
    }

    public ConfigNodeHeartbeatCache(int configNodeId, NodeStatistics statistics) {
        super(configNodeId);
        this.previousStatistics = new AtomicReference<NodeStatistics>(statistics);
        this.currentStatistics = new AtomicReference<NodeStatistics>(statistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateCurrentStatistics() {
        if (this.nodeId == CURRENT_NODE_ID) {
            return;
        }
        NodeHeartbeatSample lastSample = null;
        LinkedList linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (!this.slidingWindow.isEmpty()) {
                lastSample = (NodeHeartbeatSample)this.slidingWindow.getLast();
            }
        }
        long lastSendTime = lastSample == null ? 0L : lastSample.getSendTimestamp();
        NodeStatus status = null;
        if (System.nanoTime() - lastSendTime > 20000000000L) {
            status = NodeStatus.Unknown;
        } else if (lastSample != null) {
            status = lastSample.getStatus();
        }
        long loadScore = NodeStatus.isNormalStatus((NodeStatus)status) ? 0L : Long.MAX_VALUE;
        NodeStatistics newStatistics = new NodeStatistics(loadScore, status, null);
        if (!((NodeStatistics)this.currentStatistics.get()).equals(newStatistics)) {
            this.currentStatistics.set(newStatistics);
        }
    }
}

