/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.grpc.internal;

import java.util.Map;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.thirdparty.com.google.common.base.Strings;
import org.apache.ratis.thirdparty.io.grpc.LoadBalancer;
import org.apache.ratis.thirdparty.io.grpc.LoadBalancerProvider;
import org.apache.ratis.thirdparty.io.grpc.NameResolver;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.internal.JsonUtil;
import org.apache.ratis.thirdparty.io.grpc.internal.PickFirstLoadBalancer;

public final class PickFirstLoadBalancerProvider
extends LoadBalancerProvider {
    private static final String NO_CONFIG = "no service config";
    private static final String SHUFFLE_ADDRESS_LIST_KEY = "shuffleAddressList";
    private static final String CONFIG_FLAG_NAME = "GRPC_EXPERIMENTAL_PICKFIRST_LB_CONFIG";
    @VisibleForTesting
    static boolean enablePickFirstConfig = !Strings.isNullOrEmpty(System.getenv("GRPC_EXPERIMENTAL_PICKFIRST_LB_CONFIG"));

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "pick_first";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new PickFirstLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        if (enablePickFirstConfig) {
            try {
                return NameResolver.ConfigOrError.fromConfig(new PickFirstLoadBalancer.PickFirstLoadBalancerConfig(JsonUtil.getBoolean(rawLoadBalancingPolicyConfig, SHUFFLE_ADDRESS_LIST_KEY)));
            }
            catch (RuntimeException e) {
                return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withCause(e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
            }
        }
        return NameResolver.ConfigOrError.fromConfig(NO_CONFIG);
    }
}

