/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.core.type;

import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.metrics.core.type.IoTDBTimerHistogramSnapshot;
import org.apache.iotdb.metrics.core.type.IoTDBTimerMBean;
import org.apache.iotdb.metrics.type.HistogramSnapshot;
import org.apache.iotdb.metrics.utils.AbstractMetricMBean;

public class IoTDBTimer
extends AbstractMetricMBean
implements org.apache.iotdb.metrics.type.Timer,
IoTDBTimerMBean {
    Timer timer;

    public IoTDBTimer(Timer timer) {
        this.timer = timer;
    }

    public void update(long duration, TimeUnit unit) {
        this.timer.record(duration, unit);
    }

    public HistogramSnapshot takeSnapshot() {
        return new IoTDBTimerHistogramSnapshot(this.timer);
    }

    @Override
    public double getSum() {
        return this.takeSnapshot().getSum();
    }

    @Override
    public double getMax() {
        return this.takeSnapshot().getMax();
    }

    @Override
    public double getMean() {
        return this.takeSnapshot().getMean();
    }

    @Override
    public int getSize() {
        return this.takeSnapshot().size();
    }

    @Override
    public double get50thPercentile() {
        return this.takeSnapshot().getValue(0.5);
    }

    @Override
    public double get99thPercentile() {
        return this.takeSnapshot().getValue(0.99);
    }

    @Override
    public long getCount() {
        return this.timer.count();
    }
}

