/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.type.Type;

public class UDFDataTypeTransformer {
    private UDFDataTypeTransformer() {
    }

    public static TSDataType transformToTsDataType(Type type) {
        return type == null ? null : TSDataType.getTsDataType((byte)type.getType());
    }

    public static List<TSDataType> transformToTsDataTypeList(List<Type> typeList) {
        return typeList == null ? null : typeList.stream().map(UDFDataTypeTransformer::transformToTsDataType).collect(Collectors.toList());
    }

    public static Type transformToUDFDataType(TSDataType tsDataType) {
        return tsDataType == null ? null : UDFDataTypeTransformer.getUDFDataType(tsDataType.getType());
    }

    public static List<Type> transformToUDFDataTypeList(List<TSDataType> tsDataTypeList) {
        return tsDataTypeList == null ? null : tsDataTypeList.stream().map(UDFDataTypeTransformer::transformToUDFDataType).collect(Collectors.toList());
    }

    private static Type getUDFDataType(byte type) {
        switch (type) {
            case 0: {
                return Type.BOOLEAN;
            }
            case 1: {
                return Type.INT32;
            }
            case 2: {
                return Type.INT64;
            }
            case 3: {
                return Type.FLOAT;
            }
            case 4: {
                return Type.DOUBLE;
            }
            case 5: {
                return Type.TEXT;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }
}

