/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.String;

import java.io.IOException;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFStrCompare
implements UDTF {
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, Type.TEXT).validateInputSeriesDataType(1, Type.TEXT);
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new MappableRowByRowAccessStrategy()).setOutputDataType(Type.INT32);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        if (row.isNull(0) || row.isNull(1)) {
            return;
        }
        collector.putInt(row.getTime(), row.getString(0).compareTo(row.getString(1)));
    }

    public Object transform(Row row) throws IOException {
        if (row.isNull(0) || row.isNull(1)) {
            return null;
        }
        return row.getString(0).compareTo(row.getString(1));
    }

    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        Binary[] inputs1 = columns[0].getBinaries();
        Binary[] inputs2 = columns[1].getBinaries();
        boolean[] isNulls1 = columns[0].isNull();
        boolean[] isNulls2 = columns[1].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls1[i] || isNulls2[i]) {
                builder.appendNull();
                continue;
            }
            String str1 = inputs1[i].getStringValue(TSFileConfig.STRING_CHARSET);
            String str2 = inputs2[i].getStringValue(TSFileConfig.STRING_CHARSET);
            builder.writeInt(str1.compareTo(str2));
        }
    }
}

