/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipePluginExecutableManager
extends ExecutableManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePluginExecutableManager.class);
    private static PipePluginExecutableManager instance = null;

    public PipePluginExecutableManager(String temporaryLibRoot, String libRoot) {
        super(temporaryLibRoot, libRoot);
    }

    public boolean isLocalJarMatched(PipePluginMeta pipePluginMeta) throws PipeException {
        String pluginName = pipePluginMeta.getPluginName();
        String md5FilePath = pluginName + ".txt";
        if (this.hasFileUnderInstallDir(md5FilePath)) {
            try {
                return this.readTextFromFileUnderTemporaryRoot(md5FilePath).equals(pipePluginMeta.getJarMD5());
            }
            catch (IOException e) {
                LOGGER.error("Failed to read md5 from txt file for pipe plugin {}", (Object)pluginName, (Object)e);
            }
        }
        try {
            String md5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(this.getInstallDir() + File.separator + pipePluginMeta.getJarName(), new String[0]), new OpenOption[0]));
            this.saveTextAsFileUnderTemporaryRoot(md5, md5FilePath);
            return md5.equals(pipePluginMeta.getJarMD5());
        }
        catch (IOException e) {
            String errorMessage = String.format("Failed to registered function %s, because error occurred when trying to compute md5 of jar file for function %s ", pluginName, pluginName);
            LOGGER.warn(errorMessage, (Throwable)e);
            throw new PipeException(errorMessage);
        }
    }

    public static synchronized PipePluginExecutableManager setupAndGetInstance(String temporaryLibRoot, String libRoot) throws IOException {
        if (instance == null) {
            SystemFileFactory.INSTANCE.makeDirIfNecessary(temporaryLibRoot);
            SystemFileFactory.INSTANCE.makeDirIfNecessary(libRoot);
            SystemFileFactory.INSTANCE.makeDirIfNecessary(libRoot + File.separator + "install");
            instance = new PipePluginExecutableManager(temporaryLibRoot, libRoot);
        }
        return instance;
    }

    public static PipePluginExecutableManager getInstance() {
        return instance;
    }
}

