/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.request;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum PipeRequestType {
    HANDSHAKE(1),
    TRANSFER_TABLET_INSERT_NODE(2),
    TRANSFER_TABLET_RAW(3),
    TRANSFER_FILE_PIECE(4),
    TRANSFER_FILE_SEAL(5),
    TRANSFER_TABLET_BATCH(6),
    TRANSFER_TABLET_BINARY(7),
    TRANSFER_SCHEMA_PLAN(8),
    TRANSFER_CONFIG_PLAN(9),
    TRANSFER_SNAPSHOT_PIECE(10),
    TRANSFER_SNAPSHOT_SEAL(11);

    private final short type;
    private static final Map<Short, PipeRequestType> TYPE_MAP;

    private PipeRequestType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public static boolean isValidatedRequestType(short type) {
        return TYPE_MAP.containsKey(type);
    }

    public static PipeRequestType valueOf(short type) {
        return TYPE_MAP.get(type);
    }

    static {
        TYPE_MAP = Arrays.stream(PipeRequestType.values()).collect(HashMap::new, (typeMap, pipeRequestType) -> typeMap.put(pipeRequestType.getType(), pipeRequestType), HashMap::putAll);
    }
}

