/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Bugsnag;
import com.bugsnag.DateUtils;
import com.bugsnag.callbacks.AppCallback;
import com.bugsnag.callbacks.Callback;
import com.bugsnag.callbacks.DeviceCallback;
import com.bugsnag.callbacks.JakartaServletCallback;
import com.bugsnag.callbacks.JavaxServletCallback;
import com.bugsnag.delivery.AsyncHttpDelivery;
import com.bugsnag.delivery.Delivery;
import com.bugsnag.delivery.HttpDelivery;
import com.bugsnag.serialization.Serializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bugsnag.class);
    private static final String HEADER_API_PAYLOAD_VERSION = "Bugsnag-Payload-Version";
    private static final String HEADER_API_KEY = "Bugsnag-Api-Key";
    private static final String HEADER_BUGSNAG_SENT_AT = "Bugsnag-Sent-At";
    public String apiKey;
    public String appType;
    public String appVersion;
    public Delivery delivery = new AsyncHttpDelivery("https://notify.bugsnag.com");
    public Delivery sessionDelivery = new AsyncHttpDelivery("https://sessions.bugsnag.com");
    public String[] filters = new String[]{"password", "secret", "Authorization", "Cookie"};
    public String[] ignoreClasses;
    public String[] notifyReleaseStages = null;
    public String[] projectPackages;
    public String releaseStage;
    public boolean sendThreads = false;
    Collection<Callback> callbacks = new ConcurrentLinkedQueue<Callback>();
    Serializer serializer = new Serializer();
    private final AtomicBoolean autoCaptureSessions = new AtomicBoolean(true);
    private final AtomicBoolean sendUncaughtExceptions = new AtomicBoolean(true);

    Configuration(String apiKey) {
        this.apiKey = apiKey;
        this.addCallback(new AppCallback(this));
        this.addCallback(new DeviceCallback());
        DeviceCallback.initializeCache();
        if (JavaxServletCallback.isAvailable()) {
            this.addCallback(new JavaxServletCallback());
        }
        if (JakartaServletCallback.isAvailable()) {
            this.addCallback(new JakartaServletCallback());
        }
    }

    boolean shouldNotifyForReleaseStage() {
        if (this.notifyReleaseStages == null) {
            return true;
        }
        List<String> stages = Arrays.asList(this.notifyReleaseStages);
        return stages.contains(this.releaseStage);
    }

    boolean shouldIgnoreClass(String className) {
        if (this.ignoreClasses == null) {
            return false;
        }
        List<String> classes = Arrays.asList(this.ignoreClasses);
        return classes.contains(className);
    }

    void addCallback(Callback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    boolean inProject(String className) {
        if (this.projectPackages != null) {
            for (String packageName : this.projectPackages) {
                if (packageName == null || !className.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    public void setAutoCaptureSessions(boolean autoCaptureSessions) {
        this.autoCaptureSessions.set(autoCaptureSessions);
    }

    public boolean shouldAutoCaptureSessions() {
        return this.autoCaptureSessions.get();
    }

    public void setSendUncaughtExceptions(boolean sendUncaughtExceptions) {
        this.sendUncaughtExceptions.set(sendUncaughtExceptions);
    }

    public boolean shouldSendUncaughtExceptions() {
        return this.sendUncaughtExceptions.get();
    }

    public void setEndpoints(String notify, String sessions) throws IllegalArgumentException {
        if (notify == null || notify.isEmpty()) {
            throw new IllegalArgumentException("Notify endpoint cannot be empty or null.");
        }
        if (this.delivery instanceof HttpDelivery) {
            ((HttpDelivery)this.delivery).setEndpoint(notify);
        } else {
            LOGGER.warn("Delivery is not instance of HttpDelivery, cannot set notify endpoint");
        }
        boolean invalidSessionsEndpoint = sessions == null || sessions.isEmpty();
        String sessionEndpoint = null;
        if (invalidSessionsEndpoint && this.autoCaptureSessions.get()) {
            LOGGER.warn("The session tracking endpoint has not been set. Session tracking is disabled");
            this.autoCaptureSessions.set(false);
        } else {
            sessionEndpoint = sessions;
        }
        if (this.sessionDelivery instanceof HttpDelivery) {
            ((HttpDelivery)this.sessionDelivery).setEndpoint(sessionEndpoint);
        } else {
            LOGGER.warn("Delivery is not instance of HttpDelivery, cannot set sessions endpoint");
        }
    }

    Map<String, String> getErrorApiHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(HEADER_API_PAYLOAD_VERSION, "4");
        map.put(HEADER_API_KEY, this.apiKey);
        map.put(HEADER_BUGSNAG_SENT_AT, DateUtils.toIso8601(new Date()));
        return map;
    }

    Map<String, String> getSessionApiHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(HEADER_API_PAYLOAD_VERSION, "1.0");
        map.put(HEADER_API_KEY, this.apiKey);
        map.put(HEADER_BUGSNAG_SENT_AT, DateUtils.toIso8601(new Date()));
        return map;
    }
}

