/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import io.airlift.slice.SizeOf;
import java.util.Arrays;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.BooleanColumn;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilderStatus;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.openjdk.jol.info.ClassLayout;

public class BooleanColumnBuilder
implements ColumnBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BooleanColumnBuilder.class).instanceSize();
    public static final BooleanColumn NULL_VALUE_BLOCK = new BooleanColumn(0, 1, new boolean[]{true}, new boolean[1]);
    private final ColumnBuilderStatus columnBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private boolean[] values = new boolean[0];
    private long retainedSizeInBytes;

    public BooleanColumnBuilder(ColumnBuilderStatus columnBuilderStatus, int expectedEntries) {
        this.columnBuilderStatus = columnBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    public ColumnBuilder writeBoolean(boolean value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(2);
        }
        return this;
    }

    public ColumnBuilder writeObject(Object value) {
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
            return this;
        }
        throw new UnSupportedDataTypeException("BooleanColumn only support Boolean data type");
    }

    public ColumnBuilder write(Column column, int index) {
        return this.writeBoolean(column.getBoolean(index));
    }

    public ColumnBuilder writeTsPrimitiveType(TsPrimitiveType value) {
        return this.writeBoolean(value.getBoolean());
    }

    public ColumnBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(2);
        }
        return this;
    }

    public Column build() {
        if (!this.hasNonNullValue) {
            return new RunLengthEncodedColumn(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new BooleanColumn(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    public TSDataType getDataType() {
        return TSDataType.BOOLEAN;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public ColumnBuilder newColumnBuilderLike(ColumnBuilderStatus columnBuilderStatus) {
        return new BooleanColumnBuilder(columnBuilderStatus, ColumnUtil.calculateBlockResetSize(this.positionCount));
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = ColumnUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((boolean[])this.values);
        if (this.columnBuilderStatus != null) {
            this.retainedSizeInBytes += (long)ColumnBuilderStatus.INSTANCE_SIZE;
        }
    }
}

