/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.config.IConfig;
import java.util.Locale;

class BrokerConfiguration {
    private final boolean allowAnonymous;
    private final boolean allowZeroByteClientId;
    private final boolean reauthorizeSubscriptionsOnConnect;
    private final int bufferFlushMillis;

    BrokerConfiguration(IConfig props) {
        this.allowAnonymous = props.boolProp("allow_anonymous", true);
        this.allowZeroByteClientId = props.boolProp("allow_zero_byte_client_id", false);
        this.reauthorizeSubscriptionsOnConnect = props.boolProp("reauthorize_subscriptions_on_connect", false);
        String bufferFlushMillisProp = props.getProperty("buffer_flush_millis");
        if (bufferFlushMillisProp != null && !bufferFlushMillisProp.isEmpty()) {
            switch (bufferFlushMillisProp.toLowerCase(Locale.ROOT)) {
                case "immediate": {
                    this.bufferFlushMillis = 0;
                    break;
                }
                case "full": {
                    this.bufferFlushMillis = -1;
                    break;
                }
                default: {
                    String errorMsg = String.format("Can't state value of %s property. Has to be 'immediate', 'full' or a number >= -1, found %s", "buffer_flush_millis", bufferFlushMillisProp);
                    try {
                        this.bufferFlushMillis = Integer.parseInt(bufferFlushMillisProp);
                        if (this.bufferFlushMillis < -1) {
                            throw new IllegalArgumentException(errorMsg);
                        }
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException(errorMsg);
                    }
                }
            }
        } else {
            this.bufferFlushMillis = props.boolProp("immediate_buffer_flush", true) ? 0 : -1;
        }
    }

    public BrokerConfiguration(boolean allowAnonymous, boolean allowZeroByteClientId, boolean reauthorizeSubscriptionsOnConnect, int bufferFlushMillis) {
        this.allowAnonymous = allowAnonymous;
        this.allowZeroByteClientId = allowZeroByteClientId;
        this.reauthorizeSubscriptionsOnConnect = reauthorizeSubscriptionsOnConnect;
        this.bufferFlushMillis = bufferFlushMillis;
    }

    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    public boolean isAllowZeroByteClientId() {
        return this.allowZeroByteClientId;
    }

    public boolean isReauthorizeSubscriptionsOnConnect() {
        return this.reauthorizeSubscriptionsOnConnect;
    }

    public int getBufferFlushMillis() {
        return this.bufferFlushMillis;
    }
}

