/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.task.PipeTask;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;

public class PipeTaskManager {
    private final Map<PipeStaticMeta, Map<TConsensusGroupId, PipeTask>> pipeMap = new HashMap<PipeStaticMeta, Map<TConsensusGroupId, PipeTask>>();
    private volatile int leaderRegionCount = 0;

    public synchronized void addPipeTask(PipeStaticMeta pipeStaticMeta, TConsensusGroupId consensusGroupId, PipeTask pipeTask) {
        Map regionId2PipeTask = this.pipeMap.computeIfAbsent(pipeStaticMeta, k -> new HashMap());
        regionId2PipeTask.put(consensusGroupId, pipeTask);
        this.leaderRegionCount = Math.max(this.leaderRegionCount, regionId2PipeTask.size());
    }

    public synchronized void addPipeTasks(PipeStaticMeta pipeStaticMeta, Map<TConsensusGroupId, PipeTask> pipeTasks) {
        Map regionId2PipeTask = this.pipeMap.computeIfAbsent(pipeStaticMeta, k -> new HashMap());
        regionId2PipeTask.putAll(pipeTasks);
        this.leaderRegionCount = Math.max(this.leaderRegionCount, regionId2PipeTask.size());
    }

    public synchronized PipeTask removePipeTask(PipeStaticMeta pipeStaticMeta, TConsensusGroupId consensusGroupId) {
        Map<TConsensusGroupId, PipeTask> consensusGroupIdPipeTaskMap = this.pipeMap.get(pipeStaticMeta);
        if (consensusGroupIdPipeTaskMap != null) {
            return consensusGroupIdPipeTaskMap.remove(consensusGroupId);
        }
        return null;
    }

    public synchronized Map<TConsensusGroupId, PipeTask> removePipeTasks(PipeStaticMeta pipeStaticMeta) {
        return this.pipeMap.remove(pipeStaticMeta);
    }

    public synchronized PipeTask getPipeTask(PipeStaticMeta pipeStaticMeta, TConsensusGroupId consensusGroupId) {
        Map<TConsensusGroupId, PipeTask> consensusGroupIdPipeTaskMap = this.pipeMap.get(pipeStaticMeta);
        if (consensusGroupIdPipeTaskMap != null) {
            return consensusGroupIdPipeTaskMap.get(consensusGroupId);
        }
        return null;
    }

    public synchronized Map<TConsensusGroupId, PipeTask> getPipeTasks(PipeStaticMeta pipeStaticMeta) {
        return this.pipeMap.get(pipeStaticMeta);
    }

    public int getLeaderRegionCount() {
        return this.leaderRegionCount;
    }
}

