/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.pipe.api.customizer.parameter;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PipeParameters {
    private final Map<String, String> attributes;

    public PipeParameters(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Map<String, String> getAttribute() {
        return this.attributes;
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key) || this.attributes.containsKey(KeyReducer.reduce(key));
    }

    public boolean hasAnyAttributes(String ... keys) {
        for (String key : keys) {
            if (!this.hasAttribute(key)) continue;
            return true;
        }
        return false;
    }

    public String getString(String key) {
        String value = this.attributes.get(key);
        return value != null ? value : this.attributes.get(KeyReducer.reduce(key));
    }

    public Boolean getBoolean(String key) {
        String value = this.getString(key);
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public Integer getInt(String key) {
        String value = this.getString(key);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public Long getLong(String key) {
        String value = this.getString(key);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public Float getFloat(String key) {
        String value = this.getString(key);
        return value == null ? null : Float.valueOf(Float.parseFloat(value));
    }

    public Double getDouble(String key) {
        String value = this.getString(key);
        return value == null ? null : Double.valueOf(Double.parseDouble(value));
    }

    public String getStringByKeys(String ... keys) {
        for (String key : keys) {
            String value = this.getString(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Boolean getBooleanByKeys(String ... keys) {
        for (String key : keys) {
            Boolean value = this.getBoolean(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Integer getIntByKeys(String ... keys) {
        for (String key : keys) {
            Integer value = this.getInt(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Long getLongByKeys(String ... keys) {
        for (String key : keys) {
            Long value = this.getLong(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Float getFloatByKeys(String ... keys) {
        for (String key : keys) {
            Float value = this.getFloat(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Double getDoubleByKeys(String ... keys) {
        for (String key : keys) {
            Double value = this.getDouble(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public String getStringOrDefault(String key, String defaultValue) {
        String value = this.getString(key);
        return value == null ? defaultValue : value;
    }

    public boolean getBooleanOrDefault(String key, boolean defaultValue) {
        String value = this.getString(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public int getIntOrDefault(String key, int defaultValue) {
        String value = this.getString(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public long getLongOrDefault(String key, long defaultValue) {
        String value = this.getString(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public float getFloatOrDefault(String key, float defaultValue) {
        String value = this.getString(key);
        return value == null ? defaultValue : Float.parseFloat(value);
    }

    public double getDoubleOrDefault(String key, double defaultValue) {
        String value = this.getString(key);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    public String getStringOrDefault(List<String> keys, String defaultValue) {
        for (String key : keys) {
            String value = this.getString(key);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    public boolean getBooleanOrDefault(List<String> keys, boolean defaultValue) {
        for (String key : keys) {
            String value = this.getString(key);
            if (value == null) continue;
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public int getIntOrDefault(List<String> keys, int defaultValue) {
        for (String key : keys) {
            String value = this.getString(key);
            if (value == null) continue;
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public long getLongOrDefault(List<String> keys, long defaultValue) {
        for (String key : keys) {
            String value = this.getString(key);
            if (value == null) continue;
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public float getFloatOrDefault(List<String> keys, float defaultValue) {
        for (String key : keys) {
            String value = this.getString(key);
            if (value == null) continue;
            return Float.parseFloat(value);
        }
        return defaultValue;
    }

    public double getDoubleOrDefault(List<String> keys, double defaultValue) {
        for (String key : keys) {
            String value = this.getString(key);
            if (value == null) continue;
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeParameters that = (PipeParameters)obj;
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return this.attributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ValueHider.hide((String)entry.getKey(), (String)entry.getValue()))).toString();
    }

    public static class ValueHider {
        private static final Set<String> KEYS = new HashSet<String>();
        private static final String PLACEHOLDER = "******";

        static String hide(String key, String value) {
            if (Objects.isNull(key)) {
                return value;
            }
            if (KEYS.contains(KeyReducer.reduce(key))) {
                return PLACEHOLDER;
            }
            return value;
        }

        static {
            KEYS.add("ssl.trust-store-pwd");
        }
    }

    private static class KeyReducer {
        private static final Set<String> PREFIXES = new HashSet<String>();

        private KeyReducer() {
        }

        static String reduce(String key) {
            if (key == null) {
                return null;
            }
            String lowerCaseKey = key.toLowerCase();
            for (String prefix : PREFIXES) {
                if (!lowerCaseKey.startsWith(prefix)) continue;
                return key.substring(prefix.length());
            }
            return key;
        }

        static {
            PREFIXES.add("extractor.");
            PREFIXES.add("source.");
            PREFIXES.add("processor.");
            PREFIXES.add("connector.");
            PREFIXES.add("sink.");
        }
    }
}

