/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FileInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.read.TsFileDeviceIterator;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;

public class CompactionEstimateUtils {
    public static FileInfo calculateFileInfo(TsFileSequenceReader reader) throws IOException {
        int totalChunkNum = 0;
        int maxChunkNum = 0;
        int maxAlignedSeriesNumInDevice = -1;
        int maxDeviceChunkNum = 0;
        TsFileDeviceIterator deviceIterator = reader.getAllDevicesIteratorWithIsAligned();
        while (deviceIterator.hasNext()) {
            int deviceChunkNum = 0;
            int alignedSeriesNumInDevice = 0;
            Pair deviceWithIsAlignedPair = deviceIterator.next();
            String device = (String)deviceWithIsAlignedPair.left;
            boolean isAlignedDevice = (Boolean)deviceWithIsAlignedPair.right;
            Iterator measurementChunkMetadataListMapIterator = reader.getMeasurementChunkMetadataListMapIterator(device);
            while (measurementChunkMetadataListMapIterator.hasNext()) {
                Map measurementChunkMetadataListMap = (Map)measurementChunkMetadataListMapIterator.next();
                if (isAlignedDevice) {
                    alignedSeriesNumInDevice += measurementChunkMetadataListMap.size();
                }
                for (Map.Entry measurementChunkMetadataList : measurementChunkMetadataListMap.entrySet()) {
                    int currentChunkMetadataListSize = ((List)measurementChunkMetadataList.getValue()).size();
                    deviceChunkNum += currentChunkMetadataListSize;
                    totalChunkNum += currentChunkMetadataListSize;
                    maxChunkNum = Math.max(maxChunkNum, currentChunkMetadataListSize);
                }
            }
            if (isAlignedDevice) {
                maxAlignedSeriesNumInDevice = Math.max(maxAlignedSeriesNumInDevice, alignedSeriesNumInDevice);
            }
            maxDeviceChunkNum = Math.max(maxDeviceChunkNum, deviceChunkNum);
        }
        long averageChunkMetadataSize = totalChunkNum == 0 ? 0L : reader.getAllMetadataSize() / (long)totalChunkNum;
        return new FileInfo(totalChunkNum, maxChunkNum, maxAlignedSeriesNumInDevice, maxDeviceChunkNum, averageChunkMetadataSize);
    }

    public static boolean addReadLock(List<TsFileResource> resources) {
        for (int i = 0; i < resources.size(); ++i) {
            TsFileResource resource = resources.get(i);
            resource.readLock();
            if (!resource.isDeleted()) continue;
            for (int j = 0; j <= i; ++j) {
                resources.get(j).readUnlock();
            }
            return false;
        }
        return true;
    }

    public static void releaseReadLock(List<TsFileResource> resources) {
        resources.forEach(TsFileResource::readUnlock);
    }
}

