/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.cq.CQState;
import org.apache.iotdb.confignode.rpc.thrift.TCQEntry;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class ShowContinuousQueriesTask
implements IConfigTask {
    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showContinuousQueries();
    }

    public static void buildTsBlock(List<TCQEntry> cqList, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showContinuousQueriesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        if (cqList != null && !cqList.isEmpty()) {
            TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
            ColumnBuilder[] columnBuilders = builder.getValueColumnBuilders();
            for (TCQEntry cqEntry : cqList) {
                timeColumnBuilder.writeLong(0L);
                columnBuilders[0].writeBinary(BytesUtils.valueOf((String)cqEntry.getCqId()));
                columnBuilders[1].writeBinary(BytesUtils.valueOf((String)cqEntry.getSql()));
                columnBuilders[2].writeBinary(BytesUtils.valueOf((String)CQState.values()[cqEntry.getState()].toString()));
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowContinuousQueriesHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

