/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree.node;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.iotdb.commons.schema.tree.ITreeNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaEntityNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaMeasurementNode;

public abstract class SchemaNode
implements ITreeNode {
    public static final byte SCHEMA_INTERNAL_NODE = 0;
    public static final byte SCHEMA_ENTITY_NODE = 1;
    public static final byte SCHEMA_MEASUREMENT_NODE = 2;
    protected final String name;

    protected SchemaNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract SchemaNode getChild(String var1);

    public void addChild(String name, SchemaNode child) {
    }

    public abstract void replaceChild(String var1, SchemaNode var2);

    public abstract void copyDataTo(SchemaNode var1);

    public Map<String, SchemaNode> getChildren() {
        return Collections.emptyMap();
    }

    public Iterator<SchemaNode> getChildrenIterator() {
        return Collections.emptyIterator();
    }

    public boolean isEntity() {
        return false;
    }

    public boolean isMeasurement() {
        return false;
    }

    public SchemaEntityNode getAsEntityNode() {
        throw new UnsupportedOperationException("This node isn't instance of SchemaEntityNode.");
    }

    public SchemaMeasurementNode getAsMeasurementNode() {
        throw new UnsupportedOperationException("This node isn't instance of SchemaMeasurementNode.");
    }

    public abstract byte getType();

    public abstract void serialize(OutputStream var1) throws IOException;
}

