/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.downsampling;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.AtomicDouble;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.utils.MemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialPathLastTimeCache
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartialPathLastTimeCache.class);
    private final PipeMemoryBlock allocatedMemoryBlock;
    private final AtomicDouble memoryUsageCheatFactor = new AtomicDouble(1.0);
    private final Cache<String, Long> partialPath2TimeCache;

    public PartialPathLastTimeCache(long memoryLimitInBytes) {
        this.allocatedMemoryBlock = PipeResourceManager.memory().tryAllocate(memoryLimitInBytes).setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 1L)).setShrinkCallback((oldMemory, newMemory) -> {
            this.memoryUsageCheatFactor.set(this.memoryUsageCheatFactor.get() * ((double)oldMemory.longValue() / (double)newMemory.longValue()));
            LOGGER.info("PartialPathLastTimeCache.allocatedMemoryBlock has shrunk from {} to {}.", oldMemory, newMemory);
        }).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, memoryLimitInBytes)).setExpandCallback((oldMemory, newMemory) -> {
            this.memoryUsageCheatFactor.set(this.memoryUsageCheatFactor.get() / ((double)newMemory.longValue() / (double)oldMemory.longValue()));
            LOGGER.info("PartialPathLastTimeCache.allocatedMemoryBlock has expanded from {} to {}.", oldMemory, newMemory);
        });
        this.partialPath2TimeCache = Caffeine.newBuilder().maximumWeight(this.allocatedMemoryBlock.getMemoryUsageInBytes()).weigher((partialPath, timeStamp) -> {
            long weightInLong = (long)((double)(MemUtils.getStringMem(partialPath) + 8L) * this.memoryUsageCheatFactor.get());
            if (weightInLong <= 0L) {
                return Integer.MAX_VALUE;
            }
            int weightInInt = (int)weightInLong;
            return (long)weightInInt != weightInLong ? Integer.MAX_VALUE : weightInInt;
        }).build();
    }

    public Long getPartialPathLastTime(String partialPath) {
        return (Long)this.partialPath2TimeCache.getIfPresent((Object)partialPath);
    }

    public void setPartialPathLastTime(String partialPath, long timeStamp) {
        this.partialPath2TimeCache.put((Object)partialPath, (Object)timeStamp);
    }

    @Override
    public void close() throws Exception {
        this.partialPath2TimeCache.invalidateAll();
        this.allocatedMemoryBlock.close();
    }
}

